/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.client.models.entity;

import com.barlinc.unusual_prehistory.client.animations.megalania.MegalaniaAnimations;
import com.barlinc.unusual_prehistory.client.animations.megalania.MegalaniaIdleAnimations;
import com.barlinc.unusual_prehistory.client.models.entity.base.UP2Model;
import com.barlinc.unusual_prehistory.entity.Megalania;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MegalaniaModel
extends UP2Model<Megalania> {
    private final ModelPart root;
    private final ModelPart body_main;
    private final ModelPart body_upper;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart tongue;
    private final ModelPart tail1_rot;
    private final ModelPart tail1;
    private final ModelPart tail2_rot;
    private final ModelPart tail2;
    private final ModelPart tail3_rot;
    private final ModelPart tail3;
    private final ModelPart arm_control;
    private final ModelPart left_arm1;
    private final ModelPart left_arm2;
    private final ModelPart right_arm1;
    private final ModelPart right_arm2;
    private final ModelPart leg_control;
    private final ModelPart left_leg1;
    private final ModelPart left_leg2;
    private final ModelPart right_leg1;
    private final ModelPart right_leg2;

    public MegalaniaModel(ModelPart root) {
        super(0.5f, 24.0f);
        this.root = root.m_171324_("root");
        this.body_main = this.root.m_171324_("body_main");
        this.body_upper = this.body_main.m_171324_("body_upper");
        this.body = this.body_upper.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.tongue = this.jaw.m_171324_("tongue");
        this.tail1_rot = this.body.m_171324_("tail1_rot");
        this.tail1 = this.tail1_rot.m_171324_("tail1");
        this.tail2_rot = this.tail1.m_171324_("tail2_rot");
        this.tail2 = this.tail2_rot.m_171324_("tail2");
        this.tail3_rot = this.tail2.m_171324_("tail3_rot");
        this.tail3 = this.tail3_rot.m_171324_("tail3");
        this.arm_control = this.body_upper.m_171324_("arm_control");
        this.left_arm1 = this.arm_control.m_171324_("left_arm1");
        this.left_arm2 = this.left_arm1.m_171324_("left_arm2");
        this.right_arm1 = this.arm_control.m_171324_("right_arm1");
        this.right_arm2 = this.right_arm1.m_171324_("right_arm2");
        this.leg_control = this.body_main.m_171324_("leg_control");
        this.left_leg1 = this.leg_control.m_171324_("left_leg1");
        this.left_leg2 = this.left_leg1.m_171324_("left_leg2");
        this.right_leg1 = this.leg_control.m_171324_("right_leg1");
        this.right_leg2 = this.right_leg1.m_171324_("right_leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_main = root.m_171599_("body_main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-13.5f, (float)0.0f));
        PartDefinition body_upper = body_main.m_171599_("body_upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)9.5f));
        PartDefinition body = body_upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.5f, -7.5f, -15.5f, 19.0f, 15.0f, 31.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)-9.5f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(89, 46).m_171488_(-3.0f, 0.0f, -13.0f, 6.0f, 11.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)-15.5f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(90, 111).m_171488_(-3.5f, 0.0f, -16.0f, 7.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(88, 70).m_171488_(-4.5f, 0.0f, -8.0f, 9.0f, 3.0f, 8.0f, new CubeDeformation(0.01f)).m_171514_(102, 96).m_171488_(-2.5f, 2.5f, -15.0f, 5.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(28, 114).m_171488_(-4.5f, 3.0f, -4.0f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(60, 111).m_171488_(-3.5f, 0.0f, -12.0f, 7.0f, 4.0f, 8.0f, new CubeDeformation(0.01f)).m_171514_(112, 114).m_171488_(-2.5f, -0.5f, -11.0f, 5.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(116, 81).m_171488_(-4.5f, 0.0f, -4.0f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-4.0f));
        PartDefinition tongue = jaw.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(11, 54).m_171488_(-1.5f, -0.01f, -9.0f, 3.0f, 0.0f, 9.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition tail1_rot = body.m_171599_("tail1_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)15.5f));
        PartDefinition tail1 = tail1_rot.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-5.5f, -4.0f, -4.0f, 11.0f, 7.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail2_rot = tail1.m_171599_("tail2_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)29.0f));
        PartDefinition tail2 = tail2_rot.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(60, 86).m_171488_(-4.0f, -2.5f, 0.0f, 8.0f, 5.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3_rot = tail2.m_171599_("tail3_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)20.0f));
        PartDefinition tail3 = tail3_rot.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(0, 86).m_171488_(-3.0f, -2.0f, 0.0f, 6.0f, 4.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm_control = body_upper.m_171599_("arm_control", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-19.0f));
        PartDefinition left_arm1 = arm_control.m_171599_("left_arm1", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.5f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm2 = left_arm1.m_171599_("left_arm2", CubeListBuilder.m_171558_().m_171514_(100, 36).m_171488_(-3.5f, 0.0f, -5.0f, 8.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)9.0f, (float)-1.0f));
        PartDefinition right_arm1 = arm_control.m_171599_("right_arm1", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.5f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm2 = right_arm1.m_171599_("right_arm2", CubeListBuilder.m_171558_().m_171514_(100, 36).m_171480_().m_171488_(-4.5f, 0.0f, -5.0f, 8.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)9.0f, (float)-1.0f));
        PartDefinition leg_control = body_main.m_171599_("leg_control", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)9.5f));
        PartDefinition left_leg1 = leg_control.m_171599_("left_leg1", CubeListBuilder.m_171558_().m_171514_(100, 18).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.5f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg2 = left_leg1.m_171599_("left_leg2", CubeListBuilder.m_171558_().m_171514_(0, 115).m_171488_(-4.0f, 0.0f, -5.0f, 8.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-1.0f));
        PartDefinition right_leg1 = leg_control.m_171599_("right_leg1", CubeListBuilder.m_171558_().m_171514_(100, 18).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.5f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg2 = right_leg1.m_171599_("right_leg2", CubeListBuilder.m_171558_().m_171514_(0, 115).m_171480_().m_171488_(-4.0f, 0.0f, -5.0f, 8.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(Megalania entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_20089_() != Pose.ROARING && entity.m_20089_() != UP2Poses.TAIL_WHIPPING.get()) {
            if (!entity.m_20069_()) {
                if (entity.getBehavior().equals(Behaviors.ANGRY.getName()) || entity.getBehavior().equals(Behaviors.PANIC.getName())) {
                    this.m_267799_(MegalaniaAnimations.RUN, limbSwing, limbSwingAmount, 1.0f, 2.0f);
                } else {
                    this.m_267799_(MegalaniaAnimations.WALK, limbSwing, limbSwingAmount, 2.0f, 4.0f);
                }
            } else {
                this.root.f_104203_ = headPitch * ((float)Math.PI / 180) / 2.0f;
                this.m_267799_(MegalaniaAnimations.SWIM, limbSwing, limbSwingAmount, 1.5f, 3.0f);
            }
            this.head.f_104203_ = this.head.f_104203_ + (entity.isMegalaniaLayingDown() ? 0.0f : headPitch * ((float)Math.PI / 180) / 4.0f);
            this.head.f_104204_ = this.head.f_104204_ + (entity.isMegalaniaLayingDown() ? 0.0f : netHeadYaw * ((float)Math.PI / 180) / 4.0f);
            this.neck.f_104203_ = this.neck.f_104203_ + (entity.isMegalaniaLayingDown() ? 0.0f : headPitch * ((float)Math.PI / 180) / 2.0f);
            this.neck.f_104204_ = this.neck.f_104204_ + (entity.isMegalaniaLayingDown() ? 0.0f : netHeadYaw * ((float)Math.PI / 180) / 4.0f);
        }
        if (this.f_102610_) {
            this.m_288214_(MegalaniaAnimations.BABY_TRANSFORM);
        }
        this.animateIdle(entity.idleAnimationState, MegalaniaAnimations.IDLE, ageInTicks, 1.0f, limbSwingAmount * 4.0f);
        this.m_233381_(entity.tongueAnimationState, MegalaniaIdleAnimations.TONGUE, ageInTicks);
        this.m_233381_(entity.roaringAnimationState, MegalaniaIdleAnimations.ROAR, ageInTicks);
        this.m_233381_(entity.flick1AnimationState, MegalaniaIdleAnimations.FLICK1, ageInTicks);
        this.m_233381_(entity.flick2AnimationState, MegalaniaIdleAnimations.FLICK2, ageInTicks);
        this.m_233381_(entity.yawnAnimationState, MegalaniaIdleAnimations.YAWN, ageInTicks);
        this.m_233381_(entity.layDownAnimationState, MegalaniaIdleAnimations.SIT_START, ageInTicks);
        this.m_233381_(entity.sittingAnimationState, MegalaniaIdleAnimations.SIT, ageInTicks);
        this.m_233381_(entity.standUpAnimationState, MegalaniaIdleAnimations.SIT_END, ageInTicks);
        this.m_233381_(entity.biting1AnimationState, MegalaniaAnimations.BITE1, ageInTicks);
        this.m_233381_(entity.biting2AnimationState, MegalaniaAnimations.BITE2, ageInTicks);
        this.m_233381_(entity.tailWhipAnimationState, MegalaniaAnimations.TAILWHIP, ageInTicks);
        this.m_233381_(entity.aggroAnimationState, MegalaniaAnimations.AGGRO, ageInTicks);
        this.animateIdle(entity.swimmingAnimationState, MegalaniaAnimations.SWIM, ageInTicks, 0.8f, limbSwingAmount * 3.0f);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

