/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.PrehistoricNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dromaeosaurus.DromaeosaurusAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dromaeosaurus.DromaeosaurusLeapGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dromaeosaurus.DromaeosaurusRunGoal;
import com.barlinc.unusual_prehistory.entity.ai.navigation.PrehistoricMobMoveControl;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2EntityTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Dromaeosaurus
extends PrehistoricMob {
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)0.7f, (float)0.5f);
    private int biteTicks;
    public int leapCooldown = 100 + this.m_217043_().m_188503_(400);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState biteAnimationState = new AnimationState();
    public final AnimationState fallAnimationState = new AnimationState();
    public final AnimationState startSleepingAnimationState = new AnimationState();
    public final AnimationState sleepAnimationState = new AnimationState();
    public final AnimationState wakeUpAnimationState = new AnimationState();

    public Dromaeosaurus(EntityType<? extends Dromaeosaurus> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.f_21342_ = new DromaeosaurusMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DromaeosaurusLeapGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DromaeosaurusAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 12.0f, 1.0, 1.0, entity -> entity.m_6095_().m_204039_(UP2EntityTags.DROMAEOSAURUS_AVOIDS)));
        this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.DROMAEOSAURUS_FOOD), false));
        this.f_21345_.m_25352_(6, (Goal)new DromaeosaurusRunGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new PrehistoricNearestAttackableTargetGoal<LivingEntity>((PrehistoricMob)this, LivingEntity.class, 300, true, false, entity -> entity.m_6095_().m_204039_(UP2EntityTags.DROMAEOSAURUS_TARGETS)){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !Dromaeosaurus.this.isDromaeosaurusEeping() && (Dromaeosaurus.this.m_9236_().m_46461_() || Dromaeosaurus.this.m_9236_().m_6042_().f_63854_().isPresent());
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && !Dromaeosaurus.this.isDromaeosaurusEeping() && (Dromaeosaurus.this.m_9236_().m_46461_() || Dromaeosaurus.this.m_9236_().m_6042_().f_63854_().isPresent());
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, (double)0.38f);
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        SmoothGroundPathNavigation navigation = new SmoothGroundPathNavigation((Mob)this, level);
        navigation.m_26477_(true);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    public boolean canPacifiy() {
        return true;
    }

    @Override
    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_204117_(UP2ItemTags.PACIFIES_DROMAEOSAURUS);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.DROMAEOSAURUS_FOOD);
    }

    @Override
    public SoundEvent getEatingSound() {
        return SoundEvents.f_12190_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isEepyTime()) {
                this.eep();
            } else {
                this.wakeUp();
            }
        }
        this.m_6858_(this.m_20184_().m_165924_() > 0.05);
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)60.0f);
        if (this.isDromaeosaurusEeping() && this.m_20072_()) {
            this.wakeUpInstantly();
        }
        if (this.leapCooldown > 0) {
            --this.leapCooldown;
        }
    }

    @Override
    public boolean shouldDoEepyParticles() {
        return this.isDromaeosaurusEeping();
    }

    private boolean isEepyTime() {
        return this.m_9236_().m_46462_() && this.m_21223_() > this.m_21233_() * 0.5f && !this.m_20069_() && this.m_20096_() && this.getBehavior().equals(Behaviors.IDLE.getName()) && !this.m_21523_();
    }

    @Override
    public void setupAnimationCooldowns() {
        if (this.biteTicks > 0) {
            --this.biteTicks;
        }
        if (this.biteTicks == 0 && this.m_20089_() == UP2Poses.BITING.get()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    @Override
    public void setupAnimationStates() {
        if (this.biteTicks == 0 && this.biteAnimationState.m_216984_()) {
            this.biteAnimationState.m_216973_();
        }
        this.idleAnimationState.m_246184_(!this.isDromaeosaurusEeping(), this.f_19797_);
        this.fallAnimationState.m_246184_(!this.m_20096_() && !this.m_20072_() && !this.m_6147_() && !this.m_20159_(), this.f_19797_);
        if (this.isDromaeosaurusVisuallyEeping()) {
            this.fallAnimationState.m_216973_();
            this.biteAnimationState.m_216973_();
            this.wakeUpAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (this.isVisuallyEeping()) {
                this.startSleepingAnimationState.m_216982_(this.f_19797_);
                this.sleepAnimationState.m_216973_();
            } else {
                this.startSleepingAnimationState.m_216973_();
                this.sleepAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.startSleepingAnimationState.m_216973_();
            this.sleepAnimationState.m_216973_();
            this.wakeUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        if (f_19806_.equals(accessor)) {
            if (this.m_20089_() == UP2Poses.BITING.get()) {
                this.biteAnimationState.m_216977_(this.f_19797_);
                this.biteTicks = 10;
            } else {
                this.biteAnimationState.m_216973_();
            }
        }
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)UP2Entities.DROMAEOSAURUS.get()).m_20615_((Level)level);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268671_);
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float amount) {
        this.wakeUpInstantly();
        super.m_6475_(damageSource, amount);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return pose == UP2Poses.RESTING.get() ? SITTING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public void m_7023_(@NotNull Vec3 vec3) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    protected void m_7880_(float distance) {
        if (distance > 4.0f && this.isDromaeosaurusEeping() && !this.isInPoseTransition()) {
            this.wakeUp();
        }
    }

    @Override
    public boolean refuseToMove() {
        return super.refuseToMove() || this.isDromaeosaurusEeping();
    }

    public boolean isDromaeosaurusEeping() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isDromaeosaurusVisuallyEeping() {
        return this.getPoseTime() < 0L != this.isDromaeosaurusEeping();
    }

    @Override
    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < 5L;
    }

    private boolean isVisuallyEeping() {
        return this.isDromaeosaurusEeping() && this.getPoseTime() < 5L && this.getPoseTime() >= 0L;
    }

    public void eep() {
        if (this.isDromaeosaurusEeping()) {
            return;
        }
        this.m_20124_(UP2Poses.RESTING.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void wakeUp() {
        if (!this.isDromaeosaurusEeping()) {
            return;
        }
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void wakeUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isDromaeosaurusEeping() ? (SoundEvent)UP2SoundEvents.DROMAEOSAURUS_EEPY.get() : (SoundEvent)UP2SoundEvents.DROMAEOSAURUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)UP2SoundEvents.DROMAEOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.DROMAEOSAURUS_DEATH.get();
    }

    private static class DromaeosaurusMoveControl
    extends PrehistoricMobMoveControl {
        private final Dromaeosaurus dromaeosaurus;

        public DromaeosaurusMoveControl(Dromaeosaurus dromaeosaurus) {
            super(dromaeosaurus);
            this.dromaeosaurus = dromaeosaurus;
        }

        @Override
        public void m_8126_() {
            if (!this.dromaeosaurus.refuseToMove()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.dromaeosaurus.m_21523_() && this.dromaeosaurus.isDromaeosaurusEeping() && !this.dromaeosaurus.isInPoseTransition()) {
                    this.dromaeosaurus.wakeUp();
                }
                super.m_8126_();
            }
        }
    }
}

