/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.LargePanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.TalpanasFloatGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.TalpanasSeekShelterGoal;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.base.BreedableMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2EntityTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Talpanas
extends BreedableMob {
    private int peckingTimer = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flapAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState peckingAnimationState = new AnimationState();

    public Talpanas(EntityType<? extends BreedableMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, 1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.24);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TalpanasFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LargePanicGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 1.2, 1.2, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 4.0f, 1.2, 1.2, entity -> entity.m_6095_().m_204039_(UP2EntityTags.TALPANAS_AVOIDS)));
        this.f_21345_.m_25352_(3, (Goal)new TalpanasSeekShelterGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(UP2ItemTags.TALPANAS_FOOD), false));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        SmoothGroundPathNavigation navigation = new SmoothGroundPathNavigation((Mob)this, level);
        navigation.m_26490_(true);
        return navigation;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.85f : dimensions.f_20378_ * 0.92f;
    }

    @Override
    public double m_20204_() {
        return this.m_6162_() ? 0.2 : 0.4;
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
            if (this.m_142319_().m_146945_()) {
                this.m_146850_(GameEvent.f_157815_);
            }
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, @NotNull DamageSource source) {
        return false;
    }

    public boolean isPecking() {
        return this.getFlag(16);
    }

    public void setPecking(boolean pecking) {
        this.setFlag(16, pecking);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)UP2Entities.TALPANAS.get()).m_20615_((Level)serverLevel);
    }

    @Override
    public void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_20096_(), this.f_19797_);
        this.flapAnimationState.m_246184_(!this.m_20096_() && !this.m_20072_(), this.f_19797_);
        this.swimmingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
        this.peckingAnimationState.m_246184_(!this.m_20072_() && this.m_20096_() && this.isPecking(), this.f_19797_);
    }

    @Override
    public void setupAnimationCooldowns() {
        if (!this.m_20072_() && this.m_20096_() && this.getBehavior().equals(Behaviors.IDLE.getName()) && !this.isPecking() && this.f_19796_.m_188503_(500) == 0 && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_)) {
            this.setPecking(true);
        }
        if (this.isPecking() && this.peckingTimer++ > 40) {
            this.peckingTimer = 0;
            this.setPecking(false);
        }
    }

    @Override
    public boolean refuseToMove() {
        return super.refuseToMove() || this.isPecking();
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268612_);
    }

    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.TALPANAS_FOOD);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)UP2SoundEvents.TALPANAS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)UP2SoundEvents.TALPANAS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.TALPANAS_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(SoundEvents.f_11754_, 0.06f, 1.0f);
    }
}

