/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.RandomFlightGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.TelecrexScatterGoal;
import com.barlinc.unusual_prehistory.entity.ai.navigation.FlyingPathNavigationNoSpin;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.ai.navigation.TelecrexMoveControl;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricFlyingMob;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class Telecrex
extends PrehistoricFlyingMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flyingAnimationState = new AnimationState();
    public final AnimationState lookoutAnimationState = new AnimationState();
    public final AnimationState peckingAnimationState = new AnimationState();
    private int peckingTimer = 0;
    private int lookoutTimer = 0;

    public Telecrex(EntityType<? extends PrehistoricFlyingMob> entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(false);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    @Override
    public void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new SmoothGroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new TelecrexMoveControl(this);
            this.f_21344_ = new FlyingPathNavigationNoSpin((Mob)this, this.m_9236_(), 1.0f);
            this.isLandNavigator = false;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TelecrexScatterGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.TELECREX_FOOD), false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !Telecrex.this.m_29443_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomFlightGoal(this, 0.75f, 16, 4, 2000, 200));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && source.m_7639_() != null) {
            double range = 8.0;
            this.setFlying(true);
            List list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(range, range / 2.0, range));
            for (Telecrex telecrex : list) {
                telecrex.setFlying(true);
            }
        }
        return hurt;
    }

    @Override
    public void setupAnimationCooldowns() {
        if (!(this.m_20072_() || this.m_29443_() || this.isPecking() || this.isLooking())) {
            if (this.f_19796_.m_188503_(500) == 0 && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_)) {
                this.setPecking(true);
            }
            if (this.f_19796_.m_188503_(600) == 0) {
                this.setLooking(true);
            }
        }
        if (this.isPecking() && this.peckingTimer++ > 40) {
            this.peckingTimer = 0;
            this.setPecking(false);
        }
        if (this.isLooking() && this.lookoutTimer++ > 40) {
            this.lookoutTimer = 0;
            this.setLooking(false);
        }
    }

    @Override
    public boolean refuseToMove() {
        return super.m_6107_() || this.isPecking() || this.isLooking();
    }

    @Override
    public void setupAnimationStates() {
        this.idleAnimationState.m_246184_(!this.m_29443_() && !this.isPecking() && !this.isLooking(), this.f_19797_);
        this.flyingAnimationState.m_246184_(this.m_29443_(), this.f_19797_);
        this.peckingAnimationState.m_246184_(!this.m_20072_() && !this.m_29443_() && this.isPecking(), this.f_19797_);
        this.lookoutAnimationState.m_246184_(!this.m_20072_() && !this.m_29443_() && this.isLooking(), this.f_19797_);
    }

    public boolean isPecking() {
        return this.getFlag(16);
    }

    public void setPecking(boolean pecking) {
        this.setFlag(16, pecking);
    }

    public boolean isLooking() {
        return this.getFlag(32);
    }

    public void setLooking(boolean looking) {
        this.setFlag(32, looking);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.TELECREX_FOOD);
    }

    @Override
    public SoundEvent getEatingSound() {
        return SoundEvents.f_12190_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)UP2SoundEvents.TELECREX_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)UP2SoundEvents.TELECREX_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.TELECREX_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.m_5496_(SoundEvents.f_11754_, 0.06f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)UP2Entities.TELECREX.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268612_);
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }
}

