/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.ai.goals;

import com.barlinc.unusual_prehistory.entity.Majungasaurus;
import com.barlinc.unusual_prehistory.entity.ai.goals.AttackGoal;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import java.util.Objects;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MajungasaurusAttackGoal
extends AttackGoal {
    protected final Majungasaurus majungasaurus;

    public MajungasaurusAttackGoal(Majungasaurus majungasaurus) {
        super(majungasaurus);
        this.majungasaurus = majungasaurus;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.majungasaurus.exitStealth();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.majungasaurus.exitStealth();
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && !this.majungasaurus.m_6162_();
    }

    public void m_8037_() {
        LivingEntity target = this.majungasaurus.m_5448_();
        if (target != null) {
            double distanceToTarget = this.majungasaurus.m_262793_(target);
            int attackState = this.majungasaurus.getAttackState();
            this.majungasaurus.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (distanceToTarget > 50.0 && this.majungasaurus.getStealthCooldown() <= 0 && !this.majungasaurus.m_20072_()) {
                this.majungasaurus.enterStealth();
                this.majungasaurus.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (distanceToTarget <= 50.0 || this.majungasaurus.getStealthCooldown() > 0) {
                this.majungasaurus.exitStealth();
                this.majungasaurus.m_21573_().m_5624_((Entity)target, 1.7);
            }
            if (attackState == 1) {
                this.tickBite();
            } else if (distanceToTarget <= this.getAttackReachSqr(target)) {
                this.majungasaurus.setAttackState(1);
            }
        }
    }

    protected void tickBite() {
        ++this.timer;
        LivingEntity target = this.majungasaurus.m_5448_();
        if (this.timer == 1) {
            this.majungasaurus.m_20124_(UP2Poses.BITING.get());
        }
        if (this.timer == 9) {
            this.majungasaurus.m_5496_((SoundEvent)UP2SoundEvents.MAJUNGASAURUS_BITE.get(), 1.0f, this.majungasaurus.m_6100_());
        }
        if (this.timer == 11 && (double)this.majungasaurus.m_20270_((Entity)Objects.requireNonNull(target)) < this.getAttackReachSqr(target)) {
            this.majungasaurus.m_7327_((Entity)target);
            this.majungasaurus.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.timer > 22) {
            this.timer = 0;
            this.majungasaurus.setAttackState(0);
        }
    }

    @Override
    protected double getAttackReachSqr(LivingEntity target) {
        return (double)(this.mob.m_20205_() * 1.8f * this.mob.m_20205_()) * 1.8 + (double)target.m_20205_();
    }
}

