/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus;

import com.barlinc.unusual_prehistory.entity.Carnotaurus;
import com.barlinc.unusual_prehistory.entity.ai.goals.AttackGoal;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CarnotaurusChargeGoal
extends AttackGoal {
    private final Carnotaurus carnotaurus;
    private int collisionTicks;
    private Vec3 chargeDirection = Vec3.f_82478_;

    public CarnotaurusChargeGoal(Carnotaurus carnotaurus) {
        super(carnotaurus);
        this.carnotaurus = carnotaurus;
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.carnotaurus.getChargeCooldown() == 0 && this.carnotaurus.m_20089_() == Pose.STANDING && !this.carnotaurus.m_20069_() && this.carnotaurus.isWithinYRange(this.carnotaurus.m_5448_());
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.carnotaurus.getChargeCooldown() == 0 && !this.carnotaurus.m_20069_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.collisionTicks = 0;
        this.carnotaurus.setCharging(false);
        this.carnotaurus.m_20124_(Pose.STANDING);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.collisionTicks = 0;
        this.carnotaurus.setCharging(false);
        this.carnotaurus.m_20124_(Pose.STANDING);
        this.carnotaurus.chargeCooldown();
    }

    public void m_8037_() {
        LivingEntity target = this.carnotaurus.m_5448_();
        if (target != null) {
            double distance = this.carnotaurus.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            if (this.carnotaurus.isCharging()) {
                this.carnotaurus.m_21573_().m_26573_();
                ++this.timer;
                if (this.carnotaurus.f_19862_) {
                    ++this.collisionTicks;
                } else if (this.collisionTicks > 0) {
                    --this.collisionTicks;
                }
                if (this.timer == 1) {
                    this.carnotaurus.m_20124_(UP2Poses.START_CHARGING.get());
                }
                if (this.timer == 18) {
                    this.carnotaurus.m_5496_((SoundEvent)UP2SoundEvents.CARNOTAURUS_CHARGE.get(), 1.0f, this.carnotaurus.m_6100_());
                }
                if (this.timer < 20) {
                    this.carnotaurus.m_21391_((Entity)target, 360.0f, 30.0f);
                    this.carnotaurus.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
                if (this.timer > 20 && this.timer < 50) {
                    this.hurtNearbyEntities();
                }
                if (this.timer > 20 && this.timer < 55) {
                    this.chargeDirection = new Vec3(target.m_20185_() - this.carnotaurus.m_20185_(), target.m_20186_() - this.carnotaurus.m_20186_(), target.m_20189_() - this.carnotaurus.m_20189_()).m_82541_();
                    float YRot = Mth.m_14148_((float)this.carnotaurus.m_146908_(), (float)((float)(Mth.m_14136_((double)this.chargeDirection.f_82481_, (double)this.chargeDirection.f_82479_) * 57.29577951308232) - 90.0f), (float)2.5f);
                    this.carnotaurus.m_146922_(YRot);
                    this.carnotaurus.m_5618_(YRot);
                    this.carnotaurus.m_20334_(-Mth.m_14031_((float)(YRot * ((float)Math.PI / 180))) * 0.65f, this.carnotaurus.m_20184_().f_82480_, Mth.m_14089_((float)(YRot * ((float)Math.PI / 180))) * 0.65f);
                }
                if (this.timer == 55) {
                    this.carnotaurus.m_20124_(UP2Poses.STOP_CHARGING.get());
                }
                if (this.timer > 70) {
                    this.timer = 0;
                    this.carnotaurus.chargeCooldown();
                    this.carnotaurus.setCharging(false);
                }
                if (this.collisionTicks > 15) {
                    this.carnotaurus.setCharging(false);
                    this.carnotaurus.m_20124_(UP2Poses.STOP_CHARGING.get());
                    this.carnotaurus.chargeCooldown();
                    this.timer = 0;
                }
            } else {
                this.carnotaurus.m_21391_((Entity)target, 30.0f, 30.0f);
                this.carnotaurus.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (this.carnotaurus.getChargeCooldown() == 0) {
                    this.carnotaurus.m_21573_().m_5624_((Entity)target, 2.0);
                    if (distance < 80.0) {
                        this.carnotaurus.setCharging(true);
                    }
                } else {
                    this.carnotaurus.m_21573_().m_26573_();
                    this.carnotaurus.m_20124_(Pose.STANDING);
                }
            }
        }
    }

    private void hurtNearbyEntities() {
        LivingEntity entity;
        List nearbyEntities = this.carnotaurus.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.carnotaurus, this.carnotaurus.m_20191_().m_82400_(1.5));
        if (!nearbyEntities.isEmpty() && !((entity = (LivingEntity)nearbyEntities.get(0)) instanceof Carnotaurus)) {
            BlockPos pos = this.carnotaurus.m_20183_();
            Vec3 targetPos = entity.m_20182_();
            Vec3 knockbackDirection = new Vec3((double)pos.m_123341_() - targetPos.m_7096_(), 0.0, (double)pos.m_123343_() - targetPos.m_7094_()).m_82541_();
            int speedFactor = this.carnotaurus.m_21023_(MobEffects.f_19596_) ? this.carnotaurus.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
            int slownessFactor = this.carnotaurus.m_21023_(MobEffects.f_19597_) ? this.carnotaurus.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
            float effectSpeed = 0.15f * (float)(speedFactor - slownessFactor);
            float speedForce = Mth.m_14036_((float)(this.carnotaurus.m_6113_() * 1.65f), (float)0.2f, (float)3.0f) + effectSpeed;
            float knockbackForce = entity.m_21275_(this.carnotaurus.m_9236_().m_269111_().m_269333_((LivingEntity)this.carnotaurus)) ? 1.75f : 2.25f;
            entity.m_6469_(entity.m_269291_().m_269333_((LivingEntity)this.carnotaurus), (float)this.carnotaurus.m_21133_(Attributes.f_22281_));
            entity.m_147240_((double)(knockbackForce * speedForce * 2.5f), knockbackDirection.m_7096_(), knockbackDirection.m_7094_());
            if (entity.m_21275_(this.carnotaurus.m_269291_().m_269333_((LivingEntity)this.carnotaurus)) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36384_(true);
            }
            this.carnotaurus.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    @Override
    protected double getAttackReachSqr(LivingEntity target) {
        return this.carnotaurus.m_20205_() * 3.0f * this.carnotaurus.m_20205_() * 3.0f + target.m_20205_();
    }
}

