/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.ai.goals.megalania;

import com.barlinc.unusual_prehistory.entity.Megalania;
import com.barlinc.unusual_prehistory.entity.ai.goals.AttackGoal;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class MegalaniaAttackGoal
extends AttackGoal {
    private final Megalania megalania;
    private int tailWhipCooldown;
    private int biteCooldown;

    public MegalaniaAttackGoal(Megalania megalania) {
        super(megalania);
        this.megalania = megalania;
        megalania.m_21573_().m_7008_(false);
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.megalania.m_20089_() != Pose.ROARING && !this.megalania.isMegalaniaLayingDown();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.tailWhipCooldown = 0;
        this.biteCooldown = 0;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.tailWhipCooldown = 0;
        this.biteCooldown = 0;
    }

    public void m_8037_() {
        LivingEntity target = this.megalania.m_5448_();
        if (target != null) {
            this.megalania.m_21391_((Entity)this.megalania.m_5448_(), 30.0f, 30.0f);
            this.megalania.m_21563_().m_24960_((Entity)this.megalania.m_5448_(), 30.0f, 30.0f);
            double distance = this.megalania.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            int attackState = this.megalania.getAttackState();
            if (this.megalania.m_20069_()) {
                this.megalania.m_21573_().m_5624_((Entity)target, 1.2);
            } else if (this.megalania.getTemperatureState().equals((Object)Megalania.TemperatureStates.NETHER)) {
                this.megalania.m_21573_().m_5624_((Entity)target, 1.8);
            } else {
                this.megalania.m_21573_().m_5624_((Entity)target, 2.0);
            }
            if (this.biteCooldown > 0) {
                --this.biteCooldown;
            }
            if (this.tailWhipCooldown > 0 && !this.megalania.m_20069_()) {
                --this.tailWhipCooldown;
            }
            if (attackState == 1) {
                ++this.timer;
                if (this.timer == 1) {
                    this.megalania.m_20124_(UP2Poses.BITING.get());
                }
                if (this.timer == 11 && (double)this.megalania.m_20270_((Entity)Objects.requireNonNull(target)) <= this.getAttackReachSqr(target)) {
                    this.megalania.m_6674_(InteractionHand.MAIN_HAND);
                    this.megalania.m_7327_((Entity)target);
                    this.megalania.applyPoison(target);
                }
                if (this.timer > 22) {
                    this.timer = 0;
                    this.biteCooldown = 10 + this.megalania.m_217043_().m_188503_(6);
                    this.megalania.setAttackState(0);
                }
            } else if (attackState == 2) {
                ++this.timer;
                this.megalania.m_21573_().m_26573_();
                if (this.timer == 1) {
                    this.megalania.m_20124_(UP2Poses.TAIL_WHIPPING.get());
                }
                if (this.timer == 12) {
                    this.megalania.m_246865_(this.megalania.m_20154_().m_82490_(2.0).m_82542_(0.25, 0.0, 0.25));
                }
                if (this.timer == 14 && (double)this.megalania.m_20270_((Entity)Objects.requireNonNull(target)) <= this.getAttackReachSqr(target)) {
                    this.megalania.m_6674_(InteractionHand.MAIN_HAND);
                    this.megalania.m_7327_((Entity)target);
                    this.megalania.strongKnockback((Entity)target, 1.3, 0.1);
                    if (target.m_21275_(this.megalania.m_269291_().m_269333_((LivingEntity)this.megalania)) && target instanceof Player) {
                        Player player = (Player)target;
                        player.m_36384_(true);
                    }
                }
                if (this.timer > 28) {
                    this.timer = 0;
                    this.tailWhipCooldown = 20 + this.megalania.m_217043_().m_188503_(24);
                    this.megalania.setAttackState(0);
                }
            } else if (distance <= this.getAttackReachSqr(target)) {
                if (!this.megalania.m_20069_()) {
                    if (this.megalania.m_217043_().m_188501_() < 0.38f) {
                        this.megalania.setAttackState(2);
                    } else {
                        this.megalania.setAttackState(1);
                    }
                } else {
                    this.megalania.setAttackState(1);
                }
            }
        }
    }

    @Override
    protected double getAttackReachSqr(LivingEntity target) {
        return this.mob.m_20205_() * 1.75f * this.mob.m_20205_() * 1.75f + target.m_20205_();
    }
}

