/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.config;

import com.florlet.quickalias.QuickAliasLogger;
import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.core.SuggestionManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "quickalias_config.json";
    private static ConfigManager INSTANCE;
    private AliasConfig currentConfig;

    private ConfigManager() {
        this.load();
    }

    public static ConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigManager();
        }
        return INSTANCE;
    }

    public void load() {
        block13: {
            try {
                Path configDir = Minecraft.m_91087_().f_91069_.toPath().resolve("config");
                Path file = configDir.resolve(FILE_NAME);
                if (!Files.exists(configDir, new LinkOption[0])) {
                    Files.createDirectories(configDir, new FileAttribute[0]);
                }
                if (!Files.exists(file, new LinkOption[0])) break block13;
                try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                    this.currentConfig = (AliasConfig)GSON.fromJson((Reader)reader, AliasConfig.class);
                }
                catch (Exception e) {
                    QuickAliasLogger.error("QuickAlias: Failed to load config, resetting to default.", e);
                    this.currentConfig = null;
                }
            }
            catch (Exception e) {
                QuickAliasLogger.error("QuickAlias: Failed to initialize config directory.", e);
            }
        }
        if (this.currentConfig == null) {
            this.currentConfig = new AliasConfig();
            this.save();
        } else {
            SuggestionManager.getInstance().update();
        }
    }

    public void save() {
        if (this.currentConfig == null) {
            return;
        }
        try {
            Path configDir = Minecraft.m_91087_().f_91069_.toPath().resolve("config");
            Path file = configDir.resolve(FILE_NAME);
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)this.currentConfig, (Appendable)writer);
            }
            SuggestionManager.getInstance().update();
        }
        catch (IOException e) {
            QuickAliasLogger.error("QuickAlias: Failed to save config.", e);
        }
    }

    public AliasConfig getConfig() {
        if (this.currentConfig == null) {
            this.load();
        }
        return this.currentConfig;
    }

    public static class AliasConfig {
        public int version = 1;
        public Settings settings = new Settings();
        public List<AliasNode> aliases = new ArrayList<AliasNode>();
    }

    public static class Settings {
        public boolean showSettingsButton = true;
        public boolean showShortcutButton = true;
        public boolean useFlatStyle = true;
    }
}

