/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.QuickAliasLogger;
import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasScrollList;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImportConfigScreen
extends Screen {
    private static final Gson GSON = new Gson();
    private final Screen parent;
    private AliasScrollList previewList;
    private ConfigManager.AliasConfig importedConfig;
    private Component statusMessage;
    private int statusColor = 0xFFFFFF;
    private boolean isPreviewVisible = false;
    private boolean showConfirmation = false;
    private int pendingImportMode = -1;
    private Button confirmBtn;
    private Button cancelConfirmBtn;
    private Button replaceBtn;
    private Button skipBtn;
    private Button overwriteBtn;
    private Button fileBtn;
    private Button closeBtn;

    public ImportConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)""));
        this.parent = parent;
        this.statusMessage = Component.m_237115_((String)"quickalias.import.select_file");
    }

    protected void m_7856_() {
        int contentTop = 40;
        int contentBottom = this.f_96544_ - 40;
        this.fileBtn = new FlatButton(10, 10, 100, 16, (Component)Component.m_237115_((String)"quickalias.import.select_file"), btn -> this.openFilePicker());
        this.m_142416_((GuiEventListener)this.fileBtn);
        this.previewList = new AliasScrollList(this.f_96541_, null, this.f_96543_, this.f_96544_, contentTop, contentBottom, 24, true);
        if (this.importedConfig != null && this.isPreviewVisible) {
            this.previewList.setImportNodes(this.importedConfig.aliases, this.getConflicts());
        }
        this.m_7787_((GuiEventListener)this.previewList);
        int bottomY = this.f_96544_ - 24;
        int btnWidth = 100;
        int gap = 10;
        int startX = (this.f_96543_ - (btnWidth * 3 + gap * 2)) / 2;
        this.replaceBtn = new FlatButton(startX, bottomY, btnWidth, 16, (Component)Component.m_237115_((String)"quickalias.import.mode.replace"), btn -> this.triggerConfirmation(0));
        this.overwriteBtn = new FlatButton(startX + btnWidth + gap, bottomY, btnWidth, 16, (Component)Component.m_237115_((String)"quickalias.import.mode.merge_overwrite"), btn -> this.triggerConfirmation(2));
        this.skipBtn = new FlatButton(startX + (btnWidth + gap) * 2, bottomY, btnWidth, 16, (Component)Component.m_237115_((String)"quickalias.import.mode.merge_skip"), btn -> this.triggerConfirmation(1));
        this.updateMainButtonsState();
        this.m_142416_((GuiEventListener)this.replaceBtn);
        this.m_142416_((GuiEventListener)this.skipBtn);
        this.m_142416_((GuiEventListener)this.overwriteBtn);
        this.closeBtn = new FlatButton(this.f_96543_ - 70, 10, 60, 16, (Component)Component.m_237115_((String)"gui.cancel"), btn -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.closeBtn);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.confirmBtn = new FlatButton(centerX - 105, centerY + 10, 100, 20, (Component)Component.m_237115_((String)"gui.continue"), btn -> {
            this.executeImport(this.pendingImportMode);
            this.showConfirmation = false;
        });
        this.cancelConfirmBtn = new FlatButton(centerX + 5, centerY + 10, 100, 20, (Component)Component.m_237115_((String)"gui.cancel"), btn -> {
            this.showConfirmation = false;
            this.pendingImportMode = -1;
            this.updateMainButtonsState();
        });
        this.m_7787_((GuiEventListener)this.confirmBtn);
        this.m_7787_((GuiEventListener)this.cancelConfirmBtn);
    }

    private void updateMainButtonsState() {
        boolean active;
        boolean bl = active = this.isPreviewVisible && !this.showConfirmation;
        if (this.replaceBtn != null) {
            this.replaceBtn.f_93623_ = active;
        }
        if (this.skipBtn != null) {
            this.skipBtn.f_93623_ = active;
        }
        if (this.overwriteBtn != null) {
            this.overwriteBtn.f_93623_ = active;
        }
        if (this.fileBtn != null) {
            boolean bl2 = this.fileBtn.f_93623_ = !this.showConfirmation;
        }
        if (this.closeBtn != null) {
            this.closeBtn.f_93623_ = !this.showConfirmation;
        }
    }

    private void triggerConfirmation(int mode) {
        this.pendingImportMode = mode;
        this.showConfirmation = true;
        this.updateMainButtonsState();
    }

    private void openFilePicker() {
        if (this.showConfirmation) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            PointerBuffer filters = MemoryUtil.memAllocPointer((int)1);
            try {
                filters.put(MemoryUtil.memASCII((CharSequence)"*.json"));
                filters.flip();
                String result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)Component.m_237115_((String)"quickalias.import.select_file").getString(), (CharSequence)"", (PointerBuffer)filters, (CharSequence)"JSON Files", (boolean)false);
                if (result != null) {
                    this.f_96541_.execute(() -> this.loadFile(new File(result)));
                }
            }
            finally {
                MemoryUtil.memFree((CustomBuffer)filters);
            }
        });
    }

    private void loadFile(File file) {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            ConfigManager.AliasConfig loaded = (ConfigManager.AliasConfig)GSON.fromJson((Reader)reader, ConfigManager.AliasConfig.class);
            this.handleLoadedConfig(loaded);
        }
        catch (Exception e) {
            QuickAliasLogger.error("Failed to load file", e);
            this.statusMessage = Component.m_237115_((String)"quickalias.import.error.io_error");
            this.statusColor = 0xFF5555;
            this.isPreviewVisible = false;
            this.m_232761_();
        }
    }

    private void handleLoadedConfig(ConfigManager.AliasConfig loaded) {
        this.importedConfig = loaded;
        if (loaded == null || loaded.aliases == null) {
            this.statusMessage = Component.m_237115_((String)"quickalias.import.error.invalid_json");
            this.statusColor = 0xFF5555;
            this.isPreviewVisible = false;
        } else if (loaded.aliases.isEmpty()) {
            this.statusMessage = Component.m_237115_((String)"quickalias.import.status.valid_zero");
            this.statusColor = 0xFFFF55;
            this.isPreviewVisible = false;
        } else {
            this.statusMessage = Component.m_237119_();
            this.isPreviewVisible = true;
            this.previewList.setImportNodes(loaded.aliases, this.getConflicts());
            this.previewList.m_93410_(0.0);
        }
        this.updateMainButtonsState();
    }

    private Set<String> getConflicts() {
        if (this.importedConfig == null) {
            return Collections.emptySet();
        }
        HashSet<String> localNames = new HashSet<String>();
        for (AliasNode node : ConfigManager.getInstance().getConfig().aliases) {
            localNames.add(node.getName().toLowerCase());
        }
        return localNames;
    }

    private void executeImport(int mode) {
        if (this.importedConfig == null) {
            return;
        }
        ConfigManager.AliasConfig currentConfig = ConfigManager.getInstance().getConfig();
        if (mode == 0) {
            currentConfig.aliases.clear();
            currentConfig.aliases.addAll(this.importedConfig.aliases);
        } else {
            for (AliasNode imported : this.importedConfig.aliases) {
                boolean exists = currentConfig.aliases.stream().anyMatch(n -> n.getName().equalsIgnoreCase(imported.getName()));
                if (exists) {
                    if (mode != 2) continue;
                    currentConfig.aliases.removeIf(n -> n.getName().equalsIgnoreCase(imported.getName()));
                    currentConfig.aliases.add(imported);
                    continue;
                }
                currentConfig.aliases.add(imported);
            }
        }
        ConfigManager.getInstance().save();
        this.f_96541_.m_91152_(this.parent);
        if (this.parent instanceof SettingsScreen) {
            ((SettingsScreen)this.parent).refreshList();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showConfirmation) {
            if (this.confirmBtn.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.cancelConfirmBtn.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private Component getModeComponent(int mode) {
        return switch (mode) {
            case 0 -> Component.m_237115_((String)"quickalias.import.mode.replace");
            case 1 -> Component.m_237115_((String)"quickalias.import.mode.merge_skip");
            case 2 -> Component.m_237115_((String)"quickalias.import.mode.merge_overwrite");
            default -> Component.m_237113_((String)"?");
        };
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isPreviewVisible) {
            this.m_280039_(guiGraphics);
            this.previewList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            guiGraphics.m_280653_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ / 2, this.statusColor);
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        if (this.showConfirmation) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            int boxW = 240;
            int boxH = 80;
            int boxX = centerX - boxW / 2;
            int boxY = centerY - boxH / 2;
            guiGraphics.m_280509_(boxX, boxY, boxX + boxW, boxY + boxH, -14540254);
            guiGraphics.m_280509_(boxX, boxY, boxX + boxW, boxY + 1, -1);
            guiGraphics.m_280509_(boxX, boxY + boxH - 1, boxX + boxW, boxY + boxH, -1);
            guiGraphics.m_280509_(boxX, boxY, boxX + 1, boxY + boxH, -1);
            guiGraphics.m_280509_(boxX + boxW - 1, boxY, boxX + boxW, boxY + boxH, -1);
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"quickalias.import.confirm.title"), centerX, boxY + 10, 0xFFFFFF);
            Component modeText = this.getModeComponent(this.pendingImportMode);
            MutableComponent msg = Component.m_237110_((String)"quickalias.import.confirm.message", (Object[])new Object[]{modeText});
            List confirmLines = this.f_96547_.m_92923_((FormattedText)msg, boxW - 10);
            int textY = boxY + 23;
            for (FormattedCharSequence line : confirmLines) {
                guiGraphics.m_280364_(this.f_96547_, line, centerX, textY, 0xAAAAAA);
                textY += 12;
            }
            this.confirmBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.cancelConfirmBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

