/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.core;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.core.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class InputHandler {
    public static boolean handleChatInput(String originalMessage) {
        int tokenIndex;
        if (!originalMessage.startsWith("/")) {
            return false;
        }
        String raw = originalMessage.substring(1).trim();
        if (raw.isEmpty()) {
            return false;
        }
        String[] tokens = raw.split("\\s+");
        if (tokens.length == 0) {
            return false;
        }
        List<AliasNode> currentScope = ConfigManager.getInstance().getConfig().aliases;
        HashMap<String, String> capturedVariables = new HashMap<String, String>();
        ArrayList<String> accumulatedCommands = new ArrayList<String>();
        boolean matchedAny = false;
        for (tokenIndex = 0; tokenIndex < tokens.length; ++tokenIndex) {
            String token = tokens[tokenIndex];
            AliasNode matchedNode = null;
            for (AliasNode node : currentScope) {
                if (node.isVariable() || node.isEndNode() || !node.getName().equalsIgnoreCase(token)) continue;
                matchedNode = node;
                break;
            }
            if (matchedNode == null) {
                for (AliasNode node : currentScope) {
                    if (!node.isVariable()) continue;
                    matchedNode = node;
                    capturedVariables.put(node.getVariableName(), token);
                    break;
                }
            }
            if (matchedNode == null) break;
            matchedAny = true;
            InputHandler.mergeCommands(accumulatedCommands, matchedNode.getCommands());
            currentScope = matchedNode.getChildren();
        }
        if (!matchedAny) {
            return false;
        }
        if (tokenIndex >= tokens.length) {
            for (AliasNode node : currentScope) {
                if (!node.isEndNode()) continue;
                InputHandler.mergeCommands(accumulatedCommands, node.getCommands());
                break;
            }
        }
        String remainingInput = "";
        if (tokenIndex < tokens.length) {
            remainingInput = String.join((CharSequence)" ", Arrays.copyOfRange(tokens, tokenIndex, tokens.length));
        }
        InputHandler.executeChain(accumulatedCommands, capturedVariables, remainingInput);
        return true;
    }

    private static void mergeCommands(List<String> accumulator, List<String> newSegments) {
        if (newSegments == null || newSegments.isEmpty()) {
            return;
        }
        if (accumulator.isEmpty()) {
            accumulator.addAll(newSegments);
        } else {
            ArrayList<Object> nextStage = new ArrayList<Object>();
            for (String base : accumulator) {
                for (String append : newSegments) {
                    if (append.isEmpty()) {
                        nextStage.add(base);
                        continue;
                    }
                    nextStage.add(base + " " + append);
                }
            }
            accumulator.clear();
            accumulator.addAll(nextStage);
        }
    }

    private static void executeChain(List<String> commands, Map<String, String> variables, String remainingInput) {
        if (commands.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        for (String rawCmd : commands) {
            if (rawCmd == null || rawCmd.trim().isEmpty()) continue;
            Object finalCmd = VariableResolver.resolve(rawCmd, variables);
            if (remainingInput != null && !remainingInput.isEmpty()) {
                finalCmd = (String)finalCmd + " " + remainingInput;
            }
            if (((String)finalCmd).isEmpty()) continue;
            if (((String)finalCmd).startsWith("/")) {
                mc.player.connection.sendCommand(((String)finalCmd).substring(1));
                continue;
            }
            mc.player.connection.sendChat((String)finalCmd);
        }
    }
}

