/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.core;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;

public class VariableResolver {
    public static String resolve(String command, Map<String, String> variables) {
        if (command == null || command.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder currentVar = new StringBuilder();
        boolean insideVar = false;
        boolean escape = false;
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (escape) {
                if (c == '{' || c == '\\') {
                    if (insideVar) {
                        currentVar.append(c);
                    } else {
                        result.append(c);
                    }
                } else if (insideVar) {
                    currentVar.append('\\').append(c);
                } else {
                    result.append('\\').append(c);
                }
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '{') {
                if (insideVar) {
                    result.append('{').append((CharSequence)currentVar);
                    currentVar.setLength(0);
                }
                insideVar = true;
                continue;
            }
            if (c == '}') {
                if (insideVar) {
                    String varName = currentVar.toString();
                    String resolved = VariableResolver.resolveSingleVariable(varName, variables);
                    result.append(resolved);
                    currentVar.setLength(0);
                    insideVar = false;
                    continue;
                }
                result.append(c);
                continue;
            }
            if (insideVar) {
                currentVar.append(c);
                continue;
            }
            result.append(c);
        }
        if (escape) {
            result.append('\\');
        }
        if (insideVar) {
            result.append('{').append((CharSequence)currentVar);
        }
        return result.toString();
    }

    private static String resolveSingleVariable(String varName, Map<String, String> variables) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        switch (varName) {
            case "X": {
                return player != null ? String.format("%.1f", player.getX()) : "{X}";
            }
            case "Y": {
                return player != null ? String.format("%.1f", player.getY()) : "{Y}";
            }
            case "Z": {
                return player != null ? String.format("%.1f", player.getZ()) : "{Z}";
            }
            case "ID": {
                return player != null ? player.getGameProfile().getName() : "{ID}";
            }
            case "DIM": {
                if (player != null) {
                    return player.level().dimension().location().toString();
                }
                return "{DIM}";
            }
        }
        if (variables != null && variables.containsKey(varName)) {
            return variables.get(varName);
        }
        return "{" + varName + "}";
    }
}

