/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasEditorScreen;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class AliasScrollList
extends ObjectSelectionList<AliasEntry> {
    private final SettingsScreen parentScreen;
    private final boolean isImportMode;
    private Set<String> conflictNames = Collections.emptySet();
    private String currentFilter = "";
    private static final Pattern CONSTANT_PATTERN = Pattern.compile("(?i)\\{(X|Y|Z|ID|DIM)}");

    public AliasScrollList(Minecraft minecraft, SettingsScreen parentScreen, int width, int height, int top, int bottom, int itemHeight) {
        this(minecraft, parentScreen, width, height, top, bottom, itemHeight, false);
    }

    public AliasScrollList(Minecraft minecraft, SettingsScreen parentScreen, int width, int height, int top, int bottom, int itemHeight, boolean isImportMode) {
        super(minecraft, width, bottom - top, top, itemHeight);
        this.parentScreen = parentScreen;
        this.isImportMode = isImportMode;
        if (!isImportMode) {
            this.refreshList();
        }
    }

    public void setFilter(String query) {
        this.currentFilter = query == null ? "" : query.trim().toLowerCase(Locale.ROOT);
        this.refreshList();
    }

    public void refreshList() {
        this.clearEntries();
        List<AliasNode> aliases = ConfigManager.getInstance().getConfig().aliases;
        for (AliasNode node : aliases) {
            if (!this.currentFilter.isEmpty() && !this.matchesRecursive(node, this.currentFilter)) continue;
            this.addEntry((AbstractSelectionList.Entry)new AliasEntry(node));
        }
    }

    private boolean matchesRecursive(AliasNode node, String query) {
        if (node.getName().toLowerCase(Locale.ROOT).contains(query)) {
            return true;
        }
        for (String cmd : node.getCommands()) {
            if (!cmd.toLowerCase(Locale.ROOT).contains(query)) continue;
            return true;
        }
        for (AliasNode child : node.getChildren()) {
            if (!this.matchesRecursive(child, query)) continue;
            return true;
        }
        return false;
    }

    public void setImportNodes(List<AliasNode> nodes, Set<String> conflicts) {
        this.clearEntries();
        Set<Object> set = this.conflictNames = conflicts == null ? Collections.emptySet() : conflicts;
        if (nodes != null) {
            for (AliasNode node : nodes) {
                this.addEntry((AbstractSelectionList.Entry)new AliasEntry(node));
            }
        }
    }

    public int getRowWidth() {
        return this.width - 20;
    }

    protected int getScrollbarPosition() {
        return this.width - 10;
    }

    private Component formatCommand(String cmd) {
        MutableComponent root = Component.empty();
        Matcher m = CONSTANT_PATTERN.matcher(cmd);
        int lastEnd = 0;
        while (m.find()) {
            if (m.start() > lastEnd) {
                root.append((Component)Component.literal((String)cmd.substring(lastEnd, m.start())).withStyle(Style.EMPTY.withColor(0xAAAAAA)));
            }
            root.append((Component)Component.literal((String)m.group()).withStyle(Style.EMPTY.withColor(0xAA55FF)));
            lastEnd = m.end();
        }
        if (lastEnd < cmd.length()) {
            root.append((Component)Component.literal((String)cmd.substring(lastEnd)).withStyle(Style.EMPTY.withColor(0xAAAAAA)));
        }
        return root;
    }

    public class AliasEntry
    extends ObjectSelectionList.Entry<AliasEntry> {
        private final AliasNode node;
        private final FlatButton upBtn;
        private final FlatButton downBtn;
        private final FlatButton editBtn;
        private final FlatButton deleteBtn;

        public AliasEntry(AliasNode node) {
            this.node = node;
            if (!AliasScrollList.this.isImportMode) {
                boolean canSort = AliasScrollList.this.currentFilter.isEmpty();
                this.upBtn = new FlatButton(0, 0, 12, 8, (Component)Component.empty(), btn -> this.move(-1));
                this.upBtn.active = canSort;
                this.downBtn = new FlatButton(0, 0, 12, 8, (Component)Component.empty(), btn -> this.move(1));
                this.downBtn.active = canSort;
                this.editBtn = new FlatButton(0, 0, 30, 16, (Component)Component.translatable((String)"quickalias.gui.edit"), btn -> Minecraft.getInstance().setScreen((Screen)new AliasEditorScreen(AliasScrollList.this.parentScreen, node, false)));
                this.deleteBtn = new FlatButton(0, 0, 16, 16, (Component)Component.literal((String)"\u00d7").withStyle(s -> s.withColor(0xFF5555)), btn -> {
                    ConfigManager.getInstance().getConfig().aliases.remove(node);
                    ConfigManager.getInstance().save();
                    AliasScrollList.this.refreshList();
                });
            } else {
                this.upBtn = null;
                this.downBtn = null;
                this.editBtn = null;
                this.deleteBtn = null;
            }
        }

        private void move(int dir) {
            if (!AliasScrollList.this.currentFilter.isEmpty()) {
                return;
            }
            List<AliasNode> list = ConfigManager.getInstance().getConfig().aliases;
            int index = list.indexOf(this.node);
            if (index >= 0 && index + dir >= 0 && index + dir < list.size()) {
                Collections.swap(list, index, index + dir);
                ConfigManager.getInstance().save();
                AliasScrollList.this.refreshList();
            }
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isSelected, float partialTick) {
            boolean hasChildren;
            int bgTop = top + 2;
            int bgBottom = top + height - 2;
            guiGraphics.fill(left, bgTop, left + width, bgBottom, 0x15FFFFFF);
            int currentX = left + 4;
            int centerY = bgTop + (bgBottom - bgTop) / 2;
            if (!AliasScrollList.this.isImportMode) {
                int btnHeight = (bgBottom - bgTop) / 2;
                if (AliasScrollList.this.currentFilter.isEmpty()) {
                    this.upBtn.setX(currentX);
                    this.upBtn.setY(bgTop);
                    this.upBtn.setHeight(btnHeight);
                    this.upBtn.render(guiGraphics, mouseX, mouseY, partialTick);
                    float scale = 0.7f;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().scale(scale, scale, 1.0f);
                    guiGraphics.drawString(Minecraft.getInstance().font, "\u25b2", (int)(((float)(currentX + 6) - (float)Minecraft.getInstance().font.width("\u25b2") * scale / 2.0f) / scale), (int)((float)(bgTop + 1) / scale), 0xFFFFFF);
                    guiGraphics.pose().popPose();
                    this.downBtn.setX(currentX);
                    this.downBtn.setY(bgTop + btnHeight);
                    this.downBtn.setHeight(btnHeight);
                    this.downBtn.render(guiGraphics, mouseX, mouseY, partialTick);
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().scale(scale, scale, 1.0f);
                    guiGraphics.drawString(Minecraft.getInstance().font, "\u25bc", (int)(((float)(currentX + 6) - (float)Minecraft.getInstance().font.width("\u25bc") * scale / 2.0f) / scale), (int)((float)(bgTop + btnHeight * 2 - 7) / scale), 0xFFFFFF);
                    guiGraphics.pose().popPose();
                }
                currentX += 16;
            }
            String nameText = "/" + this.node.getName();
            int nameColor = 0xFFFFFF;
            if (AliasScrollList.this.isImportMode && AliasScrollList.this.conflictNames.contains(this.node.getName().toLowerCase())) {
                nameColor = 0xFF5555;
            } else if (this.node.isVariable()) {
                nameColor = 0xFFAA00;
            } else if (this.node.isEndNode()) {
                nameColor = 0xAA55FF;
            }
            guiGraphics.drawString(Minecraft.getInstance().font, nameText, currentX, centerY - 4, nameColor);
            int nameWidth = Minecraft.getInstance().font.width(nameText);
            int arrowX = currentX + nameWidth + 5;
            guiGraphics.drawString(Minecraft.getInstance().font, "->", arrowX, centerY - 4, 0x888888);
            int arrowWidth = Minecraft.getInstance().font.width("->");
            int contentX = arrowX + arrowWidth + 5;
            boolean hasCommands = !this.node.getCommands().isEmpty();
            boolean bl = hasChildren = !this.node.getChildren().isEmpty();
            if (hasChildren) {
                Object displayStr;
                if (hasCommands) {
                    displayStr = String.join((CharSequence)", ", this.node.getCommands());
                } else {
                    List<String> childNames = this.node.getChildren().stream().map(AliasNode::getName).toList();
                    displayStr = "[" + String.join((CharSequence)", ", childNames) + "]";
                }
                int buttonsWidth = AliasScrollList.this.isImportMode ? 0 : 55;
                int availableWidth = left + width - contentX - buttonsWidth - 5;
                Object renderedStr = Minecraft.getInstance().font.plainSubstrByWidth((String)displayStr, availableWidth);
                if (((String)renderedStr).length() < ((String)displayStr).length()) {
                    renderedStr = (String)renderedStr + "...";
                }
                guiGraphics.drawString(Minecraft.getInstance().font, (String)renderedStr, contentX, centerY - 4, 0x55AAFF);
            } else {
                String rawCmds = String.join((CharSequence)", ", this.node.getCommands());
                int buttonsWidth = AliasScrollList.this.isImportMode ? 0 : 55;
                int availableWidth = left + width - contentX - buttonsWidth - 5;
                Component formattedCmd = AliasScrollList.this.formatCommand(rawCmds);
                Object truncatedRaw = Minecraft.getInstance().font.plainSubstrByWidth(rawCmds, availableWidth);
                if (((String)truncatedRaw).length() < rawCmds.length()) {
                    truncatedRaw = (String)truncatedRaw + "...";
                }
                Component renderComp = AliasScrollList.this.formatCommand((String)truncatedRaw);
                guiGraphics.drawString(Minecraft.getInstance().font, renderComp, contentX, centerY - 4, 0xFFFFFF);
            }
            if (!AliasScrollList.this.isImportMode) {
                int btnY = centerY - 8;
                this.deleteBtn.setX(left + width - 20);
                this.deleteBtn.setY(btnY);
                this.deleteBtn.render(guiGraphics, mouseX, mouseY, partialTick);
                this.editBtn.setX(left + width - 55);
                this.editBtn.setY(btnY);
                this.editBtn.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (AliasScrollList.this.isImportMode) {
                return false;
            }
            if (AliasScrollList.this.currentFilter.isEmpty()) {
                if (this.upBtn.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
                if (this.downBtn.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
            }
            if (this.editBtn.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (this.deleteBtn.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @NotNull
        public Component getNarration() {
            return Component.literal((String)this.node.getName());
        }
    }
}

