/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class FlatButton
extends Button {
    private final int colorNormal = 0x40000000;
    private final int colorHover = -2141891243;
    private final int colorDisabled = 0x20000000;

    public FlatButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean useFlat = ConfigManager.getInstance().getConfig().settings.useFlatStyle;
        if (useFlat) {
            this.renderFlat(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderFlat(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int textColor;
        int color = 0x40000000;
        if (!this.active) {
            color = 0x20000000;
        } else if (this.isHovered) {
            color = -2141891243;
        }
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, color);
        if (this.getMessage().getStyle().getColor() != null) {
            textColor = this.getMessage().getStyle().getColor().getValue();
            if (!this.active) {
                textColor = (textColor & 0xFEFEFE) >> 1 | 0xFF000000;
            }
        } else {
            textColor = this.active ? 0xFFFFFF : 0xA0A0A0;
        }
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, textColor);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

