/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.QuickAliasLogger;
import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasScrollList;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImportConfigScreen
extends Screen {
    private static final Gson GSON = new Gson();
    private final Screen parent;
    private AliasScrollList previewList;
    private ConfigManager.AliasConfig importedConfig;
    private Component statusMessage;
    private int statusColor = 0xFFFFFF;
    private boolean isPreviewVisible = false;
    private boolean showConfirmation = false;
    private int pendingImportMode = -1;
    private Button confirmBtn;
    private Button cancelConfirmBtn;
    private Button replaceBtn;
    private Button skipBtn;
    private Button overwriteBtn;
    private Button fileBtn;
    private Button closeBtn;

    public ImportConfigScreen(Screen parent) {
        super((Component)Component.literal((String)""));
        this.parent = parent;
        this.statusMessage = Component.translatable((String)"quickalias.import.select_file");
    }

    protected void init() {
        int contentTop = 40;
        int contentBottom = this.height - 40;
        this.fileBtn = new FlatButton(10, 10, 100, 16, (Component)Component.translatable((String)"quickalias.import.select_file"), btn -> this.openFilePicker());
        this.addRenderableWidget((GuiEventListener)this.fileBtn);
        this.previewList = new AliasScrollList(this.minecraft, null, this.width, this.height, contentTop, contentBottom, 24, true);
        if (this.importedConfig != null && this.isPreviewVisible) {
            this.previewList.setImportNodes(this.importedConfig.aliases, this.getConflicts());
        }
        this.addWidget((GuiEventListener)this.previewList);
        int bottomY = this.height - 24;
        int btnWidth = 100;
        int gap = 10;
        int startX = (this.width - (btnWidth * 3 + gap * 2)) / 2;
        this.replaceBtn = new FlatButton(startX, bottomY, btnWidth, 16, (Component)Component.translatable((String)"quickalias.import.mode.replace"), btn -> this.triggerConfirmation(0));
        this.overwriteBtn = new FlatButton(startX + btnWidth + gap, bottomY, btnWidth, 16, (Component)Component.translatable((String)"quickalias.import.mode.merge_overwrite"), btn -> this.triggerConfirmation(2));
        this.skipBtn = new FlatButton(startX + (btnWidth + gap) * 2, bottomY, btnWidth, 16, (Component)Component.translatable((String)"quickalias.import.mode.merge_skip"), btn -> this.triggerConfirmation(1));
        this.updateMainButtonsState();
        this.addRenderableWidget((GuiEventListener)this.replaceBtn);
        this.addRenderableWidget((GuiEventListener)this.skipBtn);
        this.addRenderableWidget((GuiEventListener)this.overwriteBtn);
        this.closeBtn = new FlatButton(this.width - 70, 10, 60, 16, (Component)Component.translatable((String)"gui.cancel"), btn -> this.minecraft.setScreen(this.parent));
        this.addRenderableWidget((GuiEventListener)this.closeBtn);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.confirmBtn = new FlatButton(centerX - 105, centerY + 10, 100, 20, (Component)Component.translatable((String)"gui.continue"), btn -> {
            this.executeImport(this.pendingImportMode);
            this.showConfirmation = false;
        });
        this.cancelConfirmBtn = new FlatButton(centerX + 5, centerY + 10, 100, 20, (Component)Component.translatable((String)"gui.cancel"), btn -> {
            this.showConfirmation = false;
            this.pendingImportMode = -1;
            this.updateMainButtonsState();
        });
        this.addWidget((GuiEventListener)this.confirmBtn);
        this.addWidget((GuiEventListener)this.cancelConfirmBtn);
    }

    private void updateMainButtonsState() {
        boolean active;
        boolean bl = active = this.isPreviewVisible && !this.showConfirmation;
        if (this.replaceBtn != null) {
            this.replaceBtn.active = active;
        }
        if (this.skipBtn != null) {
            this.skipBtn.active = active;
        }
        if (this.overwriteBtn != null) {
            this.overwriteBtn.active = active;
        }
        if (this.fileBtn != null) {
            boolean bl2 = this.fileBtn.active = !this.showConfirmation;
        }
        if (this.closeBtn != null) {
            this.closeBtn.active = !this.showConfirmation;
        }
    }

    private void triggerConfirmation(int mode) {
        this.pendingImportMode = mode;
        this.showConfirmation = true;
        this.updateMainButtonsState();
    }

    private void openFilePicker() {
        if (this.showConfirmation) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            PointerBuffer filters = MemoryUtil.memAllocPointer((int)1);
            try {
                filters.put(MemoryUtil.memASCII((CharSequence)"*.json"));
                filters.flip();
                String result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)Component.translatable((String)"quickalias.import.select_file").getString(), (CharSequence)"", (PointerBuffer)filters, (CharSequence)"JSON Files", (boolean)false);
                if (result != null) {
                    this.minecraft.execute(() -> this.loadFile(new File(result)));
                }
            }
            finally {
                MemoryUtil.memFree((CustomBuffer)filters);
            }
        });
    }

    private void loadFile(File file) {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            ConfigManager.AliasConfig loaded = (ConfigManager.AliasConfig)GSON.fromJson((Reader)reader, ConfigManager.AliasConfig.class);
            this.handleLoadedConfig(loaded);
        }
        catch (Exception e) {
            QuickAliasLogger.error("Failed to load file", e);
            this.statusMessage = Component.translatable((String)"quickalias.import.error.io_error");
            this.statusColor = 0xFF5555;
            this.isPreviewVisible = false;
            this.rebuildWidgets();
        }
    }

    private void handleLoadedConfig(ConfigManager.AliasConfig loaded) {
        this.importedConfig = loaded;
        if (loaded == null || loaded.aliases == null) {
            this.statusMessage = Component.translatable((String)"quickalias.import.error.invalid_json");
            this.statusColor = 0xFF5555;
            this.isPreviewVisible = false;
        } else if (loaded.aliases.isEmpty()) {
            this.statusMessage = Component.translatable((String)"quickalias.import.status.valid_zero");
            this.statusColor = 0xFFFF55;
            this.isPreviewVisible = false;
        } else {
            this.statusMessage = Component.empty();
            this.isPreviewVisible = true;
            this.previewList.setImportNodes(loaded.aliases, this.getConflicts());
            this.previewList.setScrollAmount(0.0);
        }
        this.updateMainButtonsState();
    }

    private Set<String> getConflicts() {
        if (this.importedConfig == null) {
            return Collections.emptySet();
        }
        HashSet<String> localNames = new HashSet<String>();
        for (AliasNode node : ConfigManager.getInstance().getConfig().aliases) {
            localNames.add(node.getName().toLowerCase());
        }
        return localNames;
    }

    private void executeImport(int mode) {
        if (this.importedConfig == null) {
            return;
        }
        ConfigManager.AliasConfig currentConfig = ConfigManager.getInstance().getConfig();
        if (mode == 0) {
            currentConfig.aliases.clear();
            currentConfig.aliases.addAll(this.importedConfig.aliases);
        } else {
            for (AliasNode imported : this.importedConfig.aliases) {
                boolean exists = currentConfig.aliases.stream().anyMatch(n -> n.getName().equalsIgnoreCase(imported.getName()));
                if (exists) {
                    if (mode != 2) continue;
                    currentConfig.aliases.removeIf(n -> n.getName().equalsIgnoreCase(imported.getName()));
                    currentConfig.aliases.add(imported);
                    continue;
                }
                currentConfig.aliases.add(imported);
            }
        }
        ConfigManager.getInstance().save();
        this.minecraft.setScreen(this.parent);
        if (this.parent instanceof SettingsScreen) {
            ((SettingsScreen)this.parent).refreshList();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.showConfirmation) {
            if (this.confirmBtn.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (this.cancelConfirmBtn.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private Component getModeComponent(int mode) {
        return switch (mode) {
            case 0 -> Component.translatable((String)"quickalias.import.mode.replace");
            case 1 -> Component.translatable((String)"quickalias.import.mode.merge_skip");
            case 2 -> Component.translatable((String)"quickalias.import.mode.merge_overwrite");
            default -> Component.literal((String)"?");
        };
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isPreviewVisible) {
            this.renderDirtBackground(guiGraphics);
            this.previewList.render(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            guiGraphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height / 2, this.statusColor);
        }
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        if (this.showConfirmation) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
            guiGraphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
            int centerX = this.width / 2;
            int centerY = this.height / 2;
            int boxW = 240;
            int boxH = 80;
            int boxX = centerX - boxW / 2;
            int boxY = centerY - boxH / 2;
            guiGraphics.fill(boxX, boxY, boxX + boxW, boxY + boxH, -14540254);
            guiGraphics.fill(boxX, boxY, boxX + boxW, boxY + 1, -1);
            guiGraphics.fill(boxX, boxY + boxH - 1, boxX + boxW, boxY + boxH, -1);
            guiGraphics.fill(boxX, boxY, boxX + 1, boxY + boxH, -1);
            guiGraphics.fill(boxX + boxW - 1, boxY, boxX + boxW, boxY + boxH, -1);
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"quickalias.import.confirm.title"), centerX, boxY + 10, 0xFFFFFF);
            Component modeText = this.getModeComponent(this.pendingImportMode);
            MutableComponent msg = Component.translatable((String)"quickalias.import.confirm.message", (Object[])new Object[]{modeText});
            List confirmLines = this.font.split((FormattedText)msg, boxW - 10);
            int textY = boxY + 23;
            for (FormattedCharSequence line : confirmLines) {
                guiGraphics.drawCenteredString(this.font, line, centerX, textY, 0xAAAAAA);
                textY += 12;
            }
            this.confirmBtn.render(guiGraphics, mouseX, mouseY, partialTick);
            this.cancelConfirmBtn.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

