/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.FlatButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ModConfigScreen
extends Screen {
    private final Screen parent;
    private final ConfigManager.AliasConfig config;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"quickalias.config.title"));
        this.parent = parent;
        this.config = ConfigManager.getInstance().getConfig();
    }

    protected void init() {
        int centerX = this.width / 2;
        int y = 70;
        this.addRenderableWidget((GuiEventListener)new FlatButton(centerX - 100, y, 200, 16, (Component)Component.translatable((String)"quickalias.config.show_settings", (Object[])new Object[]{this.boolToText(this.config.settings.showSettingsButton)}), btn -> {
            this.config.settings.showSettingsButton = !this.config.settings.showSettingsButton;
            btn.setMessage((Component)Component.translatable((String)"quickalias.config.show_settings", (Object[])new Object[]{this.boolToText(this.config.settings.showSettingsButton)}));
        }));
        this.addRenderableWidget((GuiEventListener)new FlatButton(centerX - 100, y += 24, 200, 16, (Component)Component.translatable((String)"quickalias.config.show_shortcut", (Object[])new Object[]{this.boolToText(this.config.settings.showShortcutButton)}), btn -> {
            this.config.settings.showShortcutButton = !this.config.settings.showShortcutButton;
            btn.setMessage((Component)Component.translatable((String)"quickalias.config.show_shortcut", (Object[])new Object[]{this.boolToText(this.config.settings.showShortcutButton)}));
        }));
        this.addRenderableWidget((GuiEventListener)new FlatButton(centerX - 100, y += 24, 200, 16, (Component)Component.translatable((String)"quickalias.config.button_style", (Object[])new Object[]{this.getStyleName(this.config.settings.useFlatStyle)}), btn -> {
            this.config.settings.useFlatStyle = !this.config.settings.useFlatStyle;
            btn.setMessage((Component)Component.translatable((String)"quickalias.config.button_style", (Object[])new Object[]{this.getStyleName(this.config.settings.useFlatStyle)}));
            ConfigManager.getInstance().save();
        }));
        y += 24;
        this.addRenderableWidget((GuiEventListener)new FlatButton(centerX - 50, this.height - 40, 100, 16, (Component)Component.translatable((String)"gui.done"), btn -> {
            ConfigManager.getInstance().save();
            this.minecraft.setScreen(this.parent);
        }));
    }

    private String boolToText(boolean b) {
        return b ? Component.translatable((String)"quickalias.config.on").getString() : Component.translatable((String)"quickalias.config.off").getString();
    }

    private String getStyleName(boolean isFlat) {
        return isFlat ? Component.translatable((String)"quickalias.config.style.flat").getString() : Component.translatable((String)"quickalias.config.style.vanilla").getString();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }
}

