/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasEditorScreen;
import com.florlet.quickalias.gui.AliasScrollList;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.ImportConfigScreen;
import com.florlet.quickalias.gui.ModConfigScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SettingsScreen
extends Screen {
    private final Screen parent;
    private AliasScrollList aliasList;
    private EditBox searchBox;

    public SettingsScreen(Screen parent) {
        super((Component)Component.translatable((String)"quickalias.settings.title"));
        this.parent = parent;
    }

    protected void init() {
        int headerHeight = 55;
        int footerHeight = 30;
        int centerX = this.width / 2;
        this.searchBox = new EditBox(this.font, centerX - 100, 28, 200, 16, (Component)Component.translatable((String)"quickalias.settings.search"));
        this.searchBox.setHint((Component)Component.translatable((String)"quickalias.settings.search"));
        this.searchBox.setResponder(text -> {
            if (this.aliasList != null) {
                this.aliasList.setFilter((String)text);
            }
        });
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)new FlatButton(this.width - 30, 28, 20, 16, (Component)Component.literal((String)"+"), btn -> {
            AliasNode newNode = new AliasNode();
            this.minecraft.setScreen((Screen)new AliasEditorScreen(this, newNode, true));
        }));
        this.aliasList = new AliasScrollList(this.minecraft, this, this.width, this.height, headerHeight, this.height - footerHeight, 24);
        this.addRenderableWidget((GuiEventListener)this.aliasList);
        if (!this.searchBox.getValue().isEmpty()) {
            this.aliasList.setFilter(this.searchBox.getValue());
        }
        int bottomY = this.height - 24;
        this.addRenderableWidget((GuiEventListener)new FlatButton(10, bottomY, 80, 16, (Component)Component.translatable((String)"quickalias.settings.global_config"), btn -> this.minecraft.setScreen((Screen)new ModConfigScreen(this))));
        this.addRenderableWidget((GuiEventListener)new FlatButton(100, bottomY, 80, 16, (Component)Component.translatable((String)"quickalias.settings.import_alias"), btn -> this.minecraft.setScreen((Screen)new ImportConfigScreen(this))));
        this.addRenderableWidget((GuiEventListener)new FlatButton(this.width - 70, bottomY, 60, 16, (Component)Component.translatable((String)"gui.done"), btn -> this.onClose()));
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderDirtBackground(guiGraphics);
        this.aliasList.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        guiGraphics.drawString(this.font, "By Florlet", 10, 10, 0x555555);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        ConfigManager.getInstance().save();
        this.minecraft.setScreen(this.parent);
    }

    public void refreshList() {
        if (this.aliasList != null) {
            this.aliasList.setFilter(this.searchBox.getValue());
        }
    }
}

