/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.config;

import com.shynieke.coupons.Coupons;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CouponConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Coupons.LOGGER.debug("Loaded Coupon's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Coupons.LOGGER.debug("Coupon's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue doubleBossLoot;
        public final ModConfigSpec.ConfigValue<List<? extends String>> entityBlacklist;
        public final ModConfigSpec.BooleanValue enableBrewingCoupon;
        public final ModConfigSpec.BooleanValue enableCraftingCoupon;
        public final ModConfigSpec.BooleanValue enableExperienceCoupon;
        public final ModConfigSpec.BooleanValue enableFurnaceCoupon;
        public final ModConfigSpec.BooleanValue enableLootCoupon;
        public final ModConfigSpec.BooleanValue enableTradingCoupon;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.doubleBossLoot = builder.comment("When enabled the loot coupon can double boss loot").define("doubleBossLoot", false);
            this.entityBlacklist = builder.comment("A list of entities that can't have loot doubled [Syntax: 'minecraft:bat']").defineListAllowEmpty("entityBlacklist", List::of, String::new, o -> o instanceof String);
            builder.pop();
            builder.comment("Wandering Trader Trades").push("Trades");
            this.enableBrewingCoupon = builder.comment("Defines whether or not the Brewing Coupon is obtainable from the Wandering Trader").worldRestart().define("enableBrewingCoupon", true);
            this.enableCraftingCoupon = builder.comment("Defines whether or not the Crafting Coupon is obtainable from the Wandering Trader").worldRestart().define("enableCraftingCoupon", true);
            this.enableExperienceCoupon = builder.comment("Defines whether or not the Experience Coupon is obtainable from the Wandering Trader").worldRestart().define("enableExperienceCoupon", true);
            this.enableFurnaceCoupon = builder.comment("Defines whether or not the Furnace Coupon is obtainable from the Wandering Trader").worldRestart().define("enableFurnaceCoupon", true);
            this.enableLootCoupon = builder.comment("Defines whether or not the Loot Coupon is obtainable from the Wandering Trader").worldRestart().define("enableLootCoupon", true);
            this.enableTradingCoupon = builder.comment("Defines whether or not the Trading Coupon is obtainable from the Wandering Trader").worldRestart().define("enableTradingCoupon", true);
            builder.pop();
        }
    }
}

