/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.handler;

import com.shynieke.coupons.config.CouponConfig;
import com.shynieke.coupons.registry.CouponRegistry;
import com.shynieke.coupons.util.InventoryCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class CouponHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        ItemStack result = event.getCrafting();
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)result.getItem());
        if (location != null && !location.getNamespace().equalsIgnoreCase("coupons") && InventoryCheck.hasCoupon(player, CouponRegistry.CRAFTING_COUPON)) {
            Container inventory = event.getInventory();
            ItemStack refundStack = ItemStack.EMPTY;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack foundStack = inventory.getItem(i);
                if (foundStack.isEmpty() || foundStack.isDamageableItem() || !foundStack.getCraftingRemainder().isEmpty() || CouponHandler.hasEnergy(foundStack) || foundStack.getCapability(Capabilities.Fluid.ITEM, null) != null || foundStack.getRarity() != Rarity.COMMON) continue;
                refundStack = foundStack.copy();
                refundStack.setCount(1);
                break;
            }
            if (!refundStack.isEmpty() && player.addItem(refundStack)) {
                InventoryCheck.shrinkCoupon(player, CouponRegistry.CRAFTING_COUPON);
                Containers.dropItemStack((Level)player.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)refundStack);
            }
        }
    }

    public static boolean hasEnergy(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.Energy.ITEM, null) != null;
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (stack.getItem() == CouponRegistry.LOOT_COUPON.get() && !((Boolean)target.getData(CouponRegistry.DOUBLE_LOOT)).booleanValue() && target instanceof LivingEntity) {
            List blacklist = (List)CouponConfig.COMMON.entityBlacklist.get();
            ResourceLocation location = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType());
            if (!blacklist.isEmpty() && location != null && !blacklist.contains(location.toString()) || ((Boolean)CouponConfig.COMMON.doubleBossLoot.get()).booleanValue()) {
                target.setData(CouponRegistry.DOUBLE_LOOT, (Object)true);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void livingDropsEvent(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (((Boolean)entity.getData(CouponRegistry.DOUBLE_LOOT)).booleanValue()) {
            Collection drops = event.getDrops();
            ArrayList<ItemEntity> extra = new ArrayList<ItemEntity>();
            for (ItemEntity drop : drops) {
                extra.add(new ItemEntity(drop.level(), drop.getX(), drop.getY(), drop.getZ(), drop.getItem()));
            }
            drops.addAll(extra);
        }
    }

    @SubscribeEvent
    public void onContainer(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof MerchantMenu) {
            MerchantMenu container = (MerchantMenu)abstractContainerMenu;
            if (InventoryCheck.hasCoupon(player, CouponRegistry.TRADING_COUPON) && !(container.trader instanceof WanderingTrader)) {
                int offerSlot = player.getRandom().nextInt(container.getOffers().size());
                MerchantOffer randomOffer = (MerchantOffer)container.getOffers().get(offerSlot);
                int uses = randomOffer.getUses();
                if (randomOffer.getBaseCostA().getCount() > 1) {
                    CompoundTag tag = player.getPersistentData();
                    tag.putInt("coupons:offerSlot", offerSlot);
                    tag.putInt("coupons:offerUses", uses);
                    tag.putInt("coupons:offerSpecialPrice", randomOffer.getSpecialPriceDiff());
                    randomOffer.addToSpecialPriceDiff(-64);
                }
            }
        }
    }

    @SubscribeEvent
    public void onContainerClose(PlayerContainerEvent.Close event) {
        Player player = event.getEntity();
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof MerchantMenu) {
            CompoundTag tag;
            MerchantMenu container = (MerchantMenu)abstractContainerMenu;
            if (InventoryCheck.hasCoupon(player, CouponRegistry.TRADING_COUPON) && (tag = player.getPersistentData()).contains("coupons:offerSlot") && tag.contains("coupons:offerUses") && tag.contains("coupons:offerSpecialPrice")) {
                int offerSlot = tag.getIntOr("coupons:offerSlot", 0);
                int previousUses = tag.getIntOr("coupons:offerUses", 0);
                int specialPrice = tag.getIntOr("coupons:offerSpecialPrice", 0);
                tag.remove("coupons:offerSlot");
                tag.remove("coupons:offerUses");
                tag.remove("coupons:offerSpecialPrice");
                MerchantOffer randomOffer = (MerchantOffer)container.getOffers().get(offerSlot);
                if (previousUses != -1 && randomOffer.getUses() != previousUses) {
                    randomOffer.setSpecialPriceDiff(specialPrice);
                    InventoryCheck.shrinkCoupon(player, CouponRegistry.TRADING_COUPON);
                }
            }
        }
    }
}

