/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.shynieke.coupons.registry.CouponRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;

public class ClientHandler {
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor(), new ItemLike[]{(ItemLike)CouponRegistry.BREWING_COUPON.get()});
    }

    public static void nameplateEvent(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        PoseStack poseStack = event.getPoseStack();
        ItemStack stack = new ItemStack((ItemLike)CouponRegistry.LOOT_COUPON.get());
        CompoundTag nbt = entity.getPersistentData();
        if (entity.isAlive() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (nbt.contains("coupons:doubleLoot")) {
                double f = livingEntity.getBbHeight() + 0.3f;
                poseStack.pushPose();
                poseStack.translate(0.0, f, 0.0);
                poseStack.scale(0.3f, 0.3f, 0.3f);
                float angle = 180.0f - Mth.lerp((float)event.getPartialTick(), (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
                poseStack.mulPose(Axis.YP.rotationDegrees(angle));
                Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem(livingEntity, stack, ItemDisplayContext.NONE, false, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                poseStack.popPose();
            }
        }
    }
}

