/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.util;

import com.shynieke.coupons.items.CouponItem;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryCheck {
    public static boolean hasCoupon(Player player, Supplier<? extends CouponItem> item) {
        if (item.get() != null) {
            ItemStack offStack = player.getItemInHand(InteractionHand.OFF_HAND);
            ItemStack mainStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!offStack.isEmpty() && offStack.getItem() == item.get() || !mainStack.isEmpty() && mainStack.getItem() == item.get()) {
                return true;
            }
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack itemstack = (ItemStack)player.getInventory().items.get(i);
                if (itemstack.isEmpty() || itemstack.getItem() != item.get()) continue;
                return true;
            }
        }
        return false;
    }

    public static void shrinkCoupon(Player player, Supplier<? extends CouponItem> item) {
        if (!player.getAbilities().instabuild && item.get() != null) {
            ItemStack offStack = player.getItemInHand(InteractionHand.OFF_HAND);
            ItemStack mainStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!offStack.isEmpty() && offStack.getItem() == item.get()) {
                offStack.shrink(1);
            } else if (!mainStack.isEmpty() && mainStack.getItem() == item.get()) {
                mainStack.shrink(1);
            } else {
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    ItemStack itemstack = (ItemStack)player.getInventory().items.get(i);
                    if (itemstack.isEmpty() || itemstack.getItem() != item.get()) continue;
                    itemstack.shrink(1);
                    break;
                }
            }
        }
    }
}

