/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cyberneticsystem_neoforge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.mcreator.cyberneticsystem_neoforge.init.CyberneticSystemModBlockEntities;
import net.mcreator.cyberneticsystem_neoforge.init.CyberneticSystemModBlocks;
import net.mcreator.cyberneticsystem_neoforge.init.CyberneticSystemModItems;
import net.mcreator.cyberneticsystem_neoforge.init.CyberneticSystemModMenus;
import net.mcreator.cyberneticsystem_neoforge.init.CyberneticSystemModMobEffects;
import net.mcreator.cyberneticsystem_neoforge.init.CyberneticSystemModTabs;
import net.mcreator.cyberneticsystem_neoforge.network.CyberneticSystemModVariables;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cybernetic_system")
public class CyberneticSystemMod {
    public static final Logger LOGGER = LogManager.getLogger(CyberneticSystemMod.class);
    public static final String MODID = "cybernetic_system";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public CyberneticSystemMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        CyberneticSystemModBlocks.REGISTRY.register(modEventBus);
        CyberneticSystemModBlockEntities.REGISTRY.register(modEventBus);
        CyberneticSystemModItems.REGISTRY.register(modEventBus);
        CyberneticSystemModTabs.REGISTRY.register(modEventBus);
        CyberneticSystemModVariables.ATTACHMENT_TYPES.register(modEventBus);
        CyberneticSystemModMobEffects.REGISTRY.register(modEventBus);
        CyberneticSystemModMenus.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    public static class CuriosApiHelper {
        private static final EntityCapability<IItemHandler, Void> CURIOS_INVENTORY = EntityCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"item_handler"), IItemHandler.class);

        public static IItemHandler getCuriosInventory(Player player) {
            if (ModList.get().isLoaded("curios")) {
                return (IItemHandler)player.getCapability(CURIOS_INVENTORY);
            }
            return null;
        }

        public static boolean isCurioItem(ItemStack itemstack) {
            return BuiltInRegistries.ITEM.getTagNames().filter(tagKey -> tagKey.location().getNamespace().equals("curios")).anyMatch(arg_0 -> ((ItemStack)itemstack).is(arg_0));
        }
    }
}

