/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cyberneticsystem_neoforge.network;

import java.util.function.Supplier;
import net.mcreator.cyberneticsystem_neoforge.CyberneticSystemMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class CyberneticSystemModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"cybernetic_system");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(CyberneticSystemModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(CyberneticSystemModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.dna_point = original.dna_point;
        clone.Gens_Body = original.Gens_Body;
        clone.Gens_Armor = original.Gens_Armor;
        clone.Gens_DNA = original.Gens_DNA;
        clone.Gens_Adrenalin = original.Gens_Adrenalin;
        clone.Gens_Swim = original.Gens_Swim;
        clone.Cybernation = original.Cybernation;
        clone.augme_ah = original.augme_ah;
        clone.augme_bs = original.augme_bs;
        clone.augme_bm = original.augme_bm;
        clone.augme_bmm = original.augme_bmm;
        clone.augme_be = original.augme_be;
        if (!event.isWasDeath()) {
            // empty if block
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cybernetic_system", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double dna_point = 0.0;
        public double Gens_Body = 0.0;
        public double Gens_Armor = 0.0;
        public double Gens_DNA = 0.0;
        public double Gens_Adrenalin = 0.0;
        public double Gens_Swim = 0.0;
        public boolean Cybernation = false;
        public boolean augme_ah = false;
        public boolean augme_bs = false;
        public boolean augme_bm = false;
        public boolean augme_bmm = false;
        public boolean augme_be = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("dna_point", this.dna_point);
            nbt.putDouble("Gens_Body", this.Gens_Body);
            nbt.putDouble("Gens_Armor", this.Gens_Armor);
            nbt.putDouble("Gens_DNA", this.Gens_DNA);
            nbt.putDouble("Gens_Adrenalin", this.Gens_Adrenalin);
            nbt.putDouble("Gens_Swim", this.Gens_Swim);
            nbt.putBoolean("Cybernation", this.Cybernation);
            nbt.putBoolean("augme_ah", this.augme_ah);
            nbt.putBoolean("augme_bs", this.augme_bs);
            nbt.putBoolean("augme_bm", this.augme_bm);
            nbt.putBoolean("augme_bmm", this.augme_bmm);
            nbt.putBoolean("augme_be", this.augme_be);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.dna_point = nbt.getDouble("dna_point");
            this.Gens_Body = nbt.getDouble("Gens_Body");
            this.Gens_Armor = nbt.getDouble("Gens_Armor");
            this.Gens_DNA = nbt.getDouble("Gens_DNA");
            this.Gens_Adrenalin = nbt.getDouble("Gens_Adrenalin");
            this.Gens_Swim = nbt.getDouble("Gens_Swim");
            this.Cybernation = nbt.getBoolean("Cybernation");
            this.augme_ah = nbt.getBoolean("augme_ah");
            this.augme_bs = nbt.getBoolean("augme_bs");
            this.augme_bm = nbt.getBoolean("augme_bm");
            this.augme_bmm = nbt.getBoolean("augme_bmm");
            this.augme_be = nbt.getBoolean("augme_be");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }
}

