/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.techdecor.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.techdecor.CyberneticSystemMod;
import net.mcreator.techdecor.procedures.ProOpenDNAUpgradeCombatProcedure;
import net.mcreator.techdecor.procedures.ProOpenDNAUpgradeLiveProcedure;
import net.mcreator.techdecor.procedures.ProOpenDNAUpgradeMiningProcedure;
import net.mcreator.techdecor.procedures.ProOpenTerminalProcedure;
import net.mcreator.techdecor.world.inventory.GUIGeneticsTerminalMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUIGeneticsTerminalButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUIGeneticsTerminalButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUIGeneticsTerminalButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUIGeneticsTerminalButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIGeneticsTerminalButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIGeneticsTerminalButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUIGeneticsTerminalMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProOpenDNAUpgradeLiveProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProOpenDNAUpgradeMiningProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ProOpenDNAUpgradeCombatProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ProOpenTerminalProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(GUIGeneticsTerminalButtonMessage.class, GUIGeneticsTerminalButtonMessage::buffer, GUIGeneticsTerminalButtonMessage::new, GUIGeneticsTerminalButtonMessage::handler);
    }
}

