/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class RealityMarbleSpellEffect {
    public static final int distance = 3000;
    public static Random random = new Random(53L);
    public static int counter = 0;
    public static ResourceLocation marble = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"reality_marble");

    public static boolean inMarble(Level world) {
        return EffectUtil.getDimension(world).toString().equals(marble.toString());
    }

    public static LivingEntity getEnemy(Player player) {
        Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_REALITY_MARBLE, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_REALITY_MARBLE));
        if (e instanceof LivingEntity && !EffectUtil.inEntityBlacklist(e, MTConfig.MARBLE_MOB_BLACKLIST)) {
            return (LivingEntity)e;
        }
        return null;
    }

    public static BlockPos getRealityMarbleSpawn(Level world, UUID uuid) {
        MahouSavedData save = Utils.getWorldMahou(world);
        BlockPos pos = save.getPlayerSpawn(uuid);
        if (pos == null) {
            pos = RealityMarbleSpellEffect.generateRealityMarbleSpawn(world, save, uuid);
        }
        return pos;
    }

    public static BlockPos generateRealityMarbleSpawn(Level world, MahouSavedData save, UUID uuid) {
        ConcurrentHashMap<UUID, BlockPos> spawns = save.getAllSpawns();
        int maxX = 0;
        int maxZ = 0;
        if (spawns != null) {
            BlockPos pos;
            for (UUID tmp : spawns.keySet()) {
                pos = spawns.get(tmp);
                if (pos.getX() > maxX) {
                    maxX = pos.getX();
                }
                if (pos.getZ() <= maxZ) continue;
                maxZ = pos.getZ();
            }
            if (Math.random() < 0.5) {
                maxX += 3000;
            } else {
                maxZ += 3000;
            }
            pos = new BlockPos(maxX, 120, maxZ);
            save.changePlayerSpawn(uuid, pos);
            return pos;
        }
        return null;
    }

    public static boolean goToMarble(Player user) {
        IMahou casterMahou = Utils.getPlayerMahou(user);
        if (casterMahou != null) {
            BlockPos pos;
            ResourceLocation userdimension = EffectUtil.getDimension(user.level());
            boolean inmarble = RealityMarbleSpellEffect.inMarble(user.level());
            if (userdimension == null || inmarble) {
                casterMahou.setPlayerOldDimension(EffectUtil.getOverworld().toString());
            } else {
                casterMahou.setPlayerOldDimension(userdimension.toString());
            }
            if (userdimension != null && !inmarble) {
                casterMahou.setPlayerSavedSpawn(user.blockPosition());
            }
            if (casterMahou.getPlayerMarbleSpawn() == null) {
                casterMahou.setPlayerMarbleSpawn(RealityMarbleSpellEffect.getRealityMarbleSpawn(user.level(), user.getUUID()));
            }
            if ((pos = casterMahou.getPlayerMarbleSpawn()) == null) {
                return false;
            }
            LivingEntity e = RealityMarbleSpellEffect.getEnemy(user);
            PlayerManaManager.updateClientMahou((ServerPlayer)user, casterMahou);
            MahouTsukaiTeleporter.teleport((Entity)user, marble, new Vec3((double)pos.getX(), 120.0, (double)pos.getZ()));
            if (e != null) {
                IMahou enemyMahou;
                if (e instanceof ServerPlayer && !inmarble && (enemyMahou = Utils.getPlayerMahou((Player)e)) != null) {
                    enemyMahou.setPlayerOldDimension(EffectUtil.getDimension(e.level()).toString());
                    enemyMahou.setPlayerSavedSpawn(user.blockPosition());
                    PlayerManaManager.updateClientMahou((ServerPlayer)e, enemyMahou);
                    enemyMahou.setEnemy(user.getUUID());
                }
                casterMahou.setEnemy(e.getUUID());
                MahouTsukaiTeleporter.teleport((Entity)e, marble, new Vec3((double)(pos.getX() + 20), 120.0, (double)pos.getZ()));
            }
        }
        return true;
    }

    public static void spawnSwords(BlockPos userSpawn, Level world, ChunkAccess chunk, int size_count, int distance) {
        int startZ;
        int endZ;
        int startX;
        int endX;
        if (random == null) {
            random = new Random(42L);
        }
        int ux = endX = (startX = userSpawn.getX());
        int uz = endZ = (startZ = userSpawn.getZ());
        int y = 83;
        startZ -= size_count * distance - random.nextInt(distance);
        endX += size_count * distance + random.nextInt(distance);
        endZ += size_count * distance + random.nextInt(distance);
        ArrayList<WeaponProjectileEntity> spawns = new ArrayList<WeaponProjectileEntity>();
        for (int i = startX -= size_count * distance - random.nextInt(distance); i <= endX; i += distance) {
            for (int j = startZ; j <= endZ; j += distance) {
                boolean inrange;
                boolean bl = inrange = i <= chunk.getPos().getMaxBlockX() && i >= chunk.getPos().getMinBlockX() && j <= chunk.getPos().getMaxBlockZ() && j >= chunk.getPos().getMinBlockZ();
                if (MTConfig.MARBLE_SWORD_SPAWN_LIST.size() <= 0 || !inrange) continue;
                double rand = random.nextDouble();
                String name = MTConfig.MARBLE_SWORD_SPAWN_LIST.get(random.nextInt(MTConfig.MARBLE_SWORD_SPAWN_LIST.size()));
                Item item = RealityMarbleSpellEffect.getItemFromName(name, world);
                if (item == null) {
                    Utils.err("No item with name " + name + " found.");
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                if (0.6 < rand && rand < 0.8) {
                    EffectUtil.addEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.SHARPNESS, 2, world);
                } else if (rand >= 0.8) {
                    EffectUtil.addEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK, 2, world);
                }
                stack.setDamageValue(stack.getMaxDamage() - MTConfig.MARBLE_DIMENSION_DURABILITY);
                WeaponProjectileEntity wpe = new WeaponProjectileEntity(world, i, y, j, stack);
                double velx = i < ux ? -0.6 : 0.6;
                double velz = j < uz ? -0.6 : 0.6;
                wpe.setDeltaMovement(random.nextDouble() * velx, -2.0, random.nextDouble() * velz);
                if (!(random.nextDouble() < MTConfig.MARBLE_DIMENSION_SPAWN_CHANCE)) continue;
                spawns.add(wpe);
            }
        }
        spawns.forEach(weapon -> {
            if (world instanceof ServerLevel) {
                chunk.addEntity((Entity)weapon);
                ((ServerLevel)world).addFreshEntity((Entity)weapon);
            }
        });
    }

    public static Item getItemFromName(String s, Level level) {
        ResourceLocation r = ResourceLocation.parse((String)s);
        Item ret = (Item)((Registry)level.registryAccess().registry(Registries.ITEM).get()).get(r);
        return ret;
    }

    public static void realityMarbleChunkUnload(ChunkEvent.Unload event) {
    }

    public static void realityMarbleChunkLoad(ChunkEvent.Load event) {
        Level world = event.getChunk().getLevel();
        if (world != null && !world.isClientSide() && RealityMarbleSpellEffect.inMarble(world)) {
            ChunkAccess c = event.getChunk();
            int x = c.getPos().x * 16 + 8;
            int z = c.getPos().z * 16 + 8;
            int y = 100;
            RealityMarbleSpellEffect.spawnSwords(new BlockPos(x, y, z), c.getLevel(), c, 1, MTConfig.MARBLE_DIMENSION_SPAWN_RATE);
        }
    }

    public static boolean realityMarbleLivingFall(LivingFallEvent event) {
        boolean ret = false;
        if (!event.getEntity().level().isClientSide && RealityMarbleSpellEffect.inMarble(event.getEntity().level())) {
            ret = true;
        }
        return ret;
    }

    public static void realityMarbleLivingHurt(Entity e) {
        if (e instanceof Player && !e.level().isClientSide && RealityMarbleSpellEffect.inMarble(e.level())) {
            if (Utils.getPlayerMahou((Player)e) != null) {
                final IMahou mahou = Utils.getPlayerMahou((Player)e);
                if (mahou != null) {
                    if (mahou.getEnemy() != null && e.level().getPlayerByUUID(mahou.getEnemy()) == null) {
                        boolean flag = true;
                        double range = 500.0;
                        List lst = e.level().getEntitiesOfClass(LivingEntity.class, new AABB(e.blockPosition().offset((int)(-range), (int)(-range), (int)(-range)).getCenter(), e.blockPosition().offset((int)range, (int)range, (int)range).getCenter()), (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                            public boolean apply(@Nullable LivingEntity e) {
                                return e != null && e.getUUID().equals(mahou.getEnemy());
                            }
                        });
                        flag = lst.isEmpty();
                        if (flag) {
                            mahou.setEnemy(null);
                        }
                    }
                    if (mahou.getEnemy() == null) {
                        String dimension;
                        BlockPos pos = mahou.getPlayerSavedSpawn();
                        String string = dimension = mahou.getPlayerOldDimension() == null || mahou.getPlayerOldDimension().equals(marble.toString()) ? EffectUtil.getOverworld().toString() : mahou.getPlayerOldDimension();
                        if (pos == null) {
                            pos = ((Player)e).getSleepingPos().orElse(new BlockPos(0, 0, 0));
                        }
                        MahouTsukaiTeleporter.teleport(e, pos.getX(), pos.getY(), pos.getZ(), ResourceLocation.parse((String)dimension));
                    }
                }
            } else {
                BlockPos bed = ((ServerPlayer)e).getRespawnPosition();
                if (bed == null) {
                    LevelData info = e.level().getLevelData();
                    bed = info.getSpawnPos();
                }
                MahouTsukaiTeleporter.teleport(e, bed.getX(), bed.getY(), bed.getZ(), ((ServerPlayer)e).getRespawnDimension().location());
            }
        }
    }
}

