/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class LightningEntity
extends Entity {
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_TARGET = "MAHOUTSUKAI_TARGET";
    private static final String TAG_HAS_BALL = "MAHOUTSUKAI_HAS_BALL";
    private static final String TAG_ZAP = "MAHOUTSUKAI_ZAP";
    public boolean rolled = false;
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CASTER_ID = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_BALL = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ZAP = SynchedEntityData.defineId(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public LivingEntity target;
    public LivingEntity caster;
    public double prev_x;
    public double prev_y;
    public double prev_z;
    public float[] segmentlengths;
    public float[] offshootlengths;
    public float[] pitchs;
    public float[] reallengths;
    public float[] prevpitchs;
    public float[] prevreallengths;
    public int segments = 0;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public static final String entityName = "lightning_entity";

    public LightningEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public LightningEntity(Level world) {
        super((EntityType)ModEntities.LIGHTNING.get(), world);
        this.noCulling = true;
    }

    public LightningEntity(Level world, LivingEntity caster, LivingEntity target, float r, float g, float b, float a, float size, boolean zap) {
        this(world);
        this.setColor(r, g, b, a);
        this.sizer(size);
        this.caster = caster;
        this.target = target;
        this.entityData.set(TARGET_ID, (Object)target.getId());
        this.entityData.set(CASTER_ID, (Object)caster.getId());
        this.setZap(zap);
        this.setLookPos(world.isClientSide);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(CASTER_ID, (Object)-1);
        builder.define(TARGET_ID, (Object)-1);
        builder.define(HAS_BALL, (Object)false);
        builder.define(ZAP, (Object)false);
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void tick() {
        if (this.caster != null && this.target != null) {
            Vec3 targeteye = this.target.getEyePosition(1.0f).add(0.0, this.getZap() ? (double)(-this.target.getBbHeight() / 2.0f) : 0.0, 0.0);
            Vec3 start = this.setLookPos(this.level().isClientSide);
            if (!this.level().isClientSide) {
                if (!this.target.isAlive() || !this.caster.isAlive()) {
                    this.discard();
                } else {
                    if (targeteye.subtract(start).length() > (double)(MTConfig.EMRYS_MAX_RANGE * 2) || !this.getZap() && this.caster.getUseItem().getItem() != ModItems.emrysStaff.get()) {
                        this.discard();
                    } else if (!this.getZap() && ServerHandler.tickCounter % 20L == 0L) {
                        LivingEntity livingEntity = this.caster;
                        if (livingEntity instanceof Player) {
                            Player p = (Player)livingEntity;
                            if (this.target instanceof Phantom) {
                                MandatoryFun.completeFunReq(p, MandatoryFun.FUN_REQS.EMRYS_HIT_PHANTOM);
                            }
                        }
                        this.target.hurt(this.caster.damageSources().lightningBolt(), (float)MTConfig.EMRYS_DAMAGE_FOCUSED_PER_SECOND);
                        this.target.lastHurtByPlayerTime = 100;
                        if (this.caster instanceof Player) {
                            StaffEmrys.zap(this.target, false, (Player)this.caster);
                        }
                    }
                    if (this.getZap() && this.tickCount > 8) {
                        EffectUtil.magicAttack(this.target, (float)MTConfig.EMRYS_DAMAGE_ZAP, this.caster);
                        EffectUtil.buff(this.target, ModEffects.ZAP_COOLDOWN, false, 60);
                        StaffEmrys.zap(this.target, false, null);
                        this.discard();
                    }
                }
            } else {
                this.prev_x = this.getX();
                this.prev_y = this.getY();
                this.prev_z = this.getZ();
                Vec3 v2 = targeteye.subtract(start);
                Vec3 v = v2.normalize();
                this.pitch = 90.0f - EffectUtil.toDegrees((float)Math.asin(-v.y));
                this.yaw = 180.0f + EffectUtil.toDegrees((float)Math.atan2(v.x, v.z));
                float len = (float)v2.length();
                if (!this.rolled) {
                    this.rerollLightningShape(len);
                }
                if (this.segments > 0) {
                    this.copyPrevSegments();
                    this.randomLightningMovement();
                    this.shrink();
                    this.correct(len);
                    this.calculateLightningAnglesAndLengths();
                }
            }
        } else if (this.level().isClientSide) {
            Entity t = this.level().getEntity(((Integer)this.entityData.get(TARGET_ID)).intValue());
            Entity c = this.level().getEntity(((Integer)this.entityData.get(CASTER_ID)).intValue());
            if (t instanceof LivingEntity) {
                this.target = (LivingEntity)t;
            }
            if (c instanceof LivingEntity) {
                this.caster = (LivingEntity)c;
            }
        }
    }

    public void randomLightningMovement() {
        float sidegrowth = 1.0f / (float)this.segments;
        int i = 0;
        while (i < this.offshootlengths.length - 2) {
            int n = i;
            this.offshootlengths[n] = this.offshootlengths[n] + this.random.nextFloat() * sidegrowth;
            int n2 = i++;
            this.offshootlengths[n2] = this.offshootlengths[n2] % 0.4f;
        }
        i = 0;
        while (i < this.segmentlengths.length - 1) {
            int n = i++;
            this.segmentlengths[n] = this.segmentlengths[n] + Math.max(0.0f, this.random.nextFloat() * sidegrowth * 3.0f - sidegrowth / 1.5f);
        }
    }

    public void shrink() {
        if (this.segmentlengths[this.segmentlengths.length - 1] < 0.7f) {
            if (this.offshootlengths[this.offshootlengths.length - 2] < 0.7f) {
                int i;
                for (i = this.segmentlengths.length - 1; i > 0; --i) {
                    this.segmentlengths[i] = this.segmentlengths[i - 1];
                }
                this.segmentlengths[0] = 1.0E-4f;
                for (i = this.offshootlengths.length - 2; i > 0; --i) {
                    this.offshootlengths[i] = this.offshootlengths[i - 1];
                }
                this.offshootlengths[0] = 1.0E-4f;
            } else {
                int n = this.offshootlengths.length - 2;
                this.offshootlengths[n] = this.offshootlengths[n] - (0.1f + this.random.nextFloat() * 0.1f);
            }
        }
    }

    public void correct(float totallen) {
        float t;
        float z = 0.0f;
        for (int i = 0; i < this.segmentlengths.length; ++i) {
            z += this.segmentlengths[i];
        }
        float overflow = z - totallen;
        for (int i = this.segmentlengths.length - 1; i >= 0 && overflow > 0.0f; overflow -= t, --i) {
            t = this.segmentlengths[i];
            this.segmentlengths[i] = t > overflow ? t - overflow : 0.0f;
        }
    }

    public void copyPrevSegments() {
        int i;
        this.prevpitchs = new float[this.pitchs.length];
        for (i = 0; i < this.prevpitchs.length; ++i) {
            this.prevpitchs[i] = this.pitchs[i];
        }
        this.prevreallengths = new float[this.reallengths.length];
        for (i = 0; i < this.prevreallengths.length; ++i) {
            this.prevreallengths[i] = this.reallengths[i];
        }
    }

    public Vec3 setLookPos(boolean client) {
        Vec3 look = this.caster.getViewVector(1.0f);
        Vec3 oldlook = look.normalize();
        look = oldlook.scale((double)1.9f);
        look = look.add(oldlook.yRot(EffectUtil.toRad(-90.0f)).scale((double)0.3f)).add(oldlook.xRot(EffectUtil.toRad(-90.0f)).scale((double)0.3f));
        if (this.getZap()) {
            look = new Vec3(0.0, (double)(-this.caster.getBbHeight() / 2.0f), 0.0);
        }
        Vec3 start = look.add(this.caster.getEyePosition(1.0f));
        if (!client) {
            this.setPos(start.x, start.y, start.z);
        }
        return start;
    }

    public void rerollLightningShape(float totalLenToTarget) {
        float remaining = totalLenToTarget;
        this.segments = this.random.nextInt(4) + 6;
        this.segmentlengths = new float[this.segments];
        this.offshootlengths = new float[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            this.segmentlengths[i] = i == this.segments - 1 ? remaining : this.random.nextFloat() * remaining * 1.0f / (float)this.segments;
            this.offshootlengths[i] = this.random.nextFloat() * (this.getZap() ? 0.9f : 1.5f);
            remaining -= this.segmentlengths[i];
        }
        this.offshootlengths[this.segments - 1] = 0.0f;
        this.calculateLightningAnglesAndLengths();
        this.rolled = true;
    }

    public void calculateLightningAnglesAndLengths() {
        this.pitchs = new float[this.segments];
        this.reallengths = new float[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            float c;
            float prevb = i == 0 ? 0.0f : this.offshootlengths[i - 1];
            float a = this.segmentlengths[i];
            float b = this.offshootlengths[i] - prevb;
            this.reallengths[i] = c = (float)Math.sqrt(a * a + b * b);
            this.pitchs[i] = EffectUtil.toDegrees((float)Math.asin(b / c));
        }
    }

    public boolean isPickable() {
        return false;
    }

    public void playerTouch(Player entityIn) {
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void checkInsideBlocks() {
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setBeamSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setBeamSize(compound.getFloat(TAG_BEAM_SIZE));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setHasBall(compound.getBoolean(TAG_HAS_BALL));
        this.setTargetId(compound.getInt(TAG_TARGET));
        this.setCasterId(compound.getInt(TAG_CASTER));
        this.setZap(compound.getBoolean(TAG_ZAP));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putBoolean(TAG_HAS_BALL, ((Boolean)this.entityData.get(HAS_BALL)).booleanValue());
        if (this.caster != null) {
            compound.putFloat(TAG_CASTER, (float)this.getCasterId());
        }
        if (this.target != null) {
            compound.putFloat(TAG_TARGET, (float)this.getTargetId());
        }
        compound.putBoolean(TAG_ZAP, this.getZap());
    }

    public float getBeamSize() {
        return ((Float)this.entityData.get(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float s) {
        this.entityData.set(BEAM_SIZE, (Object)Float.valueOf(s));
    }

    public boolean getHasBall() {
        return (Boolean)this.entityData.get(HAS_BALL);
    }

    public void setHasBall(boolean s) {
        this.entityData.set(HAS_BALL, (Object)s);
    }

    public boolean getZap() {
        return (Boolean)this.entityData.get(ZAP);
    }

    public void setZap(boolean s) {
        this.entityData.set(ZAP, (Object)s);
    }

    public int getTargetId() {
        return (Integer)this.entityData.get(TARGET_ID);
    }

    public void setTargetId(int id) {
        this.entityData.set(TARGET_ID, (Object)id);
    }

    public int getCasterId() {
        return (Integer)this.entityData.get(TARGET_ID);
    }

    public void setCasterId(int id) {
        this.entityData.set(CASTER_ID, (Object)id);
    }
}

