/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RevertedPacket;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RevertedPotion;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ReversionEyesPotion
extends EyesPotion {
    public ReversionEyesPotion() {
        super(ModEffects.getColorNumber(242, 7, 23));
        EffectUtil.effectIcon = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/effects/reverted.png");
    }

    public static void reversionEyesPlayerTick(Player player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.REVERSION_EYES)) {
            ReversionEyesPotion.addRevert((LivingEntity)player);
        }
    }

    public static void reversionEyesLivingUpdate(LivingEntity entity) {
        Level world = entity.level();
        if (!world.isClientSide && ReversionEyesPotion.isEntityReverted(entity)) {
            ReversionEyesPotion.cantBreatheUnderwater(entity);
            ReversionEyesPotion.canBurn(entity);
            ReversionEyesPotion.burnInDay(entity);
            ReversionEyesPotion.noMoreEffects(entity);
            if (!ReversionEyesPotion.continueReverting(entity)) {
                EffectUtil.debuff(entity, ModEffects.REVERTED);
                ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
                lst.add(entity);
            }
        }
    }

    public static boolean continueReverting(LivingEntity victim) {
        int totalRange = MTConfig.REVERSION_EYES_RANGE_FROM_USER;
        Vec3 myloc = new Vec3(victim.getX(), victim.getY(), victim.getZ());
        boolean keepReverting = false;
        List lst = victim.level().getEntitiesOfClass(Player.class, new AABB(victim.getX() - (double)totalRange, victim.getY() - (double)totalRange, victim.getZ() - (double)totalRange, victim.getX() + (double)totalRange, victim.getY() + (double)totalRange, victim.getZ() + (double)totalRange));
        for (Player tmp : lst) {
            if (tmp.getUUID().equals(victim.getUUID()) || !EffectUtil.hasBuff((LivingEntity)tmp, ModEffects.REVERSION_EYES) || !EffectUtil.inRange(victim, (LivingEntity)tmp, myloc, MTConfig.REVERSION_EYES_RANGE_FROM_LOOK_VEC, false)) continue;
            keepReverting = true;
        }
        return keepReverting;
    }

    public static void addRevert(LivingEntity target) {
        int totalRange = MTConfig.REVERSION_EYES_RANGE_FROM_USER;
        Vec3 myloc = new Vec3(target.getX(), target.getY(), target.getZ());
        List lst = target.level().getEntitiesOfClass(LivingEntity.class, new AABB(target.getX() - (double)totalRange, target.getY() - (double)totalRange, target.getZ() - (double)totalRange, target.getX() + (double)totalRange, target.getY() + (double)totalRange, target.getZ() + (double)totalRange));
        ArrayList<LivingEntity> toSendE = new ArrayList<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, target, myloc, MTConfig.REVERSION_EYES_RANGE_FROM_LOOK_VEC, false) || ContractMahoujinTileEntity.isImmuneToSpell(target.level(), target.getUUID(), (Entity)tmp) || ReversionEyesPotion.isEntityReverted(tmp)) continue;
            ReversionEyesPotion.setEntityReverted(tmp);
            toSendE.add(tmp);
        }
        ReversionEyesPotion.notifyTracking(toSendE, true, target.level());
    }

    public static void setEntityReverted(LivingEntity target) {
        EffectUtil.buff(target, ModEffects.REVERTED, false, 100);
    }

    public static boolean isEntityReverted(LivingEntity target) {
        return EffectUtil.hasBuff(target, ModEffects.REVERTED);
    }

    public static void noMoreEffects(LivingEntity e) {
        if (!e.level().isClientSide) {
            Object mahou;
            ArrayList<Holder> toremove = new ArrayList<Holder>();
            for (MobEffectInstance effect : e.getActiveEffects()) {
                if (effect.getEffect() == ModEffects.REVERTED.get()) continue;
                toremove.add(effect.getEffect());
            }
            for (Holder p : toremove) {
                try {
                    if (p.value() instanceof RevertedPotion) continue;
                    e.removeEffect(p);
                }
                catch (Exception exception) {}
            }
            if (e instanceof Player && (mahou = Utils.getPlayerMahou((Player)e)) != null) {
                mahou.clearBuffs();
            }
            if ((mahou = Utils.getLivingMahou(e)) != null) {
                mahou.clearBuffs();
            }
        } else {
            MahouTsukaiMod.proxy.revertPlayer();
        }
    }

    public static boolean reversionEyesProjectileImpact(Entity entity, HitResult r) {
        Entity target;
        boolean ret = false;
        if (entity != null && r instanceof EntityHitResult && (target = ((EntityHitResult)r).getEntity()) instanceof LivingEntity && ReversionEyesPotion.isEntityReverted((LivingEntity)target)) {
            ret = true;
            if (entity instanceof Arrow) {
                ReversionEyesPotion.arrowEnderman(target, (Arrow)entity);
            }
        }
        return ret;
    }

    public static void arrowEnderman(Entity entity, Arrow arrow) {
        if (entity != null) {
            Vec3 arrowmot = arrow.getDeltaMovement();
            double motionX = arrowmot.x;
            double motionY = arrowmot.y;
            double motionZ = arrowmot.z;
            float f = Mth.sqrt((float)((float)(motionX * motionX + motionY * motionY + motionZ * motionZ)));
            int i = Mth.ceil((double)((double)f * arrow.getBaseDamage()));
            if (arrow.isCritArrow()) {
                i += entity.level().random.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = arrow.getOwner() == null ? entity.damageSources().arrow((AbstractArrow)arrow, (Entity)arrow) : entity.damageSources().arrow((AbstractArrow)arrow, null);
            if (arrow.isOnFire()) {
                entity.igniteForSeconds(5.0f);
            }
            if (entity instanceof EnderMan) {
                if (ReversionEyesPotion.attackEntityFrom((LivingEntity)entity, entity.damageSources().generic(), i)) {
                    float f1;
                    LivingEntity LivingEntity2 = (LivingEntity)entity;
                    LivingEntity2.lastHurtByPlayerTime = 100;
                    if (!arrow.level().isClientSide) {
                        LivingEntity2.setArrowCount(LivingEntity2.getArrowCount() + 1);
                    }
                    if ((f1 = Mth.sqrt((float)((float)(motionX * motionX + motionZ * motionZ)))) > 0.0f) {
                        LivingEntity2.push(motionX * 3.0 * (double)0.6f / (double)f1, 0.1, motionZ * 3.0 * (double)0.6f / (double)f1);
                    }
                    arrow.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (arrow.level().random.nextFloat() * 0.2f + 0.9f));
                    arrow.discard();
                }
                return;
            }
            if (entity instanceof LivingEntity && !entity.hurt(damagesource, (float)i)) {
                ReversionEyesPotion.attackEntityFrom((LivingEntity)entity, entity.damageSources().generic(), i);
                LivingEntity LivingEntity3 = (LivingEntity)entity;
                LivingEntity3.lastHurtByPlayerTime = 100;
                if (!arrow.level().isClientSide) {
                    LivingEntity3.setArrowCount(LivingEntity3.getArrowCount() + 1);
                }
                float f1 = Mth.sqrt((float)((float)(motionX * motionX + motionZ * motionZ)));
                arrow.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (arrow.level().random.nextFloat() * 0.2f + 0.9f));
                arrow.discard();
            }
        }
    }

    public static void notifyIfReverted(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (ReversionEyesPotion.isEntityReverted(e)) {
            ReversionEyesPotion.notifyTracking(lst, true, e.level());
        }
    }

    public static void notifyNotReverted(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        ReversionEyesPotion.notifyTracking(lst, false, e.level());
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RevertedPacket(e.getId(), r));
            }
        }
    }

    public static boolean attackEntityFrom(LivingEntity e, DamageSource source, float amount) {
        Entity entity1;
        boolean flag1 = false;
        if (e.level().isClientSide) {
            return false;
        }
        if (e.getHealth() <= 0.0f) {
            return false;
        }
        float f = amount;
        e.walkAnimation.setSpeed(1.5f);
        float f2 = e.invulnerableTime;
        Objects.requireNonNull(e);
        if (f2 > 20.0f / 2.0f) {
            ReversionEyesPotion.damageEntity(e, source, amount);
            flag1 = true;
        } else {
            Objects.requireNonNull(e);
            e.invulnerableTime = 20;
            ReversionEyesPotion.damageEntity(e, source, amount);
            e.hurtTime = e.hurtDuration = 10;
        }
        Entity entity12 = source.getEntity();
        if (entity12 != null && entity12 instanceof LivingEntity) {
            e.setLastHurtByMob((LivingEntity)entity12);
        }
        byte b0 = 2;
        e.level().broadcastEntityEvent((Entity)e, b0);
        if (source != e.damageSources().drown() && amount > 0.0f) {
            e.hurtMarked = true;
        }
        if ((entity1 = source.getEntity()) != null) {
            double d1 = entity1.getX() - e.getX();
            double d0 = entity1.getZ() - e.getZ();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            e.knockback((double)0.4f, d1, d0);
        }
        if (flag1) {
            if (e instanceof EnderMan) {
                e.playSound(SoundEvents.ENDERMAN_HURT, 1.0f, ReversionEyesPotion.getSoundPitch(e));
            }
            if (e instanceof Shulker) {
                e.playSound(SoundEvents.SHULKER_HURT, 1.0f, ReversionEyesPotion.getSoundPitch(e));
            }
        }
        return true;
    }

    public static float getSoundPitch(LivingEntity e) {
        return e.isBaby() ? (e.level().random.nextFloat() - e.level().random.nextFloat()) * 0.2f + 1.5f : (e.level().random.nextFloat() - e.level().random.nextFloat()) * 0.2f + 1.0f;
    }

    public static void damageEntity(LivingEntity e, DamageSource damageSrc, float damageAmount) {
        if (!e.isInvulnerable()) {
            DamageContainer container = new DamageContainer(damageSrc, damageAmount);
            if ((damageAmount = CommonHooks.onLivingDamagePre((LivingEntity)e, (DamageContainer)container)) <= 0.0f) {
                return;
            }
            float f = damageAmount;
            damageAmount = Math.max(damageAmount - e.getAbsorptionAmount(), 0.0f);
            e.setAbsorptionAmount(e.getAbsorptionAmount() - (f - damageAmount));
            container.setNewDamage(damageAmount);
            CommonHooks.onLivingDamagePost((LivingEntity)e, (DamageContainer)container);
            damageAmount = container.getNewDamage();
            if (damageAmount != 0.0f) {
                float f1 = e.getHealth();
                e.setHealth(f1 - damageAmount);
                e.setAbsorptionAmount(e.getAbsorptionAmount() - damageAmount);
            }
        }
    }

    public static void canBurn(LivingEntity e) {
        if (e.fireImmune()) {
            if (e.isInLava()) {
                e.hurt(e.damageSources().lava(), 4.0f);
                e.lastHurtByPlayerTime = 100;
                e.igniteForSeconds(15.0f);
            }
            if (!BlockPos.betweenClosedStream((AABB)e.getBoundingBox().deflate(0.001)).noneMatch(posIn -> {
                BlockState state = e.level().getBlockState(posIn);
                return state.is(BlockTags.FIRE) || state.is(Blocks.LAVA) || state.isBurning((BlockGetter)e.level(), posIn);
            })) {
                e.hurt(e.damageSources().inFire(), 1.0f);
            }
        }
    }

    public static void burnInDay(LivingEntity e) {
        float f;
        if (e instanceof Husk && (f = e.getLightLevelDependentMagicValue()) > 0.5f && e.level().random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && e.level().canSeeSky(Utils.toBlockPos(e.getX(), e.getY() + (double)e.getEyeHeight(), e.getZ()))) {
            boolean flag = true;
            ItemStack itemstack = e.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemstack.isEmpty()) {
                if (itemstack.isDamageableItem()) {
                    itemstack.setDamageValue(itemstack.getDamageValue() + e.level().random.nextInt(2));
                    if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                        e.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
                flag = false;
            }
            if (flag) {
                e.igniteForSeconds(8.0f);
            }
        }
    }

    public static void cantBreatheUnderwater(LivingEntity e) {
        if (e.isInWater()) {
            if (e instanceof WaterAnimal) {
                e.setAirSupply(-20);
            }
            if (e.canBreatheUnderwater() || e.hasEffect(MobEffects.WATER_BREATHING)) {
                e.setAirSupply(ReversionEyesPotion.decreaseAirSupply(e, e.getAirSupply()));
                if (e.getAirSupply() <= 0 && ServerHandler.tickCounter % 20L == 0L) {
                    e.setAirSupply(0);
                    for (int i = 0; i < 8; ++i) {
                        float f2 = e.getRandom().nextFloat() - e.getRandom().nextFloat();
                        float f = e.getRandom().nextFloat() - e.getRandom().nextFloat();
                        float f1 = e.getRandom().nextFloat() - e.getRandom().nextFloat();
                        e.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, e.getX() + (double)f2, e.getY() + (double)f, e.getZ() + (double)f1, e.getDeltaMovement().x, e.getDeltaMovement().y, e.getDeltaMovement().z);
                    }
                    e.hurt(e.damageSources().drown(), 2.0f);
                }
            }
        }
    }

    public static int decreaseAirSupply(LivingEntity e, int air) {
        int i = EnchantmentHelper.getEnchantmentLevel((Holder)((Registry)e.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolderOrThrow(Enchantments.RESPIRATION), (LivingEntity)e);
        return i > 0 && e.getRandom().nextInt(i + 1) > 0 ? air : air - 1;
    }
}

