/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells.boundary;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.TangibleBoundaryMahoujinTileEntity;

public class InvisibleBarrierBlock
extends BlockTileEntity<InvisibleBarrierBlockTileEntity> {
    AABB collisionCaster = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    VoxelShape castershape = Shapes.create((AABB)this.collisionCaster);
    AABB collisionElse = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    VoxelShape elseshape = Shapes.create((AABB)this.collisionElse);

    public InvisibleBarrierBlock() {
        super(BlockBehaviour.Properties.of().forceSolidOn().noOcclusion().strength(5.0f, 10.0f), "invisible_barrier_block");
    }

    public List<ItemStack> getDrops(BlockState p_287732_, LootParams.Builder p_287596_) {
        return new ArrayList<ItemStack>();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult result, Projectile entityIn) {
        this.entityInside(state, worldIn, result.getBlockPos(), (Entity)entityIn);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.isClientSide && entityIn != null && entityIn.isAlive()) {
            UUID entUUID = entityIn.getUUID();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)worldIn.getBlockEntity(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID)) {
                    return;
                }
                Direction side = Direction.NORTH;
                if (entityIn.getX() < (double)pos.getX()) {
                    side = Direction.WEST;
                } else if (entityIn.getX() > (double)(pos.getX() + 1)) {
                    side = Direction.EAST;
                } else if (entityIn.getY() < (double)pos.getY()) {
                    side = Direction.DOWN;
                } else if (entityIn.getY() > (double)(pos.getY() + 1)) {
                    side = Direction.UP;
                } else if (entityIn.getZ() < (double)pos.getZ()) {
                    side = Direction.NORTH;
                } else if (entityIn.getZ() > (double)(pos.getZ() + 1)) {
                    side = Direction.SOUTH;
                }
                te.setTimeOfCollision(worldIn.getGameTime(), side);
            }
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Entity e;
        if (context instanceof EntityCollisionContext && (e = ((EntityCollisionContext)context).getEntity()) != null && e.isAlive()) {
            UUID entUUID = e.getUUID();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)reader.getBlockEntity(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (!(te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID))) {
                    return this.elseshape;
                }
            }
            if (e.isCrouching()) {
                return this.elseshape;
            }
        }
        return this.castershape;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity te;
        if (world.getGameTime() % 100L == 0L && (te = world.getBlockEntity(pos)) instanceof InvisibleBarrierBlockTileEntity) {
            try {
                BlockEntity tte = world.getBlockEntity(((InvisibleBarrierBlockTileEntity)te).boundaryCircle);
                if (tte instanceof TangibleBoundaryMahoujinTileEntity) {
                    int radius;
                    TangibleBoundaryMahoujinTileEntity mte = (TangibleBoundaryMahoujinTileEntity)tte;
                    if (!mte.shouldIPerformBarrier()) {
                        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    }
                    if ((radius = mte.getBarrierRadius()) != Math.abs(pos.getX() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.getX()) || radius != Math.abs(pos.getY() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.getY()) || radius != Math.abs(pos.getZ() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.getZ())) {
                        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    }
                } else {
                    world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
            }
            catch (Exception e) {
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    @Override
    public Class<InvisibleBarrierBlockTileEntity> getTileEntityClass() {
        return InvisibleBarrierBlockTileEntity.class;
    }

    @Nullable
    public InvisibleBarrierBlockTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new InvisibleBarrierBlockTileEntity(blockPos, blockState);
    }

    public boolean propagatesSkylightDown(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public VoxelShape getOcclusionShape(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return this.castershape;
    }

    public boolean hasDynamicShape() {
        return true;
    }
}

