/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.caliburn;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.GrowSwordItem;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FakeSkeleton;

public class Caliburn
extends GrowSwordItem {
    public Caliburn() {
        super((Tier)Tiers.IRON, -2.4f, 3, MTConfig.POWER_CONSOLIDATION_DURABILITY);
    }

    public static float simulateHit(ItemStack s, Level world) {
        float ret = 3.0f;
        int health = 5000000;
        if (Attributes.ATTACK_DAMAGE.value() instanceof RangedAttribute) {
            ((RangedAttribute)Attributes.ATTACK_DAMAGE.value()).maxValue = Math.max(((RangedAttribute)Attributes.ATTACK_DAMAGE.value()).maxValue, (double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
        }
        if (s != null) {
            ItemStack s1 = s.copy();
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)world, "faker");
            fake_player.setItemInHand(InteractionHand.MAIN_HAND, s1);
            Caliburn.updateAttr(s1, (Player)fake_player, EquipmentSlot.MAINHAND);
            ((Player)fake_player).attackStrengthTicker = 1000;
            fake_player.attack((Entity)fake_target);
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public static void updateAttr(ItemStack s1, Player fake_player, EquipmentSlot hand) {
        s1.forEachModifier(hand, (p_352705_, p_352706_) -> {
            Level patt0$temp;
            AttributeInstance attributeinstance = fake_player.getAttributes().getInstance(p_352705_);
            if (attributeinstance != null) {
                attributeinstance.removeModifier(p_352706_.id());
                attributeinstance.addTransientModifier(p_352706_);
            }
            if ((patt0$temp = fake_player.level()) instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)patt0$temp;
                EnchantmentHelper.runLocationChangedEffects((ServerLevel)serverlevel, (ItemStack)s1, (LivingEntity)fake_player, (EquipmentSlot)hand);
            }
        });
    }

    public static boolean specialTarget(LivingEntity entity) {
        if (EffectUtil.inEntityBlacklist((Entity)entity, MTConfig.POWER_CONSOLIDATION_FEAR_BLACKLIST)) {
            return false;
        }
        return entity.isInvertedHealAndHarm() || entity.getMainHandItem().getItem() instanceof Morgan || entity.getOffhandItem().getItem() instanceof Morgan || Caliburn.containsKeyword(entity.getName().getString().toLowerCase()) || Caliburn.containsKeyword(entity.getDisplayName().toString().toLowerCase());
    }

    public static boolean containsKeyword(String name) {
        List<? extends String> arr = MTConfig.UNHOLY_WORDS;
        for (int i = 0; i < arr.size(); ++i) {
            if (!name.contains(arr.get(i))) continue;
            return true;
        }
        int numKeys = arr.size();
        for (int i = 1; i < numKeys + 1; ++i) {
            if (!name.contains(Component.translatable((String)("mahoutsukai.caliburnkeyword" + i)).getString())) continue;
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        player.startUsingItem(handIn);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(handIn));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        if (player != null && !worldIn.isClientSide) {
            int radius = MTConfig.POWER_CONSOLIDATION_PULL_RADIUS;
            AABB aabb = new AABB(player.blockPosition().offset(-radius, -4, -radius).getCenter(), player.blockPosition().offset(radius, 4, radius).getCenter());
            List lst = worldIn.getEntitiesOfClass(LivingEntity.class, aabb);
            double score = -1.0;
            double chosendist = 0.0;
            LivingEntity chosen = null;
            for (LivingEntity target : lst) {
                if (target.getUUID().equals(player.getUUID()) || !EffectUtil.isLookingAtMe((Entity)target, player, 45) || !Caliburn.specialTarget(target)) continue;
                double d = Math.abs(EffectUtil.pointToLineDistance(target.position(), player.getEyePosition(1.0f), player.getLookAngle().add(player.getEyePosition(1.0f))));
                double e = target.position().distanceTo(player.position());
                if (score != -1.0 && !(score > d * d + e)) continue;
                score = d * d + e;
                chosen = target;
                chosendist = e;
            }
            if (chosen != null) {
                Vec3 chosenDirection = chosen.position().subtract(player.position());
                Caliburn.boop((Entity)player, (float)(chosendist / 8.0), -chosenDirection.x, -chosenDirection.y, -chosenDirection.z);
                Caliburn.boop(chosen, (float)(chosendist / 8.0), chosenDirection.x, chosenDirection.y, chosenDirection.z);
            }
        }
        super.releaseUsing(stack, worldIn, player, timeLeft);
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.hurtMarked = true;
        if (entity.onGround()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.setDeltaMovement(new Vec3(motionX, motionY, motionZ));
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public static void upgradeDamageCap(AttackEntityEvent event) {
        if (Attributes.ATTACK_DAMAGE.value() instanceof RangedAttribute) {
            ((RangedAttribute)Attributes.ATTACK_DAMAGE.value()).maxValue = Math.max(((RangedAttribute)Attributes.ATTACK_DAMAGE.value()).maxValue, (double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
        }
    }
}

