/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.VanillaGameEvent;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RipperInvisiblePacket;
import stepsword.mahoutsukai.potion.CooldownPotion;
import stepsword.mahoutsukai.potion.ExtraPotionInterface;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisCooldownPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class RipperInvisPotion
extends CooldownPotion
implements ExtraPotionInterface {
    protected RipperInvisPotion() {
    }

    @Override
    public void onRemove(LivingEntity livingEntity, MobEffect effect) {
        RipperInvisPotion.notifyNotInvisible(livingEntity);
        EffectUtil.debuff(livingEntity, (Holder<MobEffect>)MobEffects.INVISIBILITY);
    }

    @Override
    public void onAdd(LivingEntity livingEntity, MobEffect effect) {
        RipperInvisPotion.notifyIfInvisible(livingEntity);
        EffectUtil.buff(livingEntity, (Holder<MobEffect>)MobEffects.INVISIBILITY, false, 2000000000, false);
    }

    public static void notifyIfInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisPotion.notifyTracking(lst, true, e.level());
        }
    }

    public static void notifyNotInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        RipperInvisPotion.notifyTracking(lst, false, e.level());
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RipperInvisiblePacket(e.getId(), r));
            }
        }
    }

    public static void presenceConcealmentLivingTick(LivingEntity e) {
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisCooldownPotion.nudge(e);
        }
    }

    public static boolean presenceConcealmentNoSound(VanillaGameEvent event) {
        Entity e = event.getCause();
        Entity src = event.getContext().sourceEntity();
        boolean w = e instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)e, ModEffects.RIPPER_INVISIBILITY);
        boolean q = src instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)src, ModEffects.RIPPER_INVISIBILITY);
        return w || q;
    }
}

