/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.WilliamEntity;
import stepsword.mahoutsukai.item.william.William;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.item.BookRender;
import stepsword.mahoutsukai.render.item.WilliamRenderer;

public class RenderWilliamEntity
extends EntityRenderer<WilliamEntity> {
    public static ArrayList<ResourceLocation> rune_loc = null;

    public RenderWilliamEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(WilliamEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(WilliamEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderWilliam(WilliamEntity entity, double x, double y, double z, float roll, PoseStack matrix, float partialTicks) {
        matrix.pushPose();
        matrix.translate(x, y, z);
        float pitch = entity.getRotationPitch();
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        BookRender br = entity.br;
        BookRender last = entity.last_br;
        if (rune_loc == null) {
            rune_loc = new ArrayList();
            for (int i = 0; i < 24; ++i) {
                rune_loc.add(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)("textures/entity/runefont/" + i + ".png")));
            }
        }
        float[][] colors = WilliamRenderer.getColorSet(entity.getStack(), !William.isRlyeh(entity.getStack()));
        if (entity.page_colors == null) {
            entity.page_colors = colors[0];
        }
        if (entity.cover_colors == null) {
            entity.cover_colors = colors[1];
        }
        if (entity.text_colors == null) {
            entity.text_colors = colors[2];
        }
        if (entity.circle_colors == null) {
            entity.circle_colors = colors[3];
        }
        BookRender brr = br.partial(last, partialTicks);
        WilliamRenderer.renderBook(0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f, 0.5f, matrix, (MultiBufferSource)buffer, brr, entity.page_colors, entity.cover_colors, entity.text_colors);
        matrix.popPose();
        RenderWilliamEntity.renderCircles(entity.br, matrix, x, y, z, buffer, roll, pitch, partialTicks, entity.clientTicks, entity.circle_colors);
    }

    public static void renderCircles(BookRender br, PoseStack matrix, double x, double y, double z, MultiBufferSource.BufferSource buffer, float roll, float pitch, float partial, long ticks, float[] circle_color) {
        RenderType circle = MahoujinRenderType.createWilliamRenderType(RenderUtils.mahoujin, 0);
        matrix.pushPose();
        matrix.translate(x, y, z);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, matrix);
        matrix.scale(0.5f, 0.5f, 0.5f);
        matrix.translate(0.0, -0.4, -br.cover_height / 2.0);
        RenderUtils.rotateQ(((float)ticks - (1.0f - partial)) * 3.0f, 0.0f, 1.0f, 0.0f, matrix);
        Matrix4f m = matrix.last().pose();
        VertexConsumer circle_buf = buffer.getBuffer(circle);
        RenderUtils.addPoint(circle_buf, m, -1.0, 0.0, -1.0, circle_color).setUv(0.0f, 0.0f).setUv2(240, 240);
        RenderUtils.addPoint(circle_buf, m, -1.0, 0.0, 1.0, circle_color).setUv(0.0f, 1.0f).setUv2(240, 240);
        RenderUtils.addPoint(circle_buf, m, 1.0, 0.0, -1.0, circle_color).setUv(1.0f, 0.0f).setUv2(240, 240);
        RenderUtils.addPoint(circle_buf, m, 1.0, 0.0, 1.0, circle_color).setUv(1.0f, 1.0f).setUv2(240, 240);
        RenderUtils.conditionalBatchEnder(circle, (MultiBufferSource)buffer);
        matrix.popPose();
    }
}

