/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.fluids.MurkyFluid;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.render.overlay.RenderFogProjectors;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderPowerConsolidation {
    public static float distanceToMurkyWater(Entity entity) {
        int r = (int)MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        BlockPos minPos = entity.blockPosition().offset(-r, -r, -r);
        BlockPos maxPos = entity.blockPosition().offset(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        float ret = -1.0f;
        try {
            for (int x = minCPos.x; x < maxCPos.x + 1; ++x) {
                for (int z = minCPos.z; z < maxCPos.z + 1; ++z) {
                    LevelChunk c = entity.level().getChunk(x, z);
                    IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                    ConcurrentSet<BlockPos> blocks = chunkMahou.getLakeBlocks();
                    if (blocks == null || blocks.size() <= 0) continue;
                    for (BlockPos p : blocks) {
                        Block b = entity.level().getBlockState(p).getBlock();
                        if (b != ModBlocks.murkyFluid.get() || Math.abs(p.getX() - entity.blockPosition().getX()) >= r || Math.abs(p.getZ() - entity.blockPosition().getZ()) >= r || Math.abs(p.getY() - entity.blockPosition().getY()) >= r) continue;
                        float d = (float)entity.position().distanceTo(EffectUtil.fromBlockPos(p).add(0.5, 0.5, 0.5));
                        if (ret == -1.0f) {
                            ret = d;
                        }
                        if (!(ret > d)) continue;
                        ret = d;
                    }
                }
            }
        }
        catch (Exception e) {
            return -1.0f;
        }
        return ret;
    }

    public static boolean powerConsolidationFogColor(ViewportEvent.ComputeFogColor event) {
        boolean ret = false;
        double d = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.getInstance().getCameraEntity());
        if (Utils.isInMurkyWater(Minecraft.getInstance().getCameraEntity())) {
            event.setRed(0.0f);
            event.setGreen(0.15686275f);
            event.setBlue(0.0f);
            ret = true;
        } else if (d <= MTConfig.POWER_CONSOLIDATION_FOG_RADIUS && d >= 0.0) {
            float c = 180.0f;
            float td = 0.0f;
            float tr = 0.0f;
            float tg = 0.0f;
            float tb = 0.0f;
            double colorstrength = (MTConfig.POWER_CONSOLIDATION_FOG_RADIUS - d) / MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
            td = (float)((double)td + (colorstrength *= 2.0));
            tr = (float)((double)tr + (double)c * colorstrength);
            tg = (float)((double)tg + (double)c * colorstrength);
            tb = (float)((double)tb + (double)c * colorstrength);
            float r = (tr += event.getRed() * 255.0f) / (td += 1.0f) / 255.0f;
            float g = (tg += event.getGreen() * 255.0f) / td / 255.0f;
            float b = (tb += event.getBlue() * 255.0f) / td / 255.0f;
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
            ret = true;
        }
        return ret;
    }

    public static boolean powerConsolidationBlockOverlay(RenderBlockScreenEffectEvent event) {
        return Minecraft.getInstance().getCameraEntity() != null && Utils.isInMurkyWater(Minecraft.getInstance().getCameraEntity());
    }

    public static boolean powerConsolidationRenderFog(ViewportEvent.RenderFog event) {
        boolean ret = RenderPowerConsolidation.doFog(event.getNearPlaneDistance(), event.getFarPlaneDistance(), event);
        if (ret) {
            event.setFogShape(FogShape.SPHERE);
        }
        return ret;
    }

    public static void powerConsolidationFogDensity(ViewportEvent.RenderFog event) {
        if (Utils.isInMurkyWater(Minecraft.getInstance().getCameraEntity())) {
            event.setNearPlaneDistance(-8.0f);
            event.setFarPlaneDistance(5.0f);
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
            RenderSystem.setShaderFogColor((float)((float)MurkyFluid.COLOR.getRed() / 255.0f), (float)((float)MurkyFluid.COLOR.getGreen() / 255.0f), (float)((float)MurkyFluid.COLOR.getBlue() / 255.0f), (float)1.0f);
        }
    }

    public static boolean doFog(float nearPlane, float farPlane, ViewportEvent.RenderFog event) {
        double f = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.getInstance().getCameraEntity());
        double top = MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        if ((f = Math.min(f, top)) > 0.0) {
            double strength = 50.0 - 50.0 / top * f;
            double f1 = Math.min(strength, (double)FogProjectorScreen.camera_fog_strength_max) / (double)FogProjectorScreen.camera_fog_strength_max;
            float oldstart = nearPlane;
            double f2 = RenderFogProjectors.fogScaleFormula(farPlane, f1);
            double f3 = RenderFogProjectors.fogScaleFormula(oldstart, f1);
            double fogStart = Mth.clamp((double)f3, (double)1.0, (double)oldstart);
            double fogEnd = Mth.clamp((double)f2, (double)4.0, (double)farPlane);
            if (oldstart == 0.0f) {
                fogStart = 0.0;
            }
            float fg = 0.7058824f;
            event.setNearPlaneDistance((float)fogStart);
            event.setFarPlaneDistance((float)fogEnd);
            event.setFogShape(FogShape.SPHERE);
            return true;
        }
        return false;
    }
}

