/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.MahoujinBlockTileEntity;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.catalysts.PowderedCatalyst;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.OrderedDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ChronalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class Mahoujin
extends MahoujinBlockTileEntity<MahoujinTileEntity> {
    public Mahoujin() {
        super("mahoujin");
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult result) {
        if (!worldIn.f_46443_) {
            IMahou mahou;
            MahoujinTileEntity mahoujin = (MahoujinTileEntity)((Object)this.getTileEntity(worldIn, pos));
            ItemStack stack = playerIn.m_21120_(hand);
            if (mahoujin != null && stack.m_41720_() instanceof PowderedCatalyst) {
                if (mahoujin.getNumCatalysts() < 3) {
                    mahoujin.setCasterUUID(playerIn.m_20148_());
                    if (mahoujin.addCatalyst((PowderedCatalyst)stack.m_41720_())) {
                        stack.m_41774_(1);
                        this.transformToSpell(mahoujin, worldIn, playerIn, pos);
                    }
                }
            } else if (mahoujin != null && stack.m_41619_() && mahoujin.getNumCatalysts() == 0 && (mahou = Utils.getPlayerMahou(playerIn)) != null && mahou.getLastRecipe() != null && mahou.getLastRecipe().size() == 3) {
                boolean cloth = mahou.getLastRecipeCloth();
                UnorderedList ul = mahou.getLastRecipe();
                boolean hasClothInInventory = false;
                boolean hasAllCatalysts = true;
                Set<String> hs = ul.getKeys();
                HashMap<String, Integer> zz = new HashMap<String, Integer>();
                for (String h : hs) {
                    zz.put(h, ul.get(h));
                }
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                for (int i = 0; i < playerIn.m_150109_().f_35974_.size(); ++i) {
                    IItemHandler inv;
                    ItemStack st = (ItemStack)playerIn.m_150109_().f_35974_.get(i);
                    if (st.m_41720_() instanceof PowderedCatalyst) {
                        PowderedCatalyst c = (PowderedCatalyst)st.m_41720_();
                        for (String s : hs) {
                            if (!c.getCatalystName().equals(s)) continue;
                            if (counts.containsKey(s)) {
                                counts.put(s, (Integer)counts.get(s) + st.m_41613_());
                                continue;
                            }
                            counts.put(s, st.m_41613_());
                        }
                    } else if (Utils.getInventory(stack) != null && (inv = Utils.getInventory(stack)) != null) {
                        for (int j = 0; j < inv.getSlots(); ++j) {
                            ItemStack st2 = inv.getStackInSlot(j);
                            if (st2.m_41720_() instanceof PowderedCatalyst) {
                                PowderedCatalyst c = (PowderedCatalyst)st2.m_41720_();
                                for (String s : hs) {
                                    if (!c.getCatalystName().equals(s)) continue;
                                    if (counts.containsKey(s)) {
                                        counts.put(s, (Integer)counts.get(s) + st2.m_41613_());
                                        continue;
                                    }
                                    counts.put(s, st2.m_41613_());
                                }
                            }
                            if (st2.m_41720_() != Item.m_41439_((Block)((Block)ModBlocks.spellClothBlock.get()))) continue;
                            hasClothInInventory = true;
                        }
                    }
                    if (st.m_41720_() != Item.m_41439_((Block)((Block)ModBlocks.spellClothBlock.get()))) continue;
                    hasClothInInventory = true;
                }
                for (String s : hs) {
                    if (counts.containsKey(s)) {
                        if (ul.get(s) <= (Integer)counts.get(s)) continue;
                        hasAllCatalysts = false;
                        continue;
                    }
                    hasAllCatalysts = false;
                }
                boolean clothTaken = false;
                if (hasAllCatalysts && (!cloth || hasClothInInventory)) {
                    for (int i = 0; i < playerIn.m_150109_().f_35974_.size(); ++i) {
                        IItemHandler inv;
                        ItemStack s = (ItemStack)playerIn.m_150109_().f_35974_.get(i);
                        if (s.m_41619_()) continue;
                        if (cloth && s.m_41720_() == Item.m_41439_((Block)((Block)ModBlocks.spellClothBlock.get())) && !clothTaken) {
                            s.m_41774_(1);
                            clothTaken = true;
                            mahoujin.setCloth(true);
                        }
                        if (s.m_41720_() instanceof PowderedCatalyst) {
                            int r;
                            String name = ((PowderedCatalyst)s.m_41720_()).getCatalystName();
                            if (!zz.containsKey(name) || (r = ((Integer)zz.get(name)).intValue()) <= 0) continue;
                            if (s.m_41613_() >= r) {
                                s.m_41774_(r);
                                zz.put(name, 0);
                                continue;
                            }
                            if (s.m_41613_() >= r) continue;
                            s.m_41774_(s.m_41613_());
                            zz.put(name, r - s.m_41613_());
                            continue;
                        }
                        if (Utils.getInventory(stack) == null || (inv = Utils.getInventory(stack)) == null) continue;
                        for (int j = 0; j < inv.getSlots(); ++j) {
                            int r;
                            String name;
                            ItemStack st2 = inv.getStackInSlot(j);
                            if (cloth && st2.m_41720_() == Item.m_41439_((Block)((Block)ModBlocks.spellClothBlock.get())) && !clothTaken) {
                                st2.m_41774_(1);
                                clothTaken = true;
                                mahoujin.setCloth(true);
                            }
                            if (!(st2.m_41720_() instanceof PowderedCatalyst) || !zz.containsKey(name = ((PowderedCatalyst)st2.m_41720_()).getCatalystName()) || (r = ((Integer)zz.get(name)).intValue()) <= 0) continue;
                            if (st2.m_41613_() >= r) {
                                st2.m_41774_(r);
                                zz.put(name, 0);
                                continue;
                            }
                            if (st2.m_41613_() >= r) continue;
                            st2.m_41774_(st2.m_41613_());
                            zz.put(name, r - st2.m_41613_());
                        }
                    }
                    mahoujin.setCatalysts(ul);
                    this.transformToSpell(mahoujin, worldIn, playerIn, pos);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void transformToSpell(MahoujinTileEntity mahoujin, Level worldIn, Player playerIn, BlockPos pos) {
        if (mahoujin.getNumCatalysts() == 3) {
            boolean gamestages;
            BlockBase newBlock = MahoujinRecipeRegistrar.recipes.get(mahoujin.getCatalysts());
            boolean bl = gamestages = MahouTsukaiMod.gamestages.reachedStage((ServerPlayer)playerIn, Mahoujin.getClassOfSpell(mahoujin.getCatalysts())) || MahouTsukaiMod.gamestages.reachedStage((ServerPlayer)playerIn, "mahoutsukai_" + ForgeRegistries.BLOCKS.getKey((Object)newBlock).m_135815_());
            if (!MTConfig.GAMESTAGES_ENABLED) {
                gamestages = true;
            }
            boolean banned = EffectUtil.inBlockBlacklist(newBlock, MTConfig.SPELL_BLACKLIST);
            if (gamestages && newBlock != null && !banned) {
                UnorderedList catalystsCarry = mahoujin.getCatalysts();
                UUID casterUUIDCarry = mahoujin.getCasterUUID();
                boolean cloth = mahoujin.hasCloth();
                boolean needsCloth = MahoujinRecipeRegistrar.needsCloth.containsKey(catalystsCarry) && MahoujinRecipeRegistrar.needsCloth.get(catalystsCarry) != false;
                boolean fay = mahoujin.isFay();
                if (!needsCloth || cloth) {
                    IMahou mahou;
                    worldIn.m_46597_(pos, newBlock.m_49966_());
                    MahoujinTileEntity mte = (MahoujinTileEntity)worldIn.m_7702_(pos);
                    if (mte != null) {
                        mte.setCatalysts(catalystsCarry);
                        mte.setCasterUUID(casterUUIDCarry);
                        mte.setCloth(cloth);
                        mte.setFay(fay);
                    }
                    if (mte instanceof OrderedDisplacementMahoujinTileEntity) {
                        OrderedDisplacementMahoujinTileEntity odmte = (OrderedDisplacementMahoujinTileEntity)mte;
                        odmte.setTeleporterId(worldIn.m_46467_());
                    }
                    if (mte instanceof ChronalExchangeMahoujinTileEntity) {
                        ((ChronalExchangeMahoujinTileEntity)mte).setTime(0L);
                    }
                    if (mte instanceof AlchemicalExchangeMahoujinTileEntity) {
                        long z = worldIn.m_46468_() % 24000L;
                        if (z < 0L) {
                            z += 24000L;
                        }
                        z -= z % 20L;
                        ((AlchemicalExchangeMahoujinTileEntity)mte).setPlacedTime(z + 100L);
                    }
                    if ((mahou = Utils.getPlayerMahou(playerIn)) != null) {
                        mahou.setLastRecipeCloth(cloth);
                        mahou.setLastRecipe(catalystsCarry);
                        PlayerManaManager.updateClientMahou((ServerPlayer)playerIn, mahou);
                    }
                }
            }
        }
    }

    public static String getClassOfSpell(UnorderedList lst) {
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedDiamond.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedDiamond.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_projection";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedEnder.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedEnder.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_displacement";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedQuartz.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedQuartz.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_familiar";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedGold.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedGold.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_mystic";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedIron.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedIron.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_boundary";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedEmerald.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedEmerald.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_exchange";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedEye.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedEye.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_mystic_eyes";
        }
        return "mahoutsukai_secret";
    }

    public static boolean hasCatalyst(UnorderedList lst, PowderedCatalyst catalyst) {
        if (lst != null && lst.getKeys() != null && catalyst != null) {
            return lst.getKeys().contains(catalyst.getCatalystName());
        }
        return false;
    }

    @Override
    public Class<MahoujinTileEntity> getTileEntityClass() {
        return MahoujinTileEntity.class;
    }

    @Nullable
    public MahoujinTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MahoujinTileEntity(blockPos, blockState);
    }
}

