/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.networking.MahoujinProjectorUpdatePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.render.gui.MahouEditBox;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;

public class MahoujinProjectorScreen
extends Screen {
    private MahouEditBox rvalue;
    private MahouEditBox gvalue;
    private MahouEditBox bvalue;
    private MahouEditBox avalue;
    private MahouEditBox xvalue;
    private MahouEditBox yvalue;
    private MahouEditBox zvalue;
    private MahouEditBox sizevalue;
    private MahouEditBox yawvalue;
    private MahouEditBox speedvalue;
    private MahouEditBox yspeedvalue;
    private MahouEditBox pspeedvalue;
    private MahouEditBox pitchvalue;
    private MahouEditBox ringvalue;
    private MahouEditBox imagevalue;
    private MahouEditBox runesvalue;
    private MahouEditBox ringheightvalue;
    private MahouEditBox rotationoffsetvalue;
    private MahouEditBox prepitchvalue;
    private MahouEditBox preyawvalue;
    private MahouEditBox orbitspeedvalue;
    private MahouEditBox gifspeedvalue;
    private Checkbox showcirclevalue;
    private Checkbox showringvalue;
    private Checkbox giflayervalue;
    private ArrayList<MahouEditBox> boxes = new ArrayList();
    private ArrayList<Checkbox> toggles = new ArrayList();
    Level world;
    BlockPos pos;

    public MahoujinProjectorScreen(Level w, BlockPos p) {
        super((Component)Component.m_237113_((String)"projector.screen"));
        this.world = w;
        this.pos = p;
    }

    public void m_7856_() {
        MahoujinProjectorTileEntity projector = null;
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int x1 = 70;
        int x2 = 280;
        int startery = 4;
        int distance = 5;
        int h = 20;
        int w = 137;
        int guiwidth = 420;
        if (guiwidth <= sw) {
            x1 = (sw - guiwidth) / 2 + 60;
            x2 = sw / 2 + 60;
        }
        if (this.world.m_7702_(this.pos) instanceof MahoujinProjectorTileEntity) {
            projector = (MahoujinProjectorTileEntity)this.world.m_7702_(this.pos);
        }
        this.rvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 0, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.rvalue"));
        this.gvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 1, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.gvalue"));
        this.bvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 2, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.bvalue"));
        this.avalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 3, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.avalue"));
        this.xvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 0, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.xvalue"));
        this.yvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 1, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.yvalue"));
        this.zvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 2, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.zvalue"));
        this.sizevalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 3, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.sizevalue"));
        this.yawvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 4, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.yawvalue"));
        this.pitchvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 5, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.pitchvalue"));
        this.speedvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 4, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.speedvalue"));
        this.ringvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 5, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.ringvalue"));
        this.ringheightvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 6, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.ringheightvalue"));
        this.rotationoffsetvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 6, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.rotationoffsetvalue"));
        this.showcirclevalue = new Checkbox(x1, startery + (distance + h) * 7, w, h, (Component)Component.m_237113_((String)"Show Circle"), true);
        this.showringvalue = new Checkbox(x2, startery + (distance + h) * 7, w, h, (Component)Component.m_237113_((String)"Show Ring"), true);
        this.giflayervalue = new Checkbox(x1, startery + (distance + h) * 8, w, h, (Component)Component.m_237113_((String)"Gif Layer"), false);
        this.imagevalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 8 - 2, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.imagevalue"));
        this.runesvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 9 - 2, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.runesvalue"));
        this.pspeedvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 10, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.yspeedvalue"));
        this.yspeedvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 10, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.pspeedvalue"));
        this.prepitchvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 11, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.prepitchvalue"));
        this.preyawvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 11, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.preyawvalue"));
        this.orbitspeedvalue = new MahouEditBox(this.f_96547_, x1, startery + (distance + h) * 12, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.orbitspeedvalue"));
        this.gifspeedvalue = new MahouEditBox(this.f_96547_, x2, startery + (distance + h) * 12, w, h, (Component)Component.m_237115_((String)"mahoutsukai.projector.gifspeedvalue"));
        if (projector != null) {
            this.rvalue.m_94144_("" + projector.pv.getCr());
            this.gvalue.m_94144_("" + projector.pv.getCg());
            this.bvalue.m_94144_("" + projector.pv.getCb());
            this.avalue.m_94144_("" + projector.pv.getCa());
            this.xvalue.m_94144_("" + projector.pv.getCx());
            this.yvalue.m_94144_("" + projector.pv.getCy());
            this.zvalue.m_94144_("" + projector.pv.getCz());
            this.sizevalue.m_94144_("" + projector.pv.getCsize());
            this.yawvalue.m_94144_("" + projector.pv.getCyaw());
            this.pitchvalue.m_94144_("" + projector.pv.getCpitch());
            this.speedvalue.m_94144_("" + projector.pv.getCspeed());
            this.yspeedvalue.m_94144_("" + projector.pv.getCyspeed());
            this.pspeedvalue.m_94144_("" + projector.pv.getCpspeed());
            this.ringvalue.m_94144_("" + projector.pv.getCringangle());
            this.imagevalue.m_94144_("" + projector.pv.getImage());
            this.runesvalue.m_94144_("" + projector.pv.getRunes());
            this.ringheightvalue.m_94144_("" + projector.pv.getHeight());
            this.rotationoffsetvalue.m_94144_("" + projector.pv.getRotationOffset());
            this.orbitspeedvalue.m_94144_("" + projector.pv.getCorbitspeed());
            this.preyawvalue.m_94144_("" + projector.pv.getCpreyaw());
            this.prepitchvalue.m_94144_("" + projector.pv.getCprepitch());
            this.gifspeedvalue.m_94144_("" + projector.pv.getGifSpeed());
            if (projector.pv.getShowCircle() != this.showcirclevalue.m_93840_()) {
                this.showcirclevalue.m_5691_();
            }
            if (projector.pv.getShowRing() != this.showringvalue.m_93840_()) {
                this.showringvalue.m_5691_();
            }
            if (projector.pv.getGifLayer() != this.giflayervalue.m_93840_()) {
                this.giflayervalue.m_5691_();
            }
        }
        this.boxes.addAll(Arrays.asList(this.rvalue, this.gvalue, this.bvalue, this.avalue, this.xvalue, this.yvalue, this.zvalue, this.sizevalue, this.yawvalue, this.pitchvalue, this.speedvalue, this.yspeedvalue, this.pspeedvalue, this.ringvalue, this.imagevalue, this.runesvalue, this.ringheightvalue, this.rotationoffsetvalue, this.orbitspeedvalue, this.preyawvalue, this.prepitchvalue, this.gifspeedvalue));
        this.toggles.addAll(Arrays.asList(this.showcirclevalue, this.showringvalue, this.giflayervalue));
        super.m_7856_();
    }

    public boolean m_5534_(char c1, int c2) {
        boolean ret = false;
        for (EditBox editBox : this.boxes) {
            ret |= editBox.m_5534_(c1, c2);
        }
        this.updateTE();
        return ret || super.m_5534_(c1, c2);
    }

    public void m_86600_() {
        for (EditBox editBox : this.boxes) {
            editBox.m_94120_();
        }
        super.m_86600_();
    }

    public boolean m_7933_(int k1, int k2, int k3) {
        boolean ret = false;
        for (EditBox editBox : this.boxes) {
            ret |= editBox.m_7933_(k1, k2, k3);
        }
        this.updateTE();
        return ret || super.m_7933_(k1, k2, k3);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (EditBox editBox : this.boxes) {
            editBox.m_6375_(mouseX, mouseY, mouseButton);
        }
        for (Checkbox checkbox : this.toggles) {
            checkbox.m_6375_(mouseX, mouseY, mouseButton);
        }
        this.updateTE();
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_88315_(GuiGraphics s, int a, int b, float c) {
        this.m_280273_(s);
        for (MahouEditBox mahouEditBox : this.boxes) {
            mahouEditBox.m_88315_(s, a, b, c);
        }
        for (Checkbox checkbox : this.toggles) {
            checkbox.m_88315_(s, a, b, c);
        }
        for (MahouEditBox mahouEditBox : this.boxes) {
            this.drawStringForMessage(s, mahouEditBox);
        }
        super.m_88315_(s, a, b, c);
    }

    public void drawStringForMessage(GuiGraphics graphics, MahouEditBox w) {
        int offset1 = -1;
        this.drawRightAligned(graphics, this.f_96547_, w.m_6035_().getString(), w.f_93620_ + offset1, w.f_93621_ + w.m_93694_() / 4, 0xE0E0E0);
    }

    public void drawRightAligned(GuiGraphics graphics, Font font, String text, int x, int y, int color) {
        font.m_271703_(text, (float)(x - font.m_92895_(text)), (float)y, color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void updateTE() {
        float offsetcap = (float)MTConfig.PROJECTOR_OFFSET_CAP;
        float sizecap = (float)MTConfig.PROJECTOR_SIZE_CAP;
        int r = this.parseIntLimit(this.rvalue.m_94155_(), 0, 255);
        int g = this.parseIntLimit(this.gvalue.m_94155_(), 0, 255);
        int b = this.parseIntLimit(this.bvalue.m_94155_(), 0, 255);
        int a = this.parseIntLimit(this.avalue.m_94155_(), 0, 255);
        float x = this.parseFloatLimit(this.xvalue.m_94155_(), -offsetcap, offsetcap);
        float y = this.parseFloatLimit(this.yvalue.m_94155_(), -offsetcap, offsetcap);
        float z = this.parseFloatLimit(this.zvalue.m_94155_(), -offsetcap, offsetcap);
        float size = this.parseFloatLimit(this.sizevalue.m_94155_(), 0.0f, sizecap);
        float speed = this.parseFloatLimit(this.speedvalue.m_94155_(), -360.0f, 360.0f);
        float yspeed = this.parseFloatLimit(this.yspeedvalue.m_94155_(), -360.0f, 360.0f);
        float pspeed = this.parseFloatLimit(this.pspeedvalue.m_94155_(), -360.0f, 360.0f);
        float yaw = this.parseFloatLimit(this.yawvalue.m_94155_(), 0.0f, 360.0f);
        float pitch = this.parseFloatLimit(this.pitchvalue.m_94155_(), 0.0f, 360.0f);
        float ring = this.parseFloatLimit(this.ringvalue.m_94155_(), 0.0f, 90.0f);
        int image = this.parseIntLimit(this.imagevalue.m_94155_(), -1, 255);
        int runes = this.parseIntLimit(this.runesvalue.m_94155_(), -1, 255);
        float height = this.parseFloatLimit(this.ringheightvalue.m_94155_(), -200.0f, 200.0f);
        float roffset = this.parseFloatLimit(this.rotationoffsetvalue.m_94155_(), -360.0f, 360.0f);
        float preyaw = this.parseFloatLimit(this.preyawvalue.m_94155_(), 0.0f, 360.0f);
        float prepitch = this.parseFloatLimit(this.prepitchvalue.m_94155_(), 0.0f, 360.0f);
        float orbitspeed = this.parseFloatLimit(this.orbitspeedvalue.m_94155_(), -360.0f, 360.0f);
        float gifspeed = this.parseFloatLimit(this.gifspeedvalue.m_94155_(), -360.0f, 360.0f);
        boolean sc = this.showcirclevalue.m_93840_();
        boolean sr = this.showringvalue.m_93840_();
        boolean gl = this.giflayervalue.m_93840_();
        PacketHandler.sendToServer(new MahoujinProjectorUpdatePacket(r, g, b, a, x, y, z, size, speed, yaw, pitch, ring, sc, sr, this.pos, image, runes, height, yspeed, pspeed, roffset, prepitch, preyaw, orbitspeed, gifspeed, gl));
    }

    public int parseIntLimit(String s, int bottom, int top) {
        try {
            return Math.min(top, Math.max(Integer.parseInt(s), bottom));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float parseFloatLimit(String s, float bottom, float top) {
        try {
            return Math.min(top, Math.max(Float.parseFloat(s), bottom));
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

