/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.networking.MysticCodeSwitchPacket;
import stepsword.mahoutsukai.networking.PacketHandler;

public class WheelGui
extends Screen {
    private int NUM_SECTORS = 3;
    int slotSelected = -1;
    ItemStack stack;
    Level world;

    public WheelGui(Level w, ItemStack i) {
        super((Component)Component.m_237113_((String)""));
        this.world = w;
        this.stack = i;
        this.f_96541_ = Minecraft.m_91087_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int maxRadius = 80;
        double angle = WheelGui.mouseAngle(x, y, mouseX, mouseY);
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)this.NUM_SECTORS;
        this.slotSelected = -1;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        GlStateManager._disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172811_);
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < this.NUM_SECTORS; ++i) {
            boolean mouseInSector = (double)(degPer * (float)i) < angle && angle < (double)(degPer * (float)(i + 1));
            float radius = maxRadius;
            if (mouseInSector) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (i % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (i == 0) {
                buf.m_5483_((double)x, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
            if (mouseInSector) {
                this.slotSelected = i;
                b = 255;
                g = 255;
                r = 255;
            }
            for (float j = 0.0f; j < degPer + step / 2.0f; j += step) {
                float rad = j + (float)i * degPer;
                float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                if (j == 0.0f) {
                    buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
                }
                buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
        }
        tess.m_85914_();
        if (this.stack != null) {
            for (int j = 0; j < this.NUM_SECTORS; ++j) {
                String name;
                boolean mouseInSector = (double)(degPer * (float)j) < angle && angle < (double)(degPer * (float)(j + 1));
                float radius = maxRadius;
                if (mouseInSector) {
                    radius *= 1.025f;
                }
                float rad = ((float)j + 0.25f) * degPer;
                float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                float xsp = xp - 4.0f;
                float ysp = yp;
                if (this.stack.m_41720_() instanceof MysticCode) {
                    name = ((MysticCode)this.stack.m_41720_()).getSlotsForWheel(this.stack).get(j);
                    if (name.startsWith("Scroll of the")) {
                        name = name.substring("Scroll of the".length());
                    } else if (name.startsWith("Scroll of")) {
                        name = name.substring("Scroll of".length());
                    }
                } else {
                    name = "SLOT EMPTY";
                }
                int width = this.f_96547_.m_92895_(name);
                double mod = 0.6;
                int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
                int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
                if (xsp < (float)x) {
                    xsp -= (float)(width - 8);
                }
                if (ysp < (float)y) {
                    ysp -= 9.0f;
                }
                this.f_96547_.m_271703_(name, xsp, ysp, 0xFFFFFF, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                mod = 0.8;
                xdp = (int)((double)(xp - (float)x) * mod + (double)x);
                ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            }
        }
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.m_14136_((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    public void m_86600_() {
        super.m_86600_();
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Keybinds.changeMysticCode.getKey().m_84873_())) {
            this.f_96541_.m_91152_(null);
            if (this.slotSelected != -1) {
                int slot = this.slotSelected;
                MysticCodeSwitchPacket message = new MysticCodeSwitchPacket(slot);
                PacketHandler.sendToServer(message);
            }
        }
    }
}

