/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class FlatPortalAreaHelper
extends PortalFrameTester {
    protected final int maxXSize = 21;
    protected final int maxZSize = 21;
    protected int xSize = -1;
    protected int zSize = -1;

    @Override
    public FlatPortalAreaHelper init(LevelAccessor world, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.lowerCorner = this.getLowerCorner(blockPos, Direction.Axis.X, Direction.Axis.Z);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.zSize = 1;
            this.xSize = 1;
        } else {
            this.xSize = this.getSize(Direction.Axis.X, 2, 21);
            if (this.xSize > 0) {
                this.zSize = this.getSize(Direction.Axis.Z, 2, 21);
                if (this.checkForValidFrame(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize)) {
                    this.countExistingPortalBlocks(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize);
                } else {
                    this.lowerCorner = null;
                    this.zSize = 1;
                    this.xSize = 1;
                }
            }
        }
        return this;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(LevelAccessor worldAccess, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        return this.getOrEmpty(worldAccess, blockPos, areaHelper -> areaHelper.isValidFrame() && areaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(LevelAccessor worldAccess, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Block ... foundations) {
        return Optional.of(new FlatPortalAreaHelper().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.xSize * this.zSize;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.xSize >= 2 && this.zSize >= 2 && this.xSize < 21 && this.zSize < 21;
    }

    @Override
    public void lightPortal(Block frameBlock) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
        BlockState blockState = CustomPortalHelper.blockWithAxis(link != null ? link.getPortalBlock().defaultBlockState() : CustomPortalsMod.getDefaultPortalBlock().defaultBlockState(), Direction.Axis.Y);
        BlockPos.betweenClosed((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.relative(Direction.Axis.X, this.xSize - 1).relative(Direction.Axis.Z, this.zSize - 1)).forEach(blockPos -> this.world.setBlock(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(Level world, BlockPos pos, BlockState frameBlock, Direction.Axis axis) {
        int i;
        for (i = -1; i < 3; ++i) {
            world.setBlockAndUpdate(pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, -1), frameBlock);
            world.setBlockAndUpdate(pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 2), frameBlock);
            world.setBlockAndUpdate(pos.relative(Direction.Axis.Z, i).relative(Direction.Axis.X, -1), frameBlock);
            world.setBlockAndUpdate(pos.relative(Direction.Axis.Z, i).relative(Direction.Axis.X, 2), frameBlock);
        }
        for (i = 0; i < 2; ++i) {
            this.placeLandingPad(world, pos.relative(Direction.Axis.X, i).below(), frameBlock);
            this.placeLandingPad(world, pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 1).below(), frameBlock);
            this.fillAirAroundPortal(world, pos.relative(Direction.Axis.X, i).above());
            this.fillAirAroundPortal(world, pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 1).above());
            this.fillAirAroundPortal(world, pos.relative(Direction.Axis.X, i).above(2));
            this.fillAirAroundPortal(world, pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 1).above(2));
        }
        this.lowerCorner = pos;
        this.zSize = 2;
        this.xSize = 2;
        this.world = world;
        this.foundPortalBlocks = 4;
        this.lightPortal(frameBlock.getBlock());
    }

    protected void fillAirAroundPortal(Level world, BlockPos pos) {
        if (world.getBlockState(pos).isSolid()) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 16);
        }
    }

    protected void placeLandingPad(Level world, BlockPos pos, BlockState frameBlock) {
        if (!world.getBlockState(pos).isSolid()) {
            world.setBlockAndUpdate(pos, frameBlock);
        }
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return (this.xSize == attemptWidth || attemptHeight == 0) && this.zSize == attemptHeight || attemptWidth == 0 || (this.xSize == attemptHeight || attemptHeight == 0) && (this.zSize == attemptWidth || attemptWidth == 0);
    }

    @Override
    public BlockUtil.FoundRectangle getRectangle() {
        return new BlockUtil.FoundRectangle(this.lowerCorner, this.xSize, this.zSize);
    }

    @Override
    public Direction.Axis getAxis1() {
        return Direction.Axis.X;
    }

    @Override
    public Direction.Axis getAxis2() {
        return Direction.Axis.Z;
    }

    @Override
    public BlockPos doesPortalFitAt(Level world, BlockPos attemptPos, Direction.Axis axis) {
        BlockUtil.FoundRectangle rect = BlockUtil.getLargestRectangleAround((BlockPos)attemptPos.above(), (Direction.Axis)Direction.Axis.X, (int)4, (Direction.Axis)Direction.Axis.Z, (int)4, blockPos -> world.getBlockState(blockPos).isSolid() && !world.getBlockState(blockPos.above()).isSolid() && !world.getBlockState(blockPos.above()).liquid() && !world.getBlockState(blockPos.above(2)).isSolid() && !world.getBlockState(blockPos.above(2)).liquid());
        return rect.axis1Size >= 4 && rect.axis2Size >= 4 ? rect.minCorner : null;
    }

    @Override
    public Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle arg, Entity entity, Direction.Axis portalAxis) {
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        double xSize = (float)arg.axis1Size - entityDimensions.width();
        double zSize = (float)arg.axis2Size - entityDimensions.width();
        double deltaX = Mth.inverseLerp((double)entity.getX(), (double)arg.minCorner.getX(), (double)((double)arg.minCorner.getX() + xSize));
        double deltaY = Mth.inverseLerp((double)entity.getY(), (double)((double)arg.minCorner.getY() - 1.0), (double)((double)arg.minCorner.getY() + 1.0));
        double deltaZ = Mth.inverseLerp((double)entity.getZ(), (double)arg.minCorner.getZ(), (double)((double)arg.minCorner.getZ() + zSize));
        return new Vec3(deltaX, deltaY, deltaZ);
    }

    @Override
    public DimensionTransition getTPTargetInPortal(ServerLevel world, BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 prevOffset, Entity entity, PortalLink link) {
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        float xSize = (float)portalRect.axis1Size - entityDimensions.width();
        float zSize = (float)portalRect.axis2Size - entityDimensions.width();
        double x = Mth.lerp((double)prevOffset.x, (double)portalRect.minCorner.getX(), (double)((float)portalRect.minCorner.getX() + xSize));
        double z = Mth.lerp((double)prevOffset.z, (double)portalRect.minCorner.getZ(), (double)((float)portalRect.minCorner.getZ() + zSize));
        DimensionTransition.PostDimensionTransition post = DimensionTransition.PLAY_PORTAL_SOUND.then(entityx -> {
            entityx.placePortalTicket(portalRect.minCorner);
            link.executePostTPEvent(entityx);
        });
        return new DimensionTransition(world, new Vec3(x, (double)portalRect.minCorner.getY() + 1.0, z), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), post);
    }
}

