/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.xstarlotte.snsnf.Config;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.block.custom.chest.WaffleChestRenderer;
import net.xstarlotte.snsnf.block.entity.SNSBE;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.entity.client.cake.AngelCakeFishRenderer;
import net.xstarlotte.snsnf.entity.client.cake.CakeRabbitRenderer;
import net.xstarlotte.snsnf.entity.client.cake.CheesecakeMouseRenderer;
import net.xstarlotte.snsnf.entity.client.cake.EclairDogRenderer;
import net.xstarlotte.snsnf.entity.client.cake.GingerbreadManRenderer;
import net.xstarlotte.snsnf.entity.client.cake.PretzelflyRenderer;
import net.xstarlotte.snsnf.entity.client.cake.SquirrollRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.BlackboarryRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.BlueboarryRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.BunanaRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.DuckanaRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.FruitElfRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.FruitPugRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.HappleRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.JamsterRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.RaspboarryRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.SnappleRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.StrawboarryRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneCatRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneCerberusRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneCrookRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneFlyRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneTigerRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneZebraRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CinnabunRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CinnadileRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CinnaffinRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CinnamantaRayRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CinnamothRenderer;
import net.xstarlotte.snsnf.entity.client.herb.HumbugRenderer;
import net.xstarlotte.snsnf.entity.client.herb.HumbullRenderer;
import net.xstarlotte.snsnf.entity.client.herb.HumflyRenderer;
import net.xstarlotte.snsnf.entity.client.herb.HumpugRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintImperialRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintMinkRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintmunkRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintowRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MynxRenderer;
import net.xstarlotte.snsnf.entity.client.herb.PeppermintChurlRenderer;
import net.xstarlotte.snsnf.entity.client.herb.PeppermintTwirlRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.IceCreamCowRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.IceCreamFishRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.ParfaitPixieRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.WaferWhaleRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.WaferWitchRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.WaffleFishMiniRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.WaffleFishRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.BonbonbiniRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.CandyflossLionRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.CandyflossSheepRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChoccoonRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolateChickenRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolatePenguinRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolatePigeonRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolateReindeerRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ColaBottlenoseDolphinRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.GummyBearRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.GummyFishRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.JellyBabyRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.LaceSnakeRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.LaceSpiderRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.MarshmallowSheepRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.RainbowStripJellyfishRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.RainbowStripPegasusRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.RainbowStripPhoenixRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.RainbowStripUnicornRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.SugarWrappedMummyRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.SugargliderRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.TreatToadRenderer;
import net.xstarlotte.snsnf.fluid.SNSFluid;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.SNSTab;
import net.xstarlotte.snsnf.menu.SNSMenuTypes;
import net.xstarlotte.snsnf.mob_effects.SNSEffect;
import net.xstarlotte.snsnf.network.SNSNFModVariables;
import net.xstarlotte.snsnf.particles.SNSParticles;
import net.xstarlotte.snsnf.portal.SNSPortalRegistrar;
import net.xstarlotte.snsnf.screen.CandyCaneFurnaceScreen;
import net.xstarlotte.snsnf.screen.ChocolateFurnaceScreen;
import net.xstarlotte.snsnf.screen.CrystalisedSugarFurnaceScreen;
import net.xstarlotte.snsnf.screen.WaffleChestScreen;
import net.xstarlotte.snsnf.worldgen.tree.SNSFoliagePlacerTypes;
import net.xstarlotte.snsnf.worldgen.tree.SNSTreeGrower;
import net.xstarlotte.snsnf.worldgen.tree.SNSTrunkPlacerTypes;
import org.slf4j.Logger;

@Mod(value="snsnf")
public class SNSNF {
    public static final String MOD_ID = "snsnf";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public SNSNF(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerNetworking);
        SNSFluid.FLUID_TYPES.register(modEventBus);
        SNSFluid.FLUIDS.register(modEventBus);
        SNSFluid.BLOCKS.register(modEventBus);
        SNSBlock.register(modEventBus);
        SNSBE.register(modEventBus);
        SNSEntity.register(modEventBus);
        SNSItem.register(modEventBus);
        SNSEffect.register(modEventBus);
        SNSParticles.PARTICLE_TYPES.register(modEventBus);
        SNSTab.register(modEventBus);
        SNSPortalRegistrar.register(modEventBus);
        SNSMenuTypes.MENU_TYPES.register(modEventBus);
        SNSNFModVariables.ATTACHMENT_TYPES.register(modEventBus);
        SNSFoliagePlacerTypes.FOLIAGE_PLACER_TYPES.register(modEventBus);
        SNSTrunkPlacerTypes.TRUNK_PLACER_TYPES.register(modEventBus);
        SNSTreeGrower.registerGrowListener();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.APPLE_FRUIT_ROLL_BUSH.getId(), SNSBlock.POTTED_APPLE_FRUIT_ROLL_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.BANANA_FRUIT_ROLL_BUSH.getId(), SNSBlock.POTTED_BANANA_FRUIT_ROLL_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.BLACKBERRY_ROLL_BUSH.getId(), SNSBlock.POTTED_BLACKBERRY_ROLL_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.BLUEBERRY_ROLL_BUSH.getId(), SNSBlock.POTTED_BLUEBERRY_ROLL_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.RASPBERRY_ROLL_BUSH.getId(), SNSBlock.POTTED_RASPBERRY_ROLL_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.STRAWBERRY_ROLL_BUSH.getId(), SNSBlock.POTTED_STRAWBERRY_ROLL_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_BUSH.getId(), SNSBlock.POTTED_CANDYFLOSS_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_COSMOS.getId(), SNSBlock.POTTED_CANDYFLOSS_COSMOS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_COSMOS_2.getId(), SNSBlock.POTTED_CANDYFLOSS_COSMOS_2);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_COSMOS_3.getId(), SNSBlock.POTTED_CANDYFLOSS_COSMOS_3);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_COSMOS_4.getId(), SNSBlock.POTTED_CANDYFLOSS_COSMOS_4);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_COSMOS_5.getId(), SNSBlock.POTTED_CANDYFLOSS_COSMOS_5);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_GRASS.getId(), SNSBlock.POTTED_CANDYFLOSS_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_GRASS_SHORT.getId(), SNSBlock.POTTED_CANDYFLOSS_GRASS_SHORT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDYFLOSS_SAPLING.getId(), SNSBlock.POTTED_CANDYFLOSS_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_BUSH.getId(), SNSBlock.POTTED_CANDY_CANE_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_CARNATION.getId(), SNSBlock.POTTED_CANDY_CANE_CARNATION);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER_2.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER_2);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER_3.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER_3);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER_4.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER_4);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_GRASS.getId(), SNSBlock.POTTED_CANDY_CANE_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_GRASS_LONG.getId(), SNSBlock.POTTED_CANDY_CANE_GRASS_LONG);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_SAPLING.getId(), SNSBlock.POTTED_CANDY_CANE_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CHOCOLATE_GRASS.getId(), SNSBlock.POTTED_CHOCOLATE_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CHOCOLATE_SAPLING.getId(), SNSBlock.POTTED_CHOCOLATE_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CINNAMON_GRASS.getId(), SNSBlock.POTTED_CINNAMON_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CINNAMON_GRASS_LONG.getId(), SNSBlock.POTTED_CINNAMON_GRASS_LONG);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CINNAMON_FLOWER.getId(), SNSBlock.POTTED_CINNAMON_FLOWER);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CINNAMON_FLOWER_2.getId(), SNSBlock.POTTED_CINNAMON_FLOWER_2);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CINNAMON_SAPLING.getId(), SNSBlock.POTTED_CINNAMON_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.MINT_BUSH.getId(), SNSBlock.POTTED_MINT_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.MINT_GRASS.getId(), SNSBlock.POTTED_MINT_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.MINT_GRASS_LONG.getId(), SNSBlock.POTTED_MINT_GRASS_LONG);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.MINT_FLOWER.getId(), SNSBlock.POTTED_MINT_FLOWER);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.MINT_FLOWER_2.getId(), SNSBlock.POTTED_MINT_FLOWER_2);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.MINT_FLOWER_3.getId(), SNSBlock.POTTED_MINT_FLOWER_3);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.RAINBOW_STRIP_GRASS.getId(), SNSBlock.POTTED_RAINBOW_STRIP_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.RAINBOW_STRIP_GRASS_LONG.getId(), SNSBlock.POTTED_RAINBOW_STRIP_GRASS_LONG);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.RAINBOW_STRIP_FLOWER.getId(), SNSBlock.POTTED_RAINBOW_STRIP_FLOWER);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.RAINBOW_STRIP_FLOWER_2.getId(), SNSBlock.POTTED_RAINBOW_STRIP_FLOWER_2);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.RAINBOW_STRIP_SAPLING.getId(), SNSBlock.POTTED_RAINBOW_STRIP_SAPLING);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance inst = entity.getEffect(SNSEffect.HERB_EFFECT);
        if (inst != null && inst.getAmplifier() >= 1) {
            float original = event.getAmount();
            event.setAmount(original * 0.5f);
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                double x = entity.getX();
                double y = entity.getY() + (double)entity.getBbHeight() * 0.6;
                double z = entity.getZ();
                int n = level2.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, y, z, 6, 0.3, 0.4, 0.3, 0.0);
            }
        }
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    @EventBusSubscriber(modid="snsnf", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers e) {
            e.registerBlockEntityRenderer(SNSBE.WAFFLE_CHEST_BE.get(), WaffleChestRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterScreens(RegisterMenuScreensEvent e) {
            e.register(SNSMenuTypes.CANDY_CANE_FURNACE.get(), CandyCaneFurnaceScreen::new);
            e.register(SNSMenuTypes.CHOCOLATE_FURNACE.get(), ChocolateFurnaceScreen::new);
            e.register(SNSMenuTypes.CRYSTALISED_SUGAR_FURNACE.get(), CrystalisedSugarFurnaceScreen::new);
            e.register(SNSMenuTypes.WAFFLE_CHEST.get(), WaffleChestScreen::new);
            e.register(SNSMenuTypes.WAFFLE_CHEST_BIG.get(), WaffleChestScreen::new);
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)SNSParticles.CANDYFLOSS_FLAME.get(), FlameParticle.Provider::new);
            event.registerSpriteSet((ParticleType)SNSParticles.CHOCOLATE_FLAME.get(), FlameParticle.Provider::new);
            event.registerSpriteSet((ParticleType)SNSParticles.MINT_FLAME.get(), FlameParticle.Provider::new);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                LOGGER.info("HELLO FROM CLIENT SETUP");
                LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
                EntityRenderers.register(SNSEntity.BLACKBOARRY.get(), BlackboarryRenderer::new);
                EntityRenderers.register(SNSEntity.BLUEBOARRY.get(), BlueboarryRenderer::new);
                EntityRenderers.register(SNSEntity.RASPBOARRY.get(), RaspboarryRenderer::new);
                EntityRenderers.register(SNSEntity.STRAWBOARRY.get(), StrawboarryRenderer::new);
                EntityRenderers.register(SNSEntity.JAMSTER.get(), JamsterRenderer::new);
                EntityRenderers.register(SNSEntity.ANGEL_CAKE_FISH.get(), AngelCakeFishRenderer::new);
                EntityRenderers.register(SNSEntity.CAKE_RABBIT.get(), CakeRabbitRenderer::new);
                EntityRenderers.register(SNSEntity.CHEESECAKE_MOUSE.get(), CheesecakeMouseRenderer::new);
                EntityRenderers.register(SNSEntity.ECLAIR_DOG.get(), EclairDogRenderer::new);
                EntityRenderers.register(SNSEntity.PRETZELFLY.get(), PretzelflyRenderer::new);
                EntityRenderers.register(SNSEntity.SQUIRROLL.get(), SquirrollRenderer::new);
                EntityRenderers.register(SNSEntity.BUNANA.get(), BunanaRenderer::new);
                EntityRenderers.register(SNSEntity.DUCKANA.get(), DuckanaRenderer::new);
                EntityRenderers.register(SNSEntity.FRUIT_ELF.get(), FruitElfRenderer::new);
                EntityRenderers.register(SNSEntity.FRUIT_PUG.get(), FruitPugRenderer::new);
                EntityRenderers.register(SNSEntity.HAPPLE.get(), HappleRenderer::new);
                EntityRenderers.register(SNSEntity.SNAPPLE.get(), SnappleRenderer::new);
                EntityRenderers.register(SNSEntity.CANDY_CANE_CAT.get(), CandyCaneCatRenderer::new);
                EntityRenderers.register(SNSEntity.CANDY_CANE_CERBERUS.get(), CandyCaneCerberusRenderer::new);
                EntityRenderers.register(SNSEntity.CANDY_CANE_CROOK.get(), CandyCaneCrookRenderer::new);
                EntityRenderers.register(SNSEntity.CANDY_CANE_FLY.get(), CandyCaneFlyRenderer::new);
                EntityRenderers.register(SNSEntity.CANDY_CANE_TIGER.get(), CandyCaneTigerRenderer::new);
                EntityRenderers.register(SNSEntity.CANDY_CANE_ZEBRA.get(), CandyCaneZebraRenderer::new);
                EntityRenderers.register(SNSEntity.CINNABUN.get(), CinnabunRenderer::new);
                EntityRenderers.register(SNSEntity.CINNADILE.get(), CinnadileRenderer::new);
                EntityRenderers.register(SNSEntity.CINNAFFIN.get(), CinnaffinRenderer::new);
                EntityRenderers.register(SNSEntity.CINNAMANTA_RAY.get(), CinnamantaRayRenderer::new);
                EntityRenderers.register(SNSEntity.CINNAMOTH.get(), CinnamothRenderer::new);
                EntityRenderers.register(SNSEntity.GINGERBREAD_MAN.get(), GingerbreadManRenderer::new);
                EntityRenderers.register(SNSEntity.HUMBUG.get(), HumbugRenderer::new);
                EntityRenderers.register(SNSEntity.HUMBULL.get(), HumbullRenderer::new);
                EntityRenderers.register(SNSEntity.HUMFLY.get(), HumflyRenderer::new);
                EntityRenderers.register(SNSEntity.HUMPUG.get(), HumpugRenderer::new);
                EntityRenderers.register(SNSEntity.MINT_MINK.get(), MintMinkRenderer::new);
                EntityRenderers.register(SNSEntity.MINTOW.get(), MintowRenderer::new);
                EntityRenderers.register(SNSEntity.MINTMUNK.get(), MintmunkRenderer::new);
                EntityRenderers.register(SNSEntity.MINT_IMPERIAL.get(), MintImperialRenderer::new);
                EntityRenderers.register(SNSEntity.MARSHMALLOW_SHEEP.get(), MarshmallowSheepRenderer::new);
                EntityRenderers.register(SNSEntity.MYNX.get(), MynxRenderer::new);
                EntityRenderers.register(SNSEntity.PEPPERMINT_CHURL.get(), PeppermintChurlRenderer::new);
                EntityRenderers.register(SNSEntity.PEPPERMINT_TWIRL.get(), PeppermintTwirlRenderer::new);
                EntityRenderers.register(SNSEntity.ICE_CREAM_COW.get(), IceCreamCowRenderer::new);
                EntityRenderers.register(SNSEntity.ICE_CREAM_FISH.get(), IceCreamFishRenderer::new);
                EntityRenderers.register(SNSEntity.PARFAIT_PIXIE.get(), ParfaitPixieRenderer::new);
                EntityRenderers.register(SNSEntity.WAFER_WHALE.get(), WaferWhaleRenderer::new);
                EntityRenderers.register(SNSEntity.WAFER_WITCH.get(), WaferWitchRenderer::new);
                EntityRenderers.register(SNSEntity.WAFFLE_FISH.get(), WaffleFishRenderer::new);
                EntityRenderers.register(SNSEntity.WAFFLE_FISH_MINI.get(), WaffleFishMiniRenderer::new);
                EntityRenderers.register(SNSEntity.BONBONBINI.get(), BonbonbiniRenderer::new);
                EntityRenderers.register(SNSEntity.CANDYFLOSS_LION.get(), CandyflossLionRenderer::new);
                EntityRenderers.register(SNSEntity.CANDYFLOSS_SHEEP.get(), CandyflossSheepRenderer::new);
                EntityRenderers.register(SNSEntity.CHOCCOON.get(), ChoccoonRenderer::new);
                EntityRenderers.register(SNSEntity.CHOCOLATE_CHICKEN.get(), ChocolateChickenRenderer::new);
                EntityRenderers.register(SNSEntity.CHOCOLATE_PENGUIN.get(), ChocolatePenguinRenderer::new);
                EntityRenderers.register(SNSEntity.CHOCOLATE_PIGEON.get(), ChocolatePigeonRenderer::new);
                EntityRenderers.register(SNSEntity.CHOCOLATE_REINDEER.get(), ChocolateReindeerRenderer::new);
                EntityRenderers.register(SNSEntity.COLA_BOTTLENOSE_DOLPHIN.get(), ColaBottlenoseDolphinRenderer::new);
                EntityRenderers.register(SNSEntity.GUMMY_BEAR.get(), GummyBearRenderer::new);
                EntityRenderers.register(SNSEntity.GUMMY_FISH.get(), GummyFishRenderer::new);
                EntityRenderers.register(SNSEntity.JELLY_BABY.get(), JellyBabyRenderer::new);
                EntityRenderers.register(SNSEntity.LACE_SNAKE.get(), LaceSnakeRenderer::new);
                EntityRenderers.register(SNSEntity.LACE_SPIDER.get(), LaceSpiderRenderer::new);
                EntityRenderers.register(SNSEntity.RAINBOW_STRIP_JELLYFISH.get(), RainbowStripJellyfishRenderer::new);
                EntityRenderers.register(SNSEntity.RAINBOW_STRIP_PEGASUS.get(), RainbowStripPegasusRenderer::new);
                EntityRenderers.register(SNSEntity.RAINBOW_STRIP_PHOENIX.get(), RainbowStripPhoenixRenderer::new);
                EntityRenderers.register(SNSEntity.RAINBOW_STRIP_UNICORN.get(), RainbowStripUnicornRenderer::new);
                EntityRenderers.register(SNSEntity.SUGARGLIDER.get(), SugargliderRenderer::new);
                EntityRenderers.register(SNSEntity.SUGAR_WRAPPED_MUMMY.get(), SugarWrappedMummyRenderer::new);
                EntityRenderers.register(SNSEntity.TREAT_TOAD.get(), TreatToadRenderer::new);
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CANDY_CANE_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CANDY_CANE_WALL_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CHOCOLATE_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CHOCOLATE_WALL_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CINNAMON_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CINNAMON_WALL_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CRYSTALISED_SUGAR_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.CRYSTALISED_SUGAR_WALL_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.RAINBOW_STRIP_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.RAINBOW_STRIP_WALL_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.WAFFLE_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SNSBlock.WAFFLE_WALL_TORCH.get()), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SNSFluid.CHOCOLATE_SOURCE.get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SNSFluid.CHOCOLATE_FLOWING.get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SNSFluid.CREAM_SOURCE.get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SNSFluid.CREAM_FLOWING.get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SNSFluid.MINT_WATER_SOURCE.get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SNSFluid.MINT_WATER_FLOWING.get()), (RenderType)RenderType.translucent());
            });
        }
    }
}

