/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.block.custom.furnace;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.xstarlotte.snsnf.block.entity.SNSBE;
import net.xstarlotte.snsnf.block.entity.custom.furnace.CrystalisedSugarFurnaceBE;
import net.xstarlotte.snsnf.particles.SNSParticles;

public class CrystalisedSugarFurnaceBlock
extends FurnaceBlock {
    public CrystalisedSugarFurnaceBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)be;
            player.openMenu(provider);
            player.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
        return InteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystalisedSugarFurnaceBE(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (type == SNSBE.CRYSTALISED_SUGAR_FURNACE_BE.get() ? (lvl, p, st, be) -> CrystalisedSugarFurnaceBE.serverTick(lvl, p, st, (CrystalisedSugarFurnaceBE)be) : null);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + rand.nextDouble() * 6.0 / 16.0;
        double z = (double)pos.getZ() + 0.5;
        Direction facing = (Direction)state.getValue((Property)FACING);
        double front = 0.52;
        double side = rand.nextDouble() * 0.6 - 0.3;
        double px = x;
        double pz = z;
        switch (facing) {
            case WEST: {
                px = x - front;
                pz = z + side;
                break;
            }
            case EAST: {
                px = x + front;
                pz = z + side;
                break;
            }
            case NORTH: {
                px = x + side;
                pz = z - front;
                break;
            }
            case SOUTH: {
                px = x + side;
                pz = z + front;
            }
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, px, y, pz, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)SNSParticles.CANDYFLOSS_FLAME.get(), px, y, pz, 0.0, 0.0, 0.0);
    }
}

