/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.item.SNSItem;

public class SNSBlockLootTableProvider
extends BlockLootSubProvider {
    private static final float[] LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f};
    private final Holder<Enchantment> fortuneHolder;
    private final Holder<Enchantment> silkTouchHolder;

    public SNSBlockLootTableProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        HolderLookup.RegistryLookup ench = provider.lookupOrThrow(Registries.ENCHANTMENT);
        this.fortuneHolder = ench.getOrThrow(Enchantments.FORTUNE);
        this.silkTouchHolder = ench.getOrThrow(Enchantments.SILK_TOUCH);
    }

    private Block b(String path) {
        return (Block)SNSBlock.BLOCKS.getEntries().stream().filter(def -> def.getId().getPath().equals(path)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown block id: " + path)).get();
    }

    private boolean exists(String path) {
        return SNSBlock.BLOCKS.getEntries().stream().anyMatch(def -> def.getId().getPath().equals(path));
    }

    private void dropSelf(String path) {
        this.dropSelf(this.b(path));
    }

    private void addDoor(String path) {
        this.add(this.b(path), blk -> this.createDoorTable(this.b(path)));
    }

    private void addSlab(String path) {
        this.add(this.b(path), blk -> this.createSlabItemTable(this.b(path)));
    }

    private void familyLoot(String basePath, String familyId) {
        if (this.exists(basePath)) {
            this.dropSelf(basePath);
        }
        for (String suffix : new String[]{"_button", "_fence", "_fence_gate", "_pressure_plate", "_stairs", "_trapdoor", "_wall"}) {
            String id = familyId + suffix;
            if (!this.exists(id)) continue;
            this.dropSelf(id);
        }
        if (this.exists(familyId + "_door")) {
            this.addDoor(familyId + "_door");
        }
        if (this.exists(familyId + "_slab")) {
            this.addSlab(familyId + "_slab");
        }
    }

    protected void generate() {
        this.dropSelf("bourbon_carpet");
        this.dropSelf("custard_cream_carpet");
        this.dropSelf("peppermint_swirl_carpet");
        this.dropSelf("blackberry_lantern");
        this.dropSelf("blueberry_lantern");
        this.dropSelf("raspberry_lantern");
        this.dropSelf("strawberry_lantern");
        this.dropSelf("candyfloss_lantern");
        this.dropSelf("candy_cane_lantern");
        this.dropSelf("ice_cream_lantern");
        this.dropSelf("blackberry_lollipop_lantern");
        this.dropSelf("blueberry_lollipop_lantern");
        this.dropSelf("raspberry_lollipop_lantern");
        this.dropSelf("strawberry_lollipop_lantern");
        this.dropSelf("candy_cane_ladder");
        this.dropSelf("chocolate_ladder");
        this.dropSelf("cinnamon_ladder");
        this.dropSelf("rainbow_strip_ladder");
        this.dropSelf("waffle_ladder");
        this.dropSelf("candy_cane_bed");
        this.dropSelf("candy_cane_furnace");
        this.dropSelf("chocolate_furnace");
        this.dropSelf("crystalised_sugar_furnace");
        this.add(this.b("crystalised_sugar_glass"), blk -> this.createSilkTouchOnlyTable(this.b("crystalised_sugar_glass")));
        this.familyLoot("candyfloss_block", "candyfloss");
        this.familyLoot("candyfloss_blue_raspberry_block", "candyfloss_blue_raspberry");
        this.familyLoot("candyfloss_lemon_block", "candyfloss_lemon");
        this.familyLoot("candyfloss_strawberry_block", "candyfloss_strawberry");
        this.familyLoot("candyfloss_vanilla_block", "candyfloss_vanilla");
        this.familyLoot("gummy_apple_block", "gummy_apple");
        this.familyLoot("gummy_banana_block", "gummy_banana");
        this.familyLoot("gummy_blackberry_block", "gummy_blackberry");
        this.familyLoot("gummy_blueberry_block", "gummy_blueberry");
        this.familyLoot("gummy_raspberry_block", "gummy_raspberry");
        this.familyLoot("gummy_strawberry_block", "gummy_strawberry");
        this.dropSelf("chocolate_bed");
        this.familyLoot("chocolate_block", "chocolate");
        this.familyLoot("chocolate_bricks", "chocolate_brick");
        this.familyLoot("chocolate_dark_block", "chocolate_dark");
        this.familyLoot("chocolate_dark_bricks", "chocolate_dark_brick");
        this.familyLoot("chocolate_white_block", "chocolate_white");
        this.familyLoot("chocolate_white_bricks", "chocolate_white_brick");
        this.familyLoot("chocolate_planks", "chocolate_plank");
        this.familyLoot("peppermint_swirl_stone", "peppermint_swirl_stone");
        this.familyLoot("peppermint_swirl_brick", "peppermint_swirl_brick");
        this.add(this.b("peppermint_swirl_stone_coal_ore"), blk -> this.createMultipleOreDrops(this.b("peppermint_swirl_stone_coal_ore"), Items.COAL, 2.0f, 5.0f));
        this.familyLoot("rhubarb_custard_stone", "rhubarb_custard_stone");
        this.familyLoot("rhubarb_custard_brick", "rhubarb_custard_brick");
        this.familyLoot("strawberry_cream_stone", "strawberry_cream_stone");
        this.familyLoot("strawberry_cream_brick", "strawberry_cream_brick");
        this.familyLoot("waffle_block", "waffle");
        this.familyLoot("white_chocolate_coated_waffle_block", "white_chocolate_coated_waffle");
        this.familyLoot("chocolate_coated_waffle_block", "chocolate_coated_waffle");
        this.familyLoot("dark_chocolate_coated_waffle_block", "dark_chocolate_coated_waffle");
        this.familyLoot("strawberry_chocolate_coated_waffle_block", "strawberry_chocolate_coated_waffle");
        this.familyLoot("waffle_bricks", "waffle_brick");
        this.dropSelf("waffle_bed");
        this.dropSelf("waffle_chest");
        this.familyLoot("pretzel_block", "pretzel");
        this.familyLoot("humbug_brick", "humbug_brick");
        this.familyLoot("mint_block", "mint");
        this.familyLoot("mint_brick", "mint_brick");
        this.familyLoot("licorice_planks", "licorice_plank");
        this.familyLoot("cinnamon_planks", "cinnamon_plank");
        this.familyLoot("candy_cane_planks", "candy_cane_plank");
        this.familyLoot("crystalised_sugar_planks", "crystalised_sugar_plank");
        this.familyLoot("rainbow_strip_planks", "rainbow_strip_plank");
        for (String id : new String[]{"candy_cane_log", "stripped_candy_cane_log", "candy_cane_wood", "stripped_candy_cane_wood", "chocolate_log", "stripped_chocolate_log", "chocolate_wood", "stripped_chocolate_wood", "cinnamon_log", "stripped_cinnamon_log", "cinnamon_wood", "stripped_cinnamon_wood", "licorice_log", "stripped_licorice_log", "licorice_wood", "stripped_licorice_wood", "crystalised_sugar_log", "stripped_crystalised_sugar_log", "crystalised_sugar_wood", "stripped_crystalised_sugar_wood", "rainbow_strip_log", "stripped_rainbow_strip_log", "rainbow_strip_wood", "stripped_rainbow_strip_wood"}) {
            this.dropSelf(id);
        }
        for (String id : new String[]{"apple_fruit_roll_bush", "banana_fruit_roll_bush", "blackberry_roll_bush", "blueberry_roll_bush", "raspberry_roll_bush", "strawberry_roll_bush", "candyfloss_bush", "candyfloss_cosmos", "candyfloss_cosmos_2", "candyfloss_cosmos_3", "candyfloss_cosmos_4", "candyfloss_cosmos_5", "candyfloss_grass", "candyfloss_grass_short", "candy_cane_bush", "candy_cane_carnation", "candy_cane_flower", "candy_cane_flower_2", "candy_cane_flower_3", "candy_cane_flower_4", "candy_cane_grass", "candy_cane_grass_long", "cinnamon_flower", "cinnamon_flower_2", "cinnamon_grass", "cinnamon_grass_long", "chocolate_grass", "mint_bush", "mint_flower", "mint_flower_2", "mint_flower_3", "mint_grass", "mint_grass_long", "rainbow_strip_flower", "rainbow_strip_flower_2", "rainbow_strip_grass", "rainbow_strip_grass_long"}) {
            this.dropSelf(id);
        }
        this.dropSelf("candyfloss_sapling");
        this.addLeavesWithStick("candyfloss_leaves", "candyfloss_sapling", (ItemLike)SNSItem.CRYSTALISED_SUGAR_STICK.get());
        this.addLeavesWithStick("candyfloss_blue_raspberry_leaves", "candyfloss_sapling", (ItemLike)SNSItem.CRYSTALISED_SUGAR_STICK.get());
        this.addLeavesWithStick("candyfloss_lemon_leaves", "candyfloss_sapling", (ItemLike)SNSItem.CRYSTALISED_SUGAR_STICK.get());
        this.addLeavesWithStick("candyfloss_strawberry_leaves", "candyfloss_sapling", (ItemLike)SNSItem.CRYSTALISED_SUGAR_STICK.get());
        this.addLeavesWithStick("candyfloss_vanilla_leaves", "candyfloss_sapling", (ItemLike)SNSItem.CRYSTALISED_SUGAR_STICK.get());
        this.dropSelf("candy_cane_sapling");
        this.addLeavesWithStick("candy_cane_leaves", "candy_cane_sapling", (ItemLike)SNSItem.CANDY_CANE.get());
        this.dropSelf("chocolate_sapling");
        this.addLeavesWithStick("chocolate_leaves", "chocolate_sapling", (ItemLike)SNSItem.CHOCOLATE_STICK.get());
        this.dropSelf("cinnamon_sapling");
        this.addLeavesWithStick("cinnamon_leaves", "cinnamon_sapling", (ItemLike)SNSItem.CINNAMON_STICK.get());
        this.dropSelf("rainbow_strip_sapling");
        this.addLeavesWithStick("rainbow_strip_leaves", "rainbow_strip_sapling", (ItemLike)SNSItem.RAINBOW_STRIP_STICK.get());
        this.dropOther(this.b("candy_cane_sugar_cane"), (ItemLike)SNSItem.CANDY_CANE_SUGAR_CANE);
        for (String id : new String[]{"blackberry_sorbet_sand", "blueberry_sorbet_sand", "lemon_sorbet_sand", "orange_sorbet_sand", "pineapple_sorbet_sand", "raspberry_sorbet_sand", "strawberry_sorbet_sand", "sprinkles_sand_orange", "sprinkles_sand_pink", "sugar_dirt_block", "cinnamon_dirt_block", "mint_dirt_block"}) {
            this.dropSelf(id);
        }
        this.silkTouchPair("apple_fruit_roll_grass_block", "sugar_dirt_block");
        this.silkTouchPair("banana_fruit_roll_grass_block", "sugar_dirt_block");
        this.silkTouchPair("blackberry_roll_grass_block", "sugar_dirt_block");
        this.silkTouchPair("blueberry_roll_grass_block", "sugar_dirt_block");
        this.silkTouchPair("raspberry_roll_grass_block", "sugar_dirt_block");
        this.silkTouchPair("strawberry_roll_grass_block", "sugar_dirt_block");
        this.silkTouchPair("candy_cane_grass_block", "sugar_dirt_block");
        this.silkTouchPair("cinnamon_grass_block", "cinnamon_dirt_block");
        this.silkTouchPair("mint_grass_block", "mint_dirt_block");
        this.silkTouchPair("rainbow_strip_grass_block", "sugar_dirt_block");
        for (String id : new String[]{"candy_cane_cat_teddy", "cinnadile_teddy", "mint_mink_teddy", "mynx_teddy"}) {
            this.dropSelf(id);
        }
        this.dropSelf("cocoa_dirt_block");
        this.dropSelf("cocoa_dark_dirt_block");
        this.dropSelf("cocoa_white_dirt_block");
        this.dropSelf("candy_cane_torch");
        this.dropSelf("chocolate_torch");
        this.dropSelf("cinnamon_torch");
        this.dropSelf("crystalised_sugar_torch");
        this.dropSelf("rainbow_strip_torch");
        this.dropSelf("waffle_torch");
        this.dropOther(this.b("candy_cane_wall_torch"), (ItemLike)this.b("candy_cane_torch"));
        this.dropOther(this.b("chocolate_wall_torch"), (ItemLike)this.b("chocolate_torch"));
        this.dropOther(this.b("cinnamon_wall_torch"), (ItemLike)this.b("cinnamon_torch"));
        this.dropOther(this.b("crystalised_sugar_wall_torch"), (ItemLike)this.b("crystalised_sugar_torch"));
        this.dropOther(this.b("rainbow_strip_wall_torch"), (ItemLike)this.b("rainbow_strip_torch"));
        this.dropOther(this.b("waffle_wall_torch"), (ItemLike)this.b("waffle_torch"));
        this.pot("potted_apple_fruit_roll_bush", "apple_fruit_roll_bush");
        this.pot("potted_banana_fruit_roll_bush", "banana_fruit_roll_bush");
        this.pot("potted_blackberry_roll_bush", "blackberry_roll_bush");
        this.pot("potted_blueberry_roll_bush", "blueberry_roll_bush");
        this.pot("potted_raspberry_roll_bush", "raspberry_roll_bush");
        this.pot("potted_strawberry_roll_bush", "strawberry_roll_bush");
        this.pot("potted_candyfloss_bush", "candyfloss_bush");
        this.pot("potted_candyfloss_grass", "candyfloss_grass");
        this.pot("potted_candyfloss_grass_short", "candyfloss_grass_short");
        this.pot("potted_candyfloss_cosmos", "candyfloss_cosmos");
        this.pot("potted_candyfloss_cosmos_2", "candyfloss_cosmos_2");
        this.pot("potted_candyfloss_cosmos_3", "candyfloss_cosmos_3");
        this.pot("potted_candyfloss_cosmos_4", "candyfloss_cosmos_4");
        this.pot("potted_candyfloss_cosmos_5", "candyfloss_cosmos_5");
        this.pot("potted_candyfloss_sapling", "candyfloss_sapling");
        this.pot("potted_candy_cane_bush", "candy_cane_bush");
        this.pot("potted_candy_cane_carnation", "candy_cane_carnation");
        this.pot("potted_candy_cane_flower", "candy_cane_flower");
        this.pot("potted_candy_cane_flower_2", "candy_cane_flower_2");
        this.pot("potted_candy_cane_flower_3", "candy_cane_flower_3");
        this.pot("potted_candy_cane_flower_4", "candy_cane_flower_4");
        this.pot("potted_candy_cane_grass", "candy_cane_grass");
        this.pot("potted_candy_cane_grass_long", "candy_cane_grass_long");
        this.pot("potted_candy_cane_sapling", "candy_cane_sapling");
        this.pot("potted_chocolate_grass", "chocolate_grass");
        this.pot("potted_chocolate_sapling", "chocolate_sapling");
        this.pot("potted_cinnamon_flower", "cinnamon_flower");
        this.pot("potted_cinnamon_flower_2", "cinnamon_flower_2");
        this.pot("potted_cinnamon_grass", "cinnamon_grass");
        this.pot("potted_cinnamon_grass_long", "cinnamon_grass_long");
        this.pot("potted_cinnamon_sapling", "cinnamon_sapling");
        this.pot("potted_mint_flower", "mint_flower");
        this.pot("potted_mint_flower_2", "mint_flower_2");
        this.pot("potted_mint_flower_3", "mint_flower_3");
        this.pot("potted_mint_bush", "mint_bush");
        this.pot("potted_mint_grass", "mint_grass");
        this.pot("potted_mint_grass_long", "mint_grass_long");
        this.pot("potted_rainbow_strip_flower", "rainbow_strip_flower");
        this.pot("potted_rainbow_strip_flower_2", "rainbow_strip_flower_2");
        this.pot("potted_rainbow_strip_grass", "rainbow_strip_grass");
        this.pot("potted_rainbow_strip_grass_long", "rainbow_strip_grass_long");
        this.pot("potted_rainbow_strip_sapling", "rainbow_strip_sapling");
        this.dropSelf("carrot_cake_block");
        this.dropSelf("carrot_cake_button");
        this.dropSelf("carrot_cake_fence");
        this.dropSelf("carrot_cake_fence_gate");
        this.dropSelf("carrot_cake_pressure_plate");
        this.addSlab("carrot_cake_slab");
        this.dropSelf("carrot_cake_stairs");
        this.dropSelf("carrot_cake_wall");
        this.dropSelf("chocolate_cherry_cake_block");
        this.dropSelf("chocolate_cherry_cake_button");
        this.dropSelf("chocolate_cherry_cake_fence");
        this.dropSelf("chocolate_cherry_cake_fence_gate");
        this.dropSelf("chocolate_cherry_cake_pressure_plate");
        this.addSlab("chocolate_cherry_cake_slab");
        this.dropSelf("chocolate_cherry_cake_stairs");
        this.dropSelf("chocolate_cherry_cake_wall");
        this.dropSelf("chocolate_mint_cake_block");
        this.dropSelf("chocolate_mint_cake_button");
        this.dropSelf("chocolate_mint_cake_fence");
        this.dropSelf("chocolate_mint_cake_fence_gate");
        this.dropSelf("chocolate_mint_cake_pressure_plate");
        this.addSlab("chocolate_mint_cake_slab");
        this.dropSelf("chocolate_mint_cake_stairs");
        this.dropSelf("chocolate_mint_cake_wall");
        this.dropSelf("chocolate_orange_cake_block");
        this.dropSelf("chocolate_orange_cake_button");
        this.dropSelf("chocolate_orange_cake_fence");
        this.dropSelf("chocolate_orange_cake_fence_gate");
        this.dropSelf("chocolate_orange_cake_pressure_plate");
        this.addSlab("chocolate_orange_cake_slab");
        this.dropSelf("chocolate_orange_cake_stairs");
        this.dropSelf("chocolate_orange_cake_wall");
        this.dropSelf("lemon_curd_cake_block");
        this.dropSelf("lemon_curd_cake_button");
        this.dropSelf("lemon_curd_cake_fence");
        this.dropSelf("lemon_curd_cake_fence_gate");
        this.dropSelf("lemon_curd_cake_pressure_plate");
        this.addSlab("lemon_curd_cake_slab");
        this.dropSelf("lemon_curd_cake_stairs");
        this.dropSelf("lemon_curd_cake_wall");
        this.dropSelf("raspberry_cake_block");
        this.dropSelf("raspberry_cake_button");
        this.dropSelf("raspberry_cake_fence");
        this.dropSelf("raspberry_cake_fence_gate");
        this.dropSelf("raspberry_cake_pressure_plate");
        this.addSlab("raspberry_cake_slab");
        this.dropSelf("raspberry_cake_stairs");
        this.dropSelf("raspberry_cake_wall");
        this.dropSelf("strawberry_cake_block");
        this.dropSelf("strawberry_cake_button");
        this.dropSelf("strawberry_cake_fence");
        this.dropSelf("strawberry_cake_fence_gate");
        this.dropSelf("strawberry_cake_pressure_plate");
        this.addSlab("strawberry_cake_slab");
        this.dropSelf("strawberry_cake_stairs");
        this.dropSelf("strawberry_cake_wall");
        this.dropSelf("victoria_sponge_cake_block");
        this.dropSelf("victoria_sponge_cake_button");
        this.dropSelf("victoria_sponge_cake_fence");
        this.dropSelf("victoria_sponge_cake_fence_gate");
        this.dropSelf("victoria_sponge_cake_pressure_plate");
        this.addSlab("victoria_sponge_cake_slab");
        this.dropSelf("victoria_sponge_cake_stairs");
        this.dropSelf("victoria_sponge_cake_wall");
    }

    private void silkTouchPair(String silkTouchBlockId, String noSilkDropId) {
        this.add(this.b(silkTouchBlockId), blk -> this.createSilkTouchOnlyTable(this.b(silkTouchBlockId), (ItemLike)this.b(noSilkDropId)));
    }

    private void pot(String pottedId, String plantId) {
        this.add(this.b(pottedId), this.createPotFlowerItemTable((ItemLike)SNSBlock.byId(plantId)));
    }

    private void addLeavesWithStick(String leavesId, String saplingId, ItemLike customStick) {
        this.add(this.b(leavesId), tbl -> this.leavesWithCustomStick(this.b(leavesId), (ItemLike)this.b(saplingId), customStick, NORMAL_LEAVES_SAPLING_CHANCES));
    }

    protected LootTable.Builder createSilkTouchOnlyTable(Block silkTouchBlock) {
        return this.createSilkTouchDispatchTable(silkTouchBlock, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)silkTouchBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)silkTouchBlock)));
    }

    protected LootTable.Builder createSilkTouchOnlyTable(Block silkTouchBlock, ItemLike noSilkDrop) {
        return this.createSilkTouchDispatchTable(silkTouchBlock, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)silkTouchBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)noSilkDrop)));
    }

    protected LootTable.Builder createMultipleOreDrops(Block pBlock, Item item, float minDrops, float maxDrops) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder leavesWithCustomStick(Block leaves, ItemLike sapling, ItemLike customStick, float ... saplingChances) {
        LootItemCondition.Builder isShears = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
        LootItemCondition.Builder hasSilkTouch = BonusLevelTableCondition.bonusLevelFlatChance(this.silkTouchHolder, (float[])new float[]{0.0f, 1.0f, 1.0f, 1.0f});
        LootItemCondition.Builder notShearsOrSilk = InvertedLootItemCondition.invert((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{isShears, hasSilkTouch}));
        LootTable.Builder table = LootTable.lootTable();
        table.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{isShears, hasSilkTouch})).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)leaves)));
        table.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(notShearsOrSilk).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leaves, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)sapling))).when(BonusLevelTableCondition.bonusLevelFlatChance(this.fortuneHolder, (float[])saplingChances))));
        table.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(notShearsOrSilk).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leaves, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)customStick).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance(this.fortuneHolder, (float[])LEAVES_STICK_CHANCES))));
        return table;
    }

    protected Iterable<Block> getKnownBlocks() {
        return SNSBlock.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

