/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class SNSBlockTagProvider
extends BlockTagsProvider {
    public SNSBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper efh) {
        super(output, lookupProvider, "snsnf", efh);
    }

    private List<Block> collectBlocksByPath(Pattern ... patterns) {
        ArrayList<Block> out = new ArrayList<Block>();
        block0: for (Block b : BuiltInRegistries.BLOCK) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)b);
            if (id == null || !"snsnf".equals(id.getNamespace())) continue;
            String pathUpper = id.getPath().toUpperCase(Locale.ROOT);
            for (Pattern p : patterns) {
                if (!p.matcher(pathUpper).matches()) continue;
                out.add(b);
                continue block0;
            }
        }
        return out;
    }

    private void addByPatterns(TagKey<Block> tag, String ... regexes) {
        Pattern[] ps = (Pattern[])Arrays.stream(regexes).map(r -> Pattern.compile(r, 2)).toArray(Pattern[]::new);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender appender = this.tag(tag);
        this.collectBlocksByPath(ps).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)appender).add(arg_0));
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.addByPatterns((TagKey<Block>)BlockTags.DIRT, ".*(_GRASS_BLOCK|_DIRT_BLOCK)$", ".*(_CAKE_BLOCK)$", "(CANDYFLOSS_(BLOCK|VANILLA|STRAWBERRY|BLUE_RASPBERRY|LEMON))$", ".*_SORBET_SAND$", ".*_SAND$", "SUGAR_DIRT_BLOCK", "COCOA_DIRT_BLOCK", "COCOA_DARK_DIRT_BLOCK", "COCOA_WHITE_DIRT_BLOCK", "PRETZEL_BLOCK");
        this.addByPatterns((TagKey<Block>)BlockTags.SAND, ".*_SAND$");
        this.addByPatterns((TagKey<Block>)BlockTags.ANIMALS_SPAWNABLE_ON, ".*(_GRASS_BLOCK|_DIRT_BLOCK)$", ".*(_CAKE_BLOCK)$", "(CANDYFLOSS_(BLOCK|VANILLA|STRAWBERRY|BLUE_RASPBERRY|LEMON))$", ".*_SAND$", ".*_SORBET_SAND$", "CHOCOLATE_(BLOCK|DARK_BLOCK|WHITE_BLOCK)", "PRETZEL_BLOCK");
        this.addByPatterns((TagKey<Block>)BlockTags.VALID_SPAWN, ".*(_GRASS_BLOCK|_DIRT_BLOCK)$", ".*(_CAKE_BLOCK)$", "(CANDYFLOSS_(BLOCK|VANILLA|STRAWBERRY|BLUE_RASPBERRY|LEMON))$", ".*_SAND$", ".*_SORBET_SAND$", "CHOCOLATE_(BLOCK|DARK_BLOCK|WHITE_BLOCK)", "PRETZEL_BLOCK");
        this.addByPatterns((TagKey<Block>)BlockTags.BEDS, ".*_BED$");
        this.addByPatterns((TagKey<Block>)BlockTags.CROPS, ".*(CROP|SUGAR_CANE)$");
        this.addByPatterns((TagKey<Block>)BlockTags.CLIMBABLE, ".*_LADDER$");
        this.addByPatterns((TagKey<Block>)BlockTags.FENCES, ".*_FENCE$");
        this.addByPatterns((TagKey<Block>)BlockTags.FENCE_GATES, ".*_FENCE_GATE$");
        this.addByPatterns((TagKey<Block>)BlockTags.WALLS, ".*_WALL$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOOL_CARPETS, ".*_CARPET$");
        this.addByPatterns((TagKey<Block>)BlockTags.FLOWERS, ".*(_FLOWER(_\\d+)?|_BUSH|_COSMOS(_\\d+)?|_GRASS(_LONG)?|_GRASS_SHORT)$");
        this.addByPatterns((TagKey<Block>)BlockTags.LEAVES, ".*_LEAVES$");
        this.addByPatterns((TagKey<Block>)BlockTags.LOGS_THAT_BURN, "(STRIPPED_)?[A-Z_]*_(LOG|WOOD)$");
        this.addByPatterns((TagKey<Block>)BlockTags.SAPLINGS, ".*_SAPLING$");
        this.addByPatterns((TagKey<Block>)BlockTags.WALL_POST_OVERRIDE, ".*_TORCH$", ".*_WALL_TORCH$");
        this.addByPatterns((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, ".*(_GRASS_BLOCK|_DIRT_BLOCK|_SAND)$", ".*(_CAKE_BLOCK)$", "(CANDYFLOSS_(BLOCK|VANILLA|STRAWBERRY|BLUE_RASPBERRY|LEMON))$", "PRETZEL_BLOCK");
        this.addByPatterns((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, ".*(_LOG|_WOOD|_PLANKS)$", ".*WAFFLE_BLOCK$", ".*(_PLANK_(BUTTON|DOOR|FENCE(_GATE)?|PRESSURE_PLATE|SLAB|STAIRS|TRAPDOOR|WALL))$", ".*_CHEST$");
        this.addByPatterns((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, ".*((^|_)STONE(_.*)?|(^|_)BRICKS?(_.*)?|(^|_)FURNACE(_.*)?)$", ".*((BRICKS?|STONE).*(BUTTON|DOOR|FENCE(_GATE)?|PRESSURE_PLATE|SLAB|STAIRS|TRAPDOOR|WALL))$", "(MINT_BLOCK|CHOCOLATE_BLOCK|CHOCOLATE_DARK_BLOCK|CHOCOLATE_WHITE_BLOCK|PEPPERMINT_SWIRL_STONE).*", "(MINT_BRICK|CHOCOLATE_BRICK|HUMBUG_BRICK|STRAWBERRY_CREAM_BRICK|RHUBARB_CUSTARD_BRICK|WAFFLE_BRICK).*", ".*_FURNACE$");
        this.addByPatterns((TagKey<Block>)BlockTags.PLANKS, ".*_PLANKS$");
        this.addByPatterns((TagKey<Block>)BlockTags.LOGS, "(STRIPPED_)?[A-Z_]*_(LOG|WOOD)$");
        this.addByPatterns((TagKey<Block>)BlockTags.SLABS, ".*_SLAB$");
        this.addByPatterns((TagKey<Block>)BlockTags.STAIRS, ".*_STAIRS$");
        this.addByPatterns((TagKey<Block>)BlockTags.WALLS, ".*_WALL$");
        this.addByPatterns((TagKey<Block>)BlockTags.FENCES, ".*_FENCE$");
        this.addByPatterns((TagKey<Block>)BlockTags.FENCE_GATES, ".*_FENCE_GATE$");
        this.addByPatterns((TagKey<Block>)BlockTags.DOORS, ".*_DOOR$");
        this.addByPatterns((TagKey<Block>)BlockTags.TRAPDOORS, ".*_TRAPDOOR$");
        this.addByPatterns((TagKey<Block>)BlockTags.BUTTONS, ".*_BUTTON$");
        this.addByPatterns((TagKey<Block>)BlockTags.PRESSURE_PLATES, ".*_PRESSURE_PLATE$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_DOORS, ".*_PLANK_DOOR$", ".*_WOOD_DOOR$", ".*WAFFLE.*_DOOR$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_TRAPDOORS, ".*_PLANK_TRAPDOOR$", ".*_WOOD_TRAPDOOR$", ".*WAFFLE.*_TRAPDOOR$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_BUTTONS, ".*_PLANK_BUTTON$", ".*_WOOD_BUTTON$", ".*WAFFLE.*_BUTTON$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_PRESSURE_PLATES, ".*_PLANK_PRESSURE_PLATE$", ".*_WOOD_PRESSURE_PLATE$", ".*WAFFLE.*_PRESSURE_PLATE$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_FENCES, ".*_PLANK_FENCE$", ".*WAFFLE.*_FENCE$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_SLABS, ".*_PLANK_SLAB$", ".*WAFFLE.*_SLAB$");
        this.addByPatterns((TagKey<Block>)BlockTags.WOODEN_STAIRS, ".*_PLANK_STAIRS$", ".*WAFFLE.*_STAIRS$");
        this.addByPatterns((TagKey<Block>)BlockTags.STONE_BUTTONS, ".*(STONE|BRICK|BRICKS).*_BUTTON$");
        this.addByPatterns((TagKey<Block>)BlockTags.STONE_PRESSURE_PLATES, ".*(STONE|BRICK|BRICKS).*_PRESSURE_PLATE$");
        this.addByPatterns((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL, ".*((^|_)STONE(_.*)?|(^|_)BRICKS?(_.*)?)$", ".*((BRICKS?|STONE).*(BUTTON|PRESSURE_PLATE|SLAB|STAIRS|WALL))$", ".*_FURNACE$");
        this.addByPatterns((TagKey<Block>)BlockTags.IMPERMEABLE, "CRYSTALISED_SUGAR_GLASS");
        this.addByPatterns((TagKey<Block>)BlockTags.COAL_ORES, "PEPPERMINT_SWIRL_STONE_COAL_ORE");
        this.addByPatterns((TagKey<Block>)BlockTags.GUARDED_BY_PIGLINS, ".*_CHEST$");
    }
}

