/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.custom.SNSFishBuckets;

public class SNSItemModelProvider
extends ItemModelProvider {
    public SNSItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "snsnf", existingFileHelper);
    }

    protected void registerModels() {
        this.withExistingParent(SNSItem.BLACKBOARRY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.BLUEBOARRY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.RASPBOARRY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.STRAWBOARRY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.JAMSTER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.ANGEL_CAKE_FISH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CAKE_RABBIT_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CHEESECAKE_MOUSE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.ECLAIR_DOG_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.PRETZELFLY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.SQUIRROLL_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.BUNANA_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.DUCKANA_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.FRUIT_ELF_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.FRUIT_PUG_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.HAPPLE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.SNAPPLE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDY_CANE_CAT_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDY_CANE_CERBERUS_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDY_CANE_CROOK_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDY_CANE_FLY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDY_CANE_TIGER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDY_CANE_ZEBRA_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CINNABUN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CINNADILE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CINNAFFIN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CINNAMANTA_RAY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CINNAMOTH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.GINGERBREAD_MAN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.HUMBUG_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.HUMBULL_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.HUMFLY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.HUMPUG_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.MINT_MINK_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.MINTOW_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.MINTMUNK_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.MINT_IMPERIAL_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.MARSHMALLOW_SHEEP_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.MYNX_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.PEPPERMINT_CHURL_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.PEPPERMINT_TWIRL_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.ICE_CREAM_COW_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.ICE_CREAM_FISH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.PARFAIT_PIXIE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.WAFER_WITCH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.WAFER_WHALE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.WAFFLE_FISH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.WAFFLE_FISH_MINI_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.BONBONBINI_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDYFLOSS_LION_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CANDYFLOSS_SHEEP_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CHOCCOON_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CHOCOLATE_CHICKEN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CHOCOLATE_PENGUIN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CHOCOLATE_PIGEON_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.CHOCOLATE_REINDEER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.COLA_BOTTLENOSE_DOLPHIN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.GUMMY_BEAR_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.GUMMY_FISH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.JELLY_BABY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.LACE_SNAKE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.LACE_SPIDER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.RAINBOW_STRIP_JELLYFISH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.RAINBOW_STRIP_PEGASUS_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.RAINBOW_STRIP_PHOENIX_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.RAINBOW_STRIP_UNICORN_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.SUGARGLIDER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.SUGAR_WRAPPED_MUMMY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(SNSItem.TREAT_TOAD_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.basicItem((Item)SNSItem.CANDY_CANE_HELMET.get());
        this.basicItem((Item)SNSItem.CANDY_CANE_CHESTPLATE.get());
        this.basicItem((Item)SNSItem.CANDY_CANE_LEGGINGS.get());
        this.basicItem((Item)SNSItem.CANDY_CANE_BOOTS.get());
        this.basicItem((Item)SNSItem.ANGEL_CAKE.get());
        this.basicItem((Item)SNSItem.BLACKBERRY_LOLLIPOP.get());
        this.basicItem((Item)SNSItem.BLUEBERRY_LOLLIPOP.get());
        this.basicItem((Item)SNSItem.LEMON_LOLLIPOP.get());
        this.basicItem((Item)SNSItem.ORANGE_LOLLIPOP.get());
        this.basicItem((Item)SNSItem.RASPBERRY_LOLLIPOP.get());
        this.basicItem((Item)SNSItem.STRAWBERRY_LOLLIPOP.get());
        this.basicItem((Item)SNSItem.CANDYFLOSS.get());
        this.basicItem((Item)SNSItem.CANDYFLOSS_BLUE_RASPBERRY.get());
        this.basicItem((Item)SNSItem.CANDYFLOSS_LEMON.get());
        this.basicItem((Item)SNSItem.CANDYFLOSS_STRAWBERRY.get());
        this.basicItem((Item)SNSItem.CANDYFLOSS_VANILLA.get());
        this.basicItem((Item)SNSItem.CANDY_CANE.get());
        this.basicItem((Item)SNSItem.CANDY_CANE_ESSENCE_SHARD.get());
        this.basicItem((Item)SNSItem.CANDY_CANE_SUGAR.get());
        this.handheldItem(SNSItem.CANDY_CANE_SWORD);
        this.basicItem((Item)SNSItem.CHOCOLATE_EGG.get());
        this.basicItem((Item)SNSItem.CHOCOLATE_DARK_EGG.get());
        this.basicItem((Item)SNSItem.CHOCOLATE_WHITE_EGG.get());
        this.basicItem((Item)SNSItem.CHOCOLATE_STICK.get());
        this.basicItem((Item)SNSItem.CINNAMON.get());
        this.basicItem((Item)SNSItem.CINNAMON_BUN.get());
        this.basicItem((Item)SNSItem.CINNAMON_STICK.get());
        this.basicItem((Item)SNSItem.COLA_BOTTLE.get());
        this.basicItem((Item)SNSItem.CONE.get());
        this.basicItem((Item)SNSItem.CRYSTALISED_SUGAR_STICK.get());
        this.basicItem((Item)SNSItem.GELATIN.get());
        this.basicItem((Item)SNSItem.GUMMY_APPLE.get());
        this.basicItem((Item)SNSItem.GUMMY_BANANA.get());
        this.basicItem((Item)SNSItem.GUMMY_BLACKBERRY.get());
        this.basicItem((Item)SNSItem.GUMMY_BLUEBERRY.get());
        this.basicItem((Item)SNSItem.GUMMY_RASPBERRY.get());
        this.basicItem((Item)SNSItem.GUMMY_STRAWBERRY.get());
        this.basicItem((Item)SNSItem.HUMBUG.get());
        this.basicItem((Item)SNSItem.ICE_CREAM.get());
        this.basicItem((Item)SNSItem.VANILLA_ICE_CREAM.get());
        this.basicItem((Item)SNSItem.MINT_IMPERIAL.get());
        this.basicItem((Item)SNSItem.VANILLA_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.BLACKBERRY_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.BLUEBERRY_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.RASPBERRY_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.STRAWBERRY_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.CHOCOLATE_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.MINT_MARSHMALLOW.get());
        this.basicItem((Item)SNSItem.PEPPERMINT_SWIRL.get());
        this.basicItem((Item)SNSItem.POLO.get());
        this.basicItem((Item)SNSItem.PRETZEL.get());
        this.basicItem((Item)SNSItem.RAINBOW_STRIP.get());
        this.basicItem((Item)SNSItem.RAINBOW_STRIP_STICK.get());
        this.basicItem((Item)SNSItem.RHUBARB_CUSTARD.get());
        this.basicItem((Item)SNSItem.STRAWBERRY_CREAM.get());
        this.basicItem((Item)SNSItem.SPRINKLES_PINK.get());
        this.basicItem((Item)SNSItem.SPRINKLES_ORANGE.get());
        this.singleTexture("waffle_bucket", this.mcLoc("item/generated"), "layer0", this.modLoc("item/waffle_bucket"));
        for (SNSFishBuckets.FishSpec fish : SNSFishBuckets.FISHES) {
            for (SNSFishBuckets.FluidSpec fluid : SNSFishBuckets.FLUIDS) {
                String string = fish.id() + "_" + fluid.id() + "_bucket";
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(string, this.mcLoc("item/generated"))).texture("layer0", SNSFishBuckets.baseBucketTex())).texture("layer1", SNSFishBuckets.liquidTex(fluid.id()))).texture("layer2", SNSFishBuckets.fishTex(fish.id()));
            }
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("waffle_chocolate_bucket", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/waffle_bucket"))).texture("layer1", this.modLoc("item/liquids/chocolate_fill"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("waffle_cream_bucket", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/waffle_bucket"))).texture("layer1", this.modLoc("item/liquids/cream_fill"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("waffle_mint_water_bucket", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/waffle_bucket"))).texture("layer1", this.modLoc("item/liquids/mint_water_fill"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("waffle_water_bucket", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/waffle_bucket"))).texture("layer1", this.modLoc("item/liquids/water_fill"));
        this.basicItem((Item)SNSItem.WAFFLE_STICK.get());
        ((ItemModelBuilder)this.getBuilder("bourbon_carpet")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/bourbon_carpet")));
        ((ItemModelBuilder)this.getBuilder("custard_cream_carpet")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/custard_cream_carpet")));
        ((ItemModelBuilder)this.getBuilder("peppermint_swirl_carpet")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/peppermint_swirl_carpet")));
        this.flowerItem(SNSBlock.APPLE_FRUIT_ROLL_BUSH);
        this.flowerItem(SNSBlock.BANANA_FRUIT_ROLL_BUSH);
        this.flowerItem(SNSBlock.BLACKBERRY_ROLL_BUSH);
        this.flowerItem(SNSBlock.BLUEBERRY_ROLL_BUSH);
        this.flowerItem(SNSBlock.RASPBERRY_ROLL_BUSH);
        this.flowerItem(SNSBlock.STRAWBERRY_ROLL_BUSH);
        this.flowerItem(SNSBlock.CANDYFLOSS_BUSH);
        this.flowerItem(SNSBlock.CANDYFLOSS_COSMOS);
        this.flowerItem(SNSBlock.CANDYFLOSS_COSMOS_2);
        this.flowerItem(SNSBlock.CANDYFLOSS_COSMOS_3);
        this.flowerItem(SNSBlock.CANDYFLOSS_COSMOS_4);
        this.flowerItem(SNSBlock.CANDYFLOSS_COSMOS_5);
        this.flowerItem(SNSBlock.CANDYFLOSS_GRASS);
        this.flowerItem(SNSBlock.CANDYFLOSS_GRASS_SHORT);
        this.saplingItem(SNSBlock.CANDYFLOSS_SAPLING);
        this.flowerItem(SNSBlock.CANDY_CANE_BUSH);
        this.flowerItem(SNSBlock.CANDY_CANE_CARNATION);
        this.flowerItem(SNSBlock.CANDY_CANE_FLOWER);
        this.flowerItem(SNSBlock.CANDY_CANE_FLOWER_2);
        this.flowerItem(SNSBlock.CANDY_CANE_FLOWER_3);
        this.flowerItem(SNSBlock.CANDY_CANE_FLOWER_4);
        this.flowerItem(SNSBlock.CANDY_CANE_GRASS);
        this.flowerItem(SNSBlock.CANDY_CANE_GRASS_LONG);
        this.basicItem((Item)SNSItem.CANDY_CANE_SUGAR_CANE.get());
        this.saplingItem(SNSBlock.CANDY_CANE_SAPLING);
        this.flowerItem(SNSBlock.CHOCOLATE_GRASS);
        this.saplingItem(SNSBlock.CHOCOLATE_SAPLING);
        this.flowerItem(SNSBlock.CINNAMON_FLOWER);
        this.flowerItem(SNSBlock.CINNAMON_FLOWER_2);
        this.flowerItem(SNSBlock.CINNAMON_GRASS);
        this.flowerItem(SNSBlock.CINNAMON_GRASS_LONG);
        this.saplingItem(SNSBlock.CINNAMON_SAPLING);
        this.flowerItem(SNSBlock.RAINBOW_STRIP_FLOWER);
        this.flowerItem(SNSBlock.RAINBOW_STRIP_FLOWER_2);
        this.flowerItem(SNSBlock.RAINBOW_STRIP_GRASS);
        this.flowerItem(SNSBlock.RAINBOW_STRIP_GRASS_LONG);
        this.saplingItem(SNSBlock.RAINBOW_STRIP_SAPLING);
        this.flowerItem(SNSBlock.MINT_BUSH);
        this.flowerItem(SNSBlock.MINT_FLOWER);
        this.flowerItem(SNSBlock.MINT_FLOWER_2);
        this.flowerItem(SNSBlock.MINT_FLOWER_3);
        this.flowerItem(SNSBlock.MINT_GRASS);
        this.flowerItem(SNSBlock.MINT_GRASS_LONG);
        String name = SNSBlock.WAFFLE_CHEST.getId().getPath();
        ((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
        this.torchItem(SNSBlock.CANDY_CANE_TORCH, "candy_cane_torch");
        this.torchItem(SNSBlock.CHOCOLATE_TORCH, "chocolate_torch");
        this.torchItem(SNSBlock.CINNAMON_TORCH, "cinnamon_torch");
        this.torchItem(SNSBlock.CRYSTALISED_SUGAR_TORCH, "crystalised_sugar_torch");
        this.torchItem(SNSBlock.RAINBOW_STRIP_TORCH, "rainbow_strip_torch");
        this.torchItem(SNSBlock.WAFFLE_TORCH, "waffle_torch");
        this.familyItems("carrot_cake");
        this.familyItems("chocolate_cherry_cake");
        this.familyItems("chocolate_mint_cake");
        this.familyItems("chocolate_orange_cake");
        this.familyItems("lemon_curd_cake");
        this.familyItems("raspberry_cake");
        this.familyItems("strawberry_cake");
        this.familyItems("victoria_sponge_cake");
        for (String string : new String[]{"candyfloss", "candyfloss_blue_raspberry", "candyfloss_lemon", "candyfloss_strawberry", "candyfloss_vanilla"}) {
            this.familyItems(string);
        }
        for (String string : new String[]{"chocolate", "chocolate_dark", "chocolate_white", "mint"}) {
            this.familyItems(string);
        }
        for (String string : new String[]{"chocolate_brick", "chocolate_dark_brick", "chocolate_white_brick", "mint_brick", "humbug_brick", "peppermint_swirl_brick", "rhubarb_custard_brick", "strawberry_cream_brick", "waffle_brick"}) {
            this.familyItems(string);
        }
        for (String string : new String[]{"peppermint_swirl_stone", "rhubarb_custard_stone", "strawberry_cream_stone"}) {
            this.familyItems(string);
        }
        for (String string : new String[]{"gummy_apple", "gummy_banana", "gummy_blackberry", "gummy_blueberry", "gummy_raspberry", "gummy_strawberry"}) {
            this.familyItems(string);
        }
        for (String string : new String[]{"candy_cane_plank", "cinnamon_plank", "chocolate_plank", "crystalised_sugar_plank", "licorice_plank", "rainbow_strip_plank"}) {
            this.familyItems(string);
        }
        this.familyItems("waffle");
        this.familyItems("white_chocolate_coated_waffle");
        this.familyItems("chocolate_coated_waffle");
        this.familyItems("dark_chocolate_coated_waffle");
        this.familyItems("strawberry_chocolate_coated_waffle");
        this.familyItems("pretzel");
    }

    @Nullable
    private Block blockOrNull(String id) {
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)id);
        return BuiltInRegistries.BLOCK.getOptional(rl).orElse(null);
    }

    private void basicItemIfExists(String id) {
        Block b = this.blockOrNull(id);
        if (b != null) {
            this.basicItem(b.asItem());
        }
    }

    private void buttonItemIfExists(String partId, String ignoredBaseId) {
        Block part = this.blockOrNull(partId);
        if (part != null) {
            ((ItemModelBuilder)this.getBuilder(partId)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + partId)));
        }
    }

    private void fenceItemIfExists(String partId, String baseId) {
        Block part = this.blockOrNull(partId);
        Block base = this.blockOrNull(baseId);
        if (part != null && base != null) {
            ((ItemModelBuilder)this.withExistingParent(ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)partId).getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", this.modLoc("block/" + baseId));
        }
    }

    private void wallItemIfExists(String partId, String baseId) {
        Block part = this.blockOrNull(partId);
        Block base = this.blockOrNull(baseId);
        if (part != null && base != null) {
            ((ItemModelBuilder)this.withExistingParent(ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)partId).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/" + baseId));
        }
    }

    private String baseFor(String familyId) {
        switch (familyId) {
            case "mint_brick": 
            case "humbug_brick": 
            case "peppermint_swirl_brick": 
            case "rhubarb_custard_brick": 
            case "strawberry_cream_brick": {
                return familyId;
            }
        }
        if (familyId.endsWith("_brick")) {
            return familyId + "s";
        }
        if (familyId.endsWith("_stone")) {
            return familyId;
        }
        if (familyId.endsWith("_plank")) {
            return familyId + "s";
        }
        if (familyId.startsWith("gummy_")) {
            return familyId + "_block";
        }
        if (familyId.equals("waffle")) {
            return "waffle_block";
        }
        if (familyId.equals("mint")) {
            return "mint_block";
        }
        return familyId + "_block";
    }

    private void familyItems(String familyId) {
        String base = this.baseFor(familyId);
        this.buttonItemIfExists(familyId + "_button", base);
        this.basicItemIfExists(familyId + "_door");
        this.fenceItemIfExists(familyId + "_fence", base);
        this.wallItemIfExists(familyId + "_wall", base);
    }

    public void buttonItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        this.buttonItemIfExists(block.getId().getPath(), "");
    }

    public void fenceItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void flowerItem(DeferredBlock<Block> block) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("block/" + block.getId().getPath())));
    }

    private ItemModelBuilder handheldItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder saplingItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("block/" + item.getId().getPath())));
    }

    private void torchItem(DeferredBlock<? extends TorchBlock> torch, String textureName) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(torch.getId().getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/" + textureName));
    }

    public void wallItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("block/" + baseBlock.getId().getPath())));
    }
}

