/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.util.SNSTag;
import org.jetbrains.annotations.Nullable;

public class SNSRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public SNSRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    private ItemLike req(String path) {
        return (ItemLike)SNSBlock.byId(path).get();
    }

    @Nullable
    private ItemLike opt(String path) {
        try {
            return (ItemLike)SNSBlock.byId(path).get();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void familyByName(RecipeOutput out, String group, String basePath, String familyId) {
        this.familyByName(out, group, basePath, familyId, SNSTag.Items.RODS_WOODEN);
    }

    private void familyByName(RecipeOutput out, String group, String basePath, String familyId, @Nullable TagKey<Item> rodTag) {
        ItemLike base = this.req(basePath);
        ItemLike button = this.opt(familyId + "_button");
        ItemLike door = this.opt(familyId + "_door");
        ItemLike fence = this.opt(familyId + "_fence");
        ItemLike fenceGate = this.opt(familyId + "_fence_gate");
        ItemLike pressure = this.opt(familyId + "_pressure_plate");
        ItemLike slab = this.opt(familyId + "_slab");
        ItemLike stairs = this.opt(familyId + "_stairs");
        ItemLike trapdoor = this.opt(familyId + "_trapdoor");
        ItemLike wall = this.opt(familyId + "_wall");
        this.family(out, group, base, button, door, fence, fenceGate, pressure, slab, stairs, trapdoor, wall, rodTag);
    }

    protected void buildRecipes(RecipeOutput out) {
        List<ItemLike> SNS_SMELTABLES = List.of(this.req("peppermint_swirl_stone_coal_ore"));
        SNSRecipeProvider.oreSmelting(out, SNS_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.COAL, 0.25f, 200, "coal");
        SNSRecipeProvider.oreBlasting(out, SNS_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.COAL, 0.25f, 100, "coal");
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE_SWORD.get(), 1, new String[]{"C", "C", "S"}, Character.valueOf('C'), SNSItem.CANDY_CANE_ESSENCE_SHARD.get(), Character.valueOf('S'), SNSItem.CANDY_CANE.get()).unlockedBy("has_candy_cane", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE.get()))).unlockedBy("has_candy_cane_essence_shard", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_ESSENCE_SHARD.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE_HELMET.get(), 1, new String[]{"CEC", "C C"}, Character.valueOf('C'), SNSItem.CANDY_CANE_ESSENCE_SHARD.get(), Character.valueOf('E'), SNSItem.CANDY_CANE.get()).unlockedBy("has_candy_cane", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE.get()))).unlockedBy("has_candy_cane_essence_shard", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_ESSENCE_SHARD.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE_CHESTPLATE.get(), 1, new String[]{"C C", "EEE", "EEE"}, Character.valueOf('C'), SNSItem.CANDY_CANE_ESSENCE_SHARD.get(), Character.valueOf('E'), SNSItem.CANDY_CANE.get()).unlockedBy("has_candy_cane", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE.get()))).unlockedBy("has_candy_cane_essence_shard", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_ESSENCE_SHARD.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE_LEGGINGS.get(), 1, new String[]{"CEC", "C C", "E E"}, Character.valueOf('C'), SNSItem.CANDY_CANE_ESSENCE_SHARD.get(), Character.valueOf('E'), SNSItem.CANDY_CANE.get()).unlockedBy("has_candy_cane", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE.get()))).unlockedBy("has_candy_cane_essence_shard", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_ESSENCE_SHARD.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE_BOOTS.get(), 1, new String[]{"E E", "C C"}, Character.valueOf('C'), SNSItem.CANDY_CANE_ESSENCE_SHARD.get(), Character.valueOf('E'), SNSItem.CANDY_CANE.get()).unlockedBy("has_candy_cane", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE.get()))).unlockedBy("has_candy_cane_essence_shard", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_ESSENCE_SHARD.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE.get(), 2, new String[]{"CCC", "C C", "C  "}, Character.valueOf('C'), SNSItem.CANDY_CANE_SUGAR.get()).unlockedBy("has_candy_cane_sugar", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_SUGAR.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, this.req("candy_cane_furnace"), 1, new String[]{"CCC", "C C", "CCC"}, Character.valueOf('C'), this.req("peppermint_swirl_stone")).unlockedBy("has_peppermint_swirl_stone", SNSRecipeProvider.has((ItemLike)this.req("peppermint_swirl_stone"))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CANDY_CANE_SUGAR.get(), 1, new String[]{"C"}, Character.valueOf('C'), SNSItem.CANDY_CANE_SUGAR_CANE.get()).unlockedBy("has_candy_cane_sugar_cane", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CANDY_CANE_SUGAR_CANE.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.CONE.get(), 9, new String[]{"W"}, Character.valueOf('W'), this.req("waffle_block")).unlockedBy("has_waffle_block", SNSRecipeProvider.has((ItemLike)this.req("waffle_block"))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.VANILLA_ICE_CREAM.get(), 1, new String[]{"I", "W"}, Character.valueOf('I'), SNSItem.ICE_CREAM.get(), Character.valueOf('W'), SNSItem.CONE.get()).unlockedBy("has_ice_cream", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.ICE_CREAM.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)SNSItem.WAFFLE_STICK.get(), 9, new String[]{"W"}, Character.valueOf('W'), SNSItem.CONE.get()).unlockedBy("has_cone", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CONE.get()))).save(out);
        this.lantern(out, this.req("blackberry_lantern"), (ItemLike)SNSItem.GUMMY_BLACKBERRY.get(), "has_gummy_blackberry");
        this.lantern(out, this.req("blackberry_lollipop_lantern"), (ItemLike)SNSItem.BLACKBERRY_LOLLIPOP.get(), "has_blackberry_lollipop");
        this.lantern(out, this.req("blueberry_lantern"), (ItemLike)SNSItem.GUMMY_BLUEBERRY.get(), "has_gummy_blueberry");
        this.lantern(out, this.req("blueberry_lollipop_lantern"), (ItemLike)SNSItem.BLUEBERRY_LOLLIPOP.get(), "has_blueberry_lollipop");
        this.lantern(out, this.req("candyfloss_lantern"), (ItemLike)SNSItem.CANDYFLOSS.get(), "has_candyfloss");
        this.shaped(out, RecipeCategory.MISC, this.req("candy_cane_bed"), 1, new String[]{"MMM", "CCC"}, Character.valueOf('C'), this.req("candy_cane_planks"), Character.valueOf('M'), SNSItem.MINT_MARSHMALLOW.get()).unlockedBy("has_candy_cane_planks", SNSRecipeProvider.has((ItemLike)this.req("candy_cane_planks"))).unlockedBy("has_mint_marshmallow", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.MINT_MARSHMALLOW.get()))).save(out);
        this.ladder(out, this.req("candy_cane_ladder"), (ItemLike)SNSItem.CANDY_CANE.get(), "candy_cane");
        this.lantern(out, this.req("candy_cane_lantern"), (ItemLike)SNSItem.CANDY_CANE.get(), "has_candy_cane");
        this.shaped(out, RecipeCategory.MISC, this.req("candy_cane_planks"), 4, new String[]{"C"}, Character.valueOf('C'), this.req("candy_cane_log")).unlockedBy("has_candy_cane_log", SNSRecipeProvider.has((ItemLike)this.req("candy_cane_log"))).save(out);
        this.familyByName(out, "candy_cane_planks", "candy_cane_planks", "candy_cane_plank");
        this.torch(out, (ItemLike)SNSItem.CANDY_CANE_TORCH_ITEM.get(), (ItemLike)Items.COAL, (ItemLike)SNSItem.CANDY_CANE.get(), "candy_cane_torch");
        this.familyByName(out, "candyfloss", "candyfloss_block", "candyfloss");
        this.familyByName(out, "candyfloss_blue_raspberry", "candyfloss_blue_raspberry_block", "candyfloss_blue_raspberry");
        this.familyByName(out, "candyfloss_lemon", "candyfloss_lemon_block", "candyfloss_lemon");
        this.familyByName(out, "candyfloss_strawberry", "candyfloss_strawberry_block", "candyfloss_strawberry");
        this.familyByName(out, "candyfloss_vanilla", "candyfloss_vanilla_block", "candyfloss_vanilla");
        this.ladder(out, this.req("chocolate_ladder"), (ItemLike)SNSItem.CHOCOLATE_STICK.get(), "chocolate");
        this.shaped(out, RecipeCategory.MISC, this.req("chocolate_bed"), 1, new String[]{"MMM", "CCC"}, Character.valueOf('C'), this.req("chocolate_block"), Character.valueOf('M'), SNSItem.CHOCOLATE_MARSHMALLOW.get()).unlockedBy("has_chocolate_block", SNSRecipeProvider.has((ItemLike)this.req("chocolate_block"))).unlockedBy("has_chocolate_marshmallow", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CHOCOLATE_MARSHMALLOW.get()))).save(out);
        this.familyByName(out, "chocolate", "chocolate_block", "chocolate");
        this.shaped(out, RecipeCategory.MISC, this.req("chocolate_bricks"), 1, new String[]{"CC", "CC"}, Character.valueOf('C'), this.req("chocolate_block")).unlockedBy("has_chocolate_block", SNSRecipeProvider.has((ItemLike)this.req("chocolate_block"))).save(out);
        this.familyByName(out, "chocolate_brick", "chocolate_bricks", "chocolate_brick");
        this.shaped(out, RecipeCategory.MISC, this.req("chocolate_furnace"), 1, new String[]{"CCC", "C C", "CCC"}, Character.valueOf('C'), this.req("chocolate_bricks")).unlockedBy("has_chocolate_bricks", SNSRecipeProvider.has((ItemLike)this.req("chocolate_bricks"))).save(out);
        this.torch(out, (ItemLike)SNSItem.CHOCOLATE_TORCH_ITEM.get(), (ItemLike)Items.COAL, (ItemLike)SNSItem.CHOCOLATE_STICK.get(), "chocolate_torch");
        this.shaped(out, RecipeCategory.MISC, this.req("chocolate_planks"), 4, new String[]{"C"}, Character.valueOf('C'), this.req("chocolate_log")).unlockedBy("has_chocolate_log", SNSRecipeProvider.has((ItemLike)this.req("chocolate_log"))).save(out);
        this.familyByName(out, "chocolate_planks", "chocolate_planks", "chocolate_plank");
        this.familyByName(out, "chocolate_dark", "chocolate_dark_block", "chocolate_dark");
        this.shaped(out, RecipeCategory.MISC, this.req("chocolate_dark_bricks"), 1, new String[]{"CC", "CC"}, Character.valueOf('C'), this.req("chocolate_dark_block")).unlockedBy("has_chocolate_dark_block", SNSRecipeProvider.has((ItemLike)this.req("chocolate_dark_block"))).save(out);
        this.familyByName(out, "chocolate_dark_brick", "chocolate_dark_bricks", "chocolate_dark_brick");
        this.familyByName(out, "chocolate_white", "chocolate_white_block", "chocolate_white");
        this.shaped(out, RecipeCategory.MISC, this.req("chocolate_white_bricks"), 1, new String[]{"CC", "CC"}, Character.valueOf('C'), this.req("chocolate_white_block")).unlockedBy("has_chocolate_white_block", SNSRecipeProvider.has((ItemLike)this.req("chocolate_white_block"))).save(out);
        this.familyByName(out, "chocolate_white_brick", "chocolate_white_bricks", "chocolate_white_brick");
        this.ladder(out, this.req("cinnamon_ladder"), (ItemLike)SNSItem.CINNAMON_STICK.get(), "cinnamon");
        this.shaped(out, RecipeCategory.MISC, this.req("cinnamon_planks"), 4, new String[]{"C"}, Character.valueOf('C'), this.req("cinnamon_log")).unlockedBy("has_cinnamon_log", SNSRecipeProvider.has((ItemLike)this.req("cinnamon_log"))).save(out);
        this.familyByName(out, "cinnamon_planks", "cinnamon_planks", "cinnamon_plank");
        this.torch(out, (ItemLike)SNSItem.CINNAMON_TORCH_ITEM.get(), (ItemLike)Items.COAL, (ItemLike)SNSItem.CINNAMON_STICK.get(), "cinnamon_torch");
        this.shaped(out, RecipeCategory.MISC, this.req("crystalised_sugar_furnace"), 1, new String[]{"CCC", "C C", "CCC"}, Character.valueOf('C'), this.req("crystalised_sugar_planks")).unlockedBy("has_crystalised_sugar_planks", SNSRecipeProvider.has((ItemLike)this.req("crystalised_sugar_planks"))).save(out);
        this.shaped(out, RecipeCategory.MISC, this.req("crystalised_sugar_planks"), 4, new String[]{"C"}, Character.valueOf('C'), this.req("crystalised_sugar_log")).unlockedBy("has_crystalised_sugar_log", SNSRecipeProvider.has((ItemLike)this.req("crystalised_sugar_log"))).save(out);
        this.familyByName(out, "crystalised_sugar_planks", "crystalised_sugar_planks", "crystalised_sugar_plank");
        this.torch(out, (ItemLike)SNSItem.CRYSTALISED_SUGAR_TORCH_ITEM.get(), (ItemLike)Items.COAL, (ItemLike)SNSItem.CRYSTALISED_SUGAR_STICK.get(), "crystalised_sugar_torch");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("gummy_apple_block"), 16, (ItemLike)SNSItem.GUMMY_APPLE.get()).unlockedBy("has_gummy_apple", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.GUMMY_APPLE.get()))).save(out);
        this.familyByName(out, "gummy_apple", "gummy_apple_block", "gummy_apple");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("gummy_banana_block"), 16, (ItemLike)SNSItem.GUMMY_BANANA.get()).unlockedBy("has_gummy_banana", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.GUMMY_BANANA.get()))).save(out);
        this.familyByName(out, "gummy_banana", "gummy_banana_block", "gummy_banana");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("gummy_blackberry_block"), 16, (ItemLike)SNSItem.GUMMY_BLACKBERRY.get()).unlockedBy("has_gummy_blackberry", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.GUMMY_BLACKBERRY.get()))).save(out);
        this.familyByName(out, "gummy_blackberry", "gummy_blackberry_block", "gummy_blackberry");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("gummy_blueberry_block"), 16, (ItemLike)SNSItem.GUMMY_BLUEBERRY.get()).unlockedBy("has_gummy_blueberry", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.GUMMY_BLUEBERRY.get()))).save(out);
        this.familyByName(out, "gummy_blueberry", "gummy_blueberry_block", "gummy_blueberry");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("gummy_raspberry_block"), 16, (ItemLike)SNSItem.GUMMY_RASPBERRY.get()).unlockedBy("has_gummy_raspberry", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.GUMMY_RASPBERRY.get()))).save(out);
        this.familyByName(out, "gummy_raspberry", "gummy_raspberry_block", "gummy_raspberry");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("gummy_strawberry_block"), 16, (ItemLike)SNSItem.GUMMY_STRAWBERRY.get()).unlockedBy("has_gummy_strawberry", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.GUMMY_STRAWBERRY.get()))).save(out);
        this.familyByName(out, "gummy_strawberry", "gummy_strawberry_block", "gummy_strawberry");
        this.shaped2x2(out, RecipeCategory.MISC, this.req("humbug_brick"), 16, (ItemLike)SNSItem.HUMBUG.get()).unlockedBy("has_humbug", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.HUMBUG.get()))).save(out);
        this.familyByName(out, "humbug_brick", "humbug_brick", "humbug_brick");
        this.lantern(out, this.req("ice_cream_lantern"), (ItemLike)SNSItem.VANILLA_ICE_CREAM.get(), "has_ice_cream");
        this.lantern(out, this.req("raspberry_lollipop_lantern"), (ItemLike)SNSItem.RASPBERRY_LOLLIPOP.get(), "has_raspberry_lollipop");
        this.lantern(out, this.req("strawberry_lollipop_lantern"), (ItemLike)SNSItem.STRAWBERRY_LOLLIPOP.get(), "has_strawberry_lollipop");
        this.shaped(out, RecipeCategory.MISC, this.req("licorice_planks"), 4, new String[]{"C"}, Character.valueOf('C'), this.req("licorice_log")).unlockedBy("has_licorice_log", SNSRecipeProvider.has((ItemLike)this.req("licorice_log"))).save(out);
        this.familyByName(out, "licorice_planks", "licorice_planks", "licorice_plank");
        this.shaped(out, RecipeCategory.MISC, this.req("mint_brick"), 4, new String[]{"MM", "MM"}, Character.valueOf('M'), this.req("mint_block")).unlockedBy("has_mint_block", SNSRecipeProvider.has((ItemLike)this.req("mint_block"))).save(out);
        this.familyByName(out, "mint_block", "mint_block", "mint_block");
        this.familyByName(out, "mint_brick", "mint_brick", "mint_brick");
        this.shaped(out, RecipeCategory.MISC, this.req("peppermint_swirl_brick"), 4, new String[]{"CC", "CC"}, Character.valueOf('C'), this.req("peppermint_swirl_stone")).unlockedBy("has_peppermint_swirl_stone", SNSRecipeProvider.has((ItemLike)this.req("peppermint_swirl_stone"))).save(out);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SNSBlock.PEPPERMINT_SWIRL_CARPET.get())).pattern("PM").define(Character.valueOf('P'), (ItemLike)SNSItem.PEPPERMINT_SWIRL.get()).define(Character.valueOf('M'), (ItemLike)SNSItem.MINT_MARSHMALLOW.get()).unlockedBy("has_peppermint_swirl", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.PEPPERMINT_SWIRL.get()))).unlockedBy("has_mint_marshmallow", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.MINT_MARSHMALLOW.get()))).save(out);
        this.familyByName(out, "peppermint_swirl_brick", "peppermint_swirl_brick", "peppermint_swirl_brick");
        this.familyByName(out, "peppermint_swirl_stone", "peppermint_swirl_stone", "peppermint_swirl_stone");
        this.familyByName(out, "pretzel", "pretzel_block", "pretzel");
        this.ladder(out, this.req("rainbow_strip_ladder"), (ItemLike)SNSItem.RAINBOW_STRIP_STICK.get(), "rainbow_strip");
        this.shaped(out, RecipeCategory.MISC, this.req("rainbow_strip_planks"), 4, new String[]{"C"}, Character.valueOf('C'), this.req("rainbow_strip_log")).unlockedBy("has_rainbow_strip_log", SNSRecipeProvider.has((ItemLike)this.req("rainbow_strip_log"))).save(out);
        this.familyByName(out, "rainbow_strip_planks", "rainbow_strip_planks", "rainbow_strip_plank");
        this.torch(out, (ItemLike)SNSItem.RAINBOW_STRIP_TORCH_ITEM.get(), (ItemLike)Items.COAL, (ItemLike)SNSItem.RAINBOW_STRIP_STICK.get(), "rainbow_strip_torch");
        this.shaped(out, RecipeCategory.MISC, this.req("rhubarb_custard_brick"), 4, new String[]{"CC", "CC"}, Character.valueOf('C'), this.req("rhubarb_custard_stone")).unlockedBy("has_rhubarb_custard_stone", SNSRecipeProvider.has((ItemLike)this.req("rhubarb_custard_stone"))).save(out);
        this.familyByName(out, "rhubarb_custard_brick", "rhubarb_custard_brick", "rhubarb_custard_brick");
        this.familyByName(out, "rhubarb_custard_stone", "rhubarb_custard_stone", "rhubarb_custard_stone");
        this.shaped(out, RecipeCategory.MISC, this.req("strawberry_cream_brick"), 4, new String[]{"CC", "CC"}, Character.valueOf('C'), this.req("strawberry_cream_stone")).unlockedBy("has_strawberry_cream_stone", SNSRecipeProvider.has((ItemLike)this.req("strawberry_cream_stone"))).save(out);
        this.familyByName(out, "strawberry_cream_brick", "strawberry_cream_brick", "strawberry_cream_brick");
        this.familyByName(out, "strawberry_cream_stone", "strawberry_cream_stone", "strawberry_cream_stone");
        this.shaped(out, RecipeCategory.MISC, this.req("waffle_bed"), 1, new String[]{"MMM", "WWW"}, Character.valueOf('W'), this.req("waffle_block"), Character.valueOf('M'), SNSItem.VANILLA_MARSHMALLOW.get()).unlockedBy("has_waffle_block", SNSRecipeProvider.has((ItemLike)this.req("waffle_block"))).unlockedBy("has_vanilla_marshmallow", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.VANILLA_MARSHMALLOW.get()))).save(out);
        this.shaped(out, RecipeCategory.MISC, this.req("waffle_block"), 16, new String[]{"WW", "WW"}, Character.valueOf('W'), SNSItem.WAFFLE_STICK.get()).unlockedBy("has_waffle_stick", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.WAFFLE_STICK.get()))).save(out);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SNSItem.WAFFLE_BUCKET.get())).pattern("W W").pattern(" C ").define(Character.valueOf('W'), (ItemLike)((Block)SNSBlock.WAFFLE_BLOCK.get()).asItem()).define(Character.valueOf('C'), (ItemLike)SNSItem.CONE.get()).unlockedBy("has_cone", SNSRecipeProvider.has((ItemLike)((ItemLike)SNSItem.CONE.get()))).unlockedBy("has_waffle_block", SNSRecipeProvider.has((ItemLike)((Block)SNSBlock.WAFFLE_BLOCK.get()).asItem())).save(out);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.req("waffle_chest")).define(Character.valueOf('#'), (ItemLike)((Block)SNSBlock.WAFFLE_BLOCK.get()).asItem()).pattern("###").pattern("# #").pattern("###").unlockedBy("has_waffle_block", SNSRecipeProvider.has((ItemLike)((Block)SNSBlock.WAFFLE_BLOCK.get()).asItem())).save(out);
        this.ladder(out, this.req("waffle_ladder"), (ItemLike)SNSItem.WAFFLE_STICK.get(), "waffle");
        this.familyByName(out, "waffle", "waffle_block", "waffle");
        this.shaped(out, RecipeCategory.MISC, this.req("waffle_bricks"), 1, new String[]{"W"}, Character.valueOf('W'), this.req("waffle_block")).unlockedBy("has_waffle_block", SNSRecipeProvider.has((ItemLike)this.req("waffle_block"))).save(out);
        this.familyByName(out, "waffle_brick", "waffle_bricks", "waffle_brick");
        this.torch(out, (ItemLike)SNSItem.WAFFLE_TORCH_ITEM.get(), (ItemLike)Items.COAL, (ItemLike)SNSItem.WAFFLE_STICK.get(), "waffle_torch");
        this.familyByName(out, "white_chocolate_coated_waffle", "white_chocolate_coated_waffle_block", "white_chocolate_coated_waffle");
        this.familyByName(out, "chocolate_coated_waffle", "chocolate_coated_waffle_block", "chocolate_coated_waffle");
        this.familyByName(out, "dark_chocolate_coated_waffle", "dark_chocolate_coated_waffle_block", "dark_chocolate_coated_waffle");
        this.familyByName(out, "strawberry_chocolate_coated_waffle", "strawberry_chocolate_coated_waffle_block", "strawberry_chocolate_coated_waffle");
        this.familyByName(out, "carrot_cake", "carrot_cake_block", "carrot_cake");
        this.familyByName(out, "chocolate_cherry_cake", "chocolate_cherry_cake_block", "chocolate_cherry_cake");
        this.familyByName(out, "chocolate_mint_cake", "chocolate_mint_cake_block", "chocolate_mint_cake");
        this.familyByName(out, "chocolate_orange_cake", "chocolate_orange_cake_block", "chocolate_orange_cake");
        this.familyByName(out, "lemon_curd_cake", "lemon_curd_cake_block", "lemon_curd_cake");
        this.familyByName(out, "raspberry_cake", "raspberry_cake_block", "raspberry_cake");
        this.familyByName(out, "strawberry_cake", "strawberry_cake_block", "strawberry_cake");
        this.familyByName(out, "victoria_sponge_cake", "victoria_sponge_cake_block", "victoria_sponge_cake");
    }

    private ShapedRecipeBuilder shaped(RecipeOutput out, RecipeCategory cat, ItemLike result, int count, String[] pattern, Object ... keyVals) {
        ShapedRecipeBuilder b = ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)result, (int)count);
        for (String row : pattern) {
            b = b.pattern(row);
        }
        for (int i = 0; i < keyVals.length; i += 2) {
            char k = ((Character)keyVals[i]).charValue();
            ItemLike v = (ItemLike)keyVals[i + 1];
            b = b.define(Character.valueOf(k), v);
        }
        return b;
    }

    private ShapedRecipeBuilder shaped2x2(RecipeOutput out, RecipeCategory cat, ItemLike result, int count, ItemLike ingredient) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)result, (int)count).pattern("##").pattern("##").define(Character.valueOf('#'), ingredient);
    }

    private void lantern(RecipeOutput out, ItemLike result, ItemLike core, String unlockKey) {
        this.lantern(out, result, core, unlockKey, Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}));
    }

    private void lantern(RecipeOutput out, ItemLike result, ItemLike core, String unlockKey, ItemLike torchItem) {
        this.lantern(out, result, core, unlockKey, Ingredient.of((ItemLike[])new ItemLike[]{torchItem}));
    }

    private void lantern(RecipeOutput out, ItemLike result, ItemLike core, String unlockKey, TagKey<Item> torchTag) {
        this.lantern(out, result, core, unlockKey, Ingredient.of(torchTag));
    }

    private void lantern(RecipeOutput out, ItemLike result, ItemLike core, String unlockKey, Ingredient torchIngredient) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("XT").define(Character.valueOf('X'), core).define(Character.valueOf('T'), torchIngredient).unlockedBy(unlockKey, SNSRecipeProvider.has((ItemLike)core)).save(out);
    }

    private void torch(RecipeOutput out, ItemLike torchItem, ItemLike fuelItem, ItemLike rodItem, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torchItem, (int)4).group(group).pattern("F").pattern("R").define(Character.valueOf('F'), fuelItem).define(Character.valueOf('R'), rodItem).unlockedBy("has_fuel", SNSRecipeProvider.has((ItemLike)fuelItem)).save(out);
    }

    private void torch(RecipeOutput out, ItemLike torchItem, TagKey<Item> fuelTag, TagKey<Item> rodTag, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torchItem, (int)4).group(group).pattern("F").pattern("R").define(Character.valueOf('F'), fuelTag).define(Character.valueOf('R'), rodTag).unlockedBy("has_fuel", SNSRecipeProvider.has(fuelTag)).save(out);
    }

    private void torch(RecipeOutput out, ItemLike torchItem, ItemLike fuelItem, TagKey<Item> rodTag, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torchItem, (int)4).group(group).pattern("F").pattern("R").define(Character.valueOf('F'), fuelItem).define(Character.valueOf('R'), rodTag).unlockedBy("has_fuel", SNSRecipeProvider.has((ItemLike)fuelItem)).save(out);
    }

    private void torch(RecipeOutput out, ItemLike torchItem, TagKey<Item> fuelTag, ItemLike rodItem, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torchItem, (int)4).group(group).pattern("F").pattern("R").define(Character.valueOf('F'), fuelTag).define(Character.valueOf('R'), rodItem).unlockedBy("has_fuel", SNSRecipeProvider.has(fuelTag)).save(out);
    }

    private void ladder(RecipeOutput out, ItemLike ladderBlock, ItemLike rodItem, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladderBlock, (int)3).group(group).pattern("R R").pattern("RRR").pattern("R R").define(Character.valueOf('R'), rodItem).unlockedBy("has_rod", SNSRecipeProvider.has((ItemLike)rodItem)).save(out);
    }

    private void ladder(RecipeOutput out, ItemLike ladderBlock, TagKey<Item> rodTag, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladderBlock, (int)3).group(group).pattern("R R").pattern("RRR").pattern("R R").define(Character.valueOf('R'), rodTag).unlockedBy("has_rod", SNSRecipeProvider.has(rodTag)).save(out);
    }

    private void family(RecipeOutput out, String group, ItemLike base, @Nullable ItemLike button, @Nullable ItemLike door, @Nullable ItemLike fence, @Nullable ItemLike fenceGate, @Nullable ItemLike pressurePlate, @Nullable ItemLike slab, @Nullable ItemLike stairs, @Nullable ItemLike trapdoor, @Nullable ItemLike wall, @Nullable TagKey<Item> rodTag) {
        if (button != null) {
            SNSRecipeProvider.buttonBuilder((ItemLike)button, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).group(group).unlockedBy("has_base", SNSRecipeProvider.has((ItemLike)base)).save(out);
        }
        if (door != null) {
            SNSRecipeProvider.doorBuilder((ItemLike)door, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).group(group).unlockedBy("has_base", SNSRecipeProvider.has((ItemLike)base)).save(out);
        }
        if (fence != null) {
            this.fenceWithRod(out, group, fence, base, rodTag);
        }
        if (fenceGate != null) {
            this.fenceGateWithRod(out, group, fenceGate, base, rodTag);
        }
        if (pressurePlate != null) {
            SNSRecipeProvider.pressurePlate((RecipeOutput)out, (ItemLike)pressurePlate, (ItemLike)base);
        }
        if (slab != null) {
            SNSRecipeProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
        }
        if (stairs != null) {
            SNSRecipeProvider.stairBuilder((ItemLike)stairs, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).group(group).unlockedBy("has_base", SNSRecipeProvider.has((ItemLike)base)).save(out);
        }
        if (trapdoor != null) {
            SNSRecipeProvider.trapdoorBuilder((ItemLike)trapdoor, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).group(group).unlockedBy("has_base", SNSRecipeProvider.has((ItemLike)base)).save(out);
        }
        if (wall != null) {
            SNSRecipeProvider.wall((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        }
    }

    private void fenceWithRod(RecipeOutput out, String group, ItemLike fence, ItemLike base, @Nullable TagKey<Item> rodTag) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).group(group).pattern("#S#").pattern("#S#").define(Character.valueOf('#'), base).define(Character.valueOf('S'), rodTag != null ? Ingredient.of(rodTag) : Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy("has_base", SNSRecipeProvider.has((ItemLike)base)).unlockedBy("has_rod", rodTag != null ? SNSRecipeProvider.has(rodTag) : SNSRecipeProvider.has((ItemLike)Items.STICK)).save(out);
    }

    private void fenceGateWithRod(RecipeOutput out, String group, ItemLike fenceGate, ItemLike base, @Nullable TagKey<Item> rodTag) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).group(group).pattern("S#S").pattern("S#S").define(Character.valueOf('#'), base).define(Character.valueOf('S'), rodTag != null ? Ingredient.of(rodTag) : Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy("has_base", SNSRecipeProvider.has((ItemLike)base)).unlockedBy("has_rod", rodTag != null ? SNSRecipeProvider.has(rodTag) : SNSRecipeProvider.has((ItemLike)Items.STICK)).save(out);
    }

    protected static void oreSmelting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        SNSRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        SNSRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput pRecipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(SNSRecipeProvider.getHasName((ItemLike)itemlike), SNSRecipeProvider.has((ItemLike)itemlike)).save(pRecipeOutput, "snsnf:" + SNSRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + SNSRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

