/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.ai;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.xstarlotte.snsnf.mob_effects.HerbHarmEffect;

public class HerbHealingAttackGoal
extends MeleeAttackGoal {
    private final TamableAnimal herb;
    private final float totalDamage;
    private final int durationTicks;
    private final boolean bypassAllies;

    public HerbHealingAttackGoal(TamableAnimal mob, double speedModifier, boolean followEvenIfNotSeen, float totalDamage, int durationTicks, boolean bypassAllies) {
        super((PathfinderMob)mob, speedModifier, followEvenIfNotSeen);
        this.herb = mob;
        this.totalDamage = totalDamage;
        this.durationTicks = durationTicks;
        this.bypassAllies = bypassAllies;
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        int beforeHurtTime = 0;
        boolean aboutToAttack = false;
        if (target != null) {
            double distSq = this.mob.distanceToSqr(target.getX(), target.getY(), target.getZ());
            boolean bl = aboutToAttack = this.isTimeToAttack() && distSq <= this.attackReachSqr(target);
            if (aboutToAttack) {
                beforeHurtTime = target.hurtTime;
            }
        }
        super.tick();
        if (aboutToAttack && target != null && target.isAlive() && target.hurtTime > beforeHurtTime) {
            Player p;
            if (!(this.herb.level() instanceof ServerLevel)) {
                return;
            }
            if (!this.bypassAllies && this.herb.isAlliedTo((Entity)target)) {
                return;
            }
            LivingEntity livingEntity = this.herb.getOwner();
            Player owner = livingEntity instanceof Player ? (p = (Player)livingEntity) : null;
            HerbHarmEffect.applyOrRefresh(target, (LivingEntity)this.herb, owner, this.totalDamage, this.durationTicks);
        }
    }

    private double attackReachSqr(LivingEntity target) {
        float f = this.mob.getBbWidth();
        return f * 2.0f * f * 2.0f + target.getBbWidth();
    }

    public boolean canUse() {
        return this.herb.isTame() && this.herb.getOwner() != null && !this.herb.isOrderedToSit() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.herb.isTame() && this.herb.getOwner() != null && !this.herb.isOrderedToSit() && super.canContinueToUse();
    }
}

