/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.ai;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class SugarRushAttackGoal
extends Goal {
    private final PathfinderMob mob;
    private final double moveSpeed;
    private final boolean longMemory;
    private int reattackDelayTicks = 12;
    private int nextAttackIn = 0;
    private float burstDamage = 8.0f;
    private double pounceH = 0.6;
    private double pounceV = 0.35;
    private int pounceCD = 12;
    private int pounceTimer = 0;

    public SugarRushAttackGoal(PathfinderMob mob, double moveSpeed, boolean longMemory) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.longMemory = longMemory;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public SugarRushAttackGoal reattackTicks(int ticks) {
        this.reattackDelayTicks = Math.max(1, ticks);
        return this;
    }

    public SugarRushAttackGoal totalDamage(float dmg) {
        this.burstDamage = Math.max(0.0f, dmg);
        return this;
    }

    public SugarRushAttackGoal pounce(double h, double v) {
        this.pounceH = Math.max(0.0, h);
        this.pounceV = Math.max(0.0, v);
        return this;
    }

    public boolean canUse() {
        TamableAnimal ta2;
        PathfinderMob pathfinderMob = this.mob;
        if (!(pathfinderMob instanceof TamableAnimal)) {
            return false;
        }
        TamableAnimal ta = (TamableAnimal)pathfinderMob;
        if (!ta.isTame() || ta.getOwner() == null || ta.isOrderedToSit()) {
            return false;
        }
        LivingEntity t = this.mob.getTarget();
        if (t == null || !t.isAlive()) {
            return false;
        }
        if (this.mob.isAlliedTo((Entity)t)) {
            return false;
        }
        if (t instanceof TamableAnimal && (ta2 = (TamableAnimal)t).isTame()) {
            return false;
        }
        return this.longMemory || this.mob.getSensing().hasLineOfSight((Entity)t);
    }

    public boolean canContinueToUse() {
        PathfinderMob pathfinderMob = this.mob;
        if (!(pathfinderMob instanceof TamableAnimal)) {
            return false;
        }
        TamableAnimal ta = (TamableAnimal)pathfinderMob;
        if (!ta.isTame() || ta.getOwner() == null || ta.isOrderedToSit()) {
            return false;
        }
        LivingEntity t = this.mob.getTarget();
        if (t == null || !t.isAlive()) {
            return false;
        }
        return this.longMemory || this.mob.getSensing().hasLineOfSight((Entity)t);
    }

    public void start() {
        this.nextAttackIn = 0;
        this.pounceTimer = 0;
        LivingEntity t = this.mob.getTarget();
        if (t != null) {
            this.mob.getNavigation().moveTo((Entity)t, this.moveSpeed);
        }
    }

    public void stop() {
        if (!this.mob.getNavigation().isDone()) {
            this.mob.getNavigation().stop();
        }
    }

    public void tick() {
        double dy;
        double dz;
        TamableAnimal ta;
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof TamableAnimal && (!(ta = (TamableAnimal)pathfinderMob).isTame() || ta.isOrderedToSit())) {
            this.mob.getNavigation().stop();
            this.mob.setTarget(null);
            return;
        }
        LivingEntity t = this.mob.getTarget();
        if (t == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)t, 30.0f, 30.0f);
        if (this.mob.getNavigation().isDone() || this.mob.tickCount % 5 == 0) {
            this.mob.getNavigation().moveTo((Entity)t, this.moveSpeed);
        }
        if (this.pounceTimer > 0) {
            --this.pounceTimer;
        }
        if (this.nextAttackIn > 0) {
            --this.nextAttackIn;
            return;
        }
        double dx = t.getX() - this.mob.getX();
        double dist2 = dx * dx + (dz = t.getZ() - this.mob.getZ()) * dz + (dy = Math.max(0.0, Math.abs(t.getY() - this.mob.getY()) - 0.6)) * dy;
        if (dist2 <= this.getAttackReachSqr(t)) {
            this.doPounce(t);
            this.nextAttackIn = this.performBurstHitNoKnockback(t) ? this.reattackDelayTicks : 4;
        }
    }

    private boolean performBurstHitNoKnockback(LivingEntity target) {
        if (this.mob.isAlliedTo((Entity)target)) {
            return false;
        }
        this.mob.swing(InteractionHand.MAIN_HAND);
        return target.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), this.burstDamage);
    }

    private void doPounce(LivingEntity target) {
        if (this.pounceTimer > 0) {
            return;
        }
        if (!this.mob.onGround() || this.mob.isInWaterOrBubble()) {
            return;
        }
        Vec3 dir = target.position().subtract(this.mob.position());
        Vec3 planar = new Vec3(dir.x, 0.0, dir.z);
        if (planar.lengthSqr() < 1.0E-6) {
            return;
        }
        planar = planar.normalize();
        Vec3 motion = this.mob.getDeltaMovement().scale(0.2).add(planar.scale(this.pounceH)).add(0.0, this.pounceV, 0.0);
        this.mob.setDeltaMovement(motion);
        this.mob.hasImpulse = true;
        this.pounceTimer = this.pounceCD;
    }

    private double getAttackReachSqr(LivingEntity target) {
        double reach = (double)this.mob.getBbWidth() * 1.6 + (double)target.getBbWidth() * 0.9 + 0.35;
        return reach * reach;
    }
}

