/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.cake;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.cake.GingerbreadManModel;
import net.xstarlotte.snsnf.entity.client.variant.GingerbreadManVariant;
import net.xstarlotte.snsnf.entity.custom.cake.GingerbreadManEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class GingerbreadManRenderer
extends GeoEntityRenderer<GingerbreadManEntity> {
    private static final Map<GingerbreadManVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(GingerbreadManVariant.class), map -> map.put(GingerbreadManVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/gingerbread_man.png")));

    public GingerbreadManRenderer(EntityRendererProvider.Context context) {
        super(context, new GingerbreadManModel());
    }

    public ResourceLocation getTextureLocation(GingerbreadManEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(GingerbreadManEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.15f, 0.15f, 0.15f);
        } else {
            poseStack.scale(0.3f, 0.3f, 0.3f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

