/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.cake;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.cake.SquirrollModel;
import net.xstarlotte.snsnf.entity.client.variant.SquirrollVariant;
import net.xstarlotte.snsnf.entity.custom.cake.SquirrollEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class SquirrollRenderer
extends GeoEntityRenderer<SquirrollEntity> {
    private static final Map<SquirrollVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(SquirrollVariant.class), map -> {
        map.put(SquirrollVariant.CINNAMON, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/cinnamon_squirroll.png"));
        map.put(SquirrollVariant.CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/chocolate_squirroll.png"));
        map.put(SquirrollVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/strawberry_squirroll.png"));
    });

    public SquirrollRenderer(EntityRendererProvider.Context context) {
        super(context, new SquirrollModel());
    }

    public ResourceLocation getTextureLocation(SquirrollEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(SquirrollEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.1f, 0.1f, 0.1f);
        } else {
            poseStack.scale(0.25f, 0.25f, 0.25f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

