/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.herb;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneTigerModel;
import net.xstarlotte.snsnf.entity.client.variant.CandyCaneTigerVariant;
import net.xstarlotte.snsnf.entity.custom.herb.CandyCaneTigerEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CandyCaneTigerRenderer
extends GeoEntityRenderer<CandyCaneTigerEntity> {
    private static final Map<CandyCaneTigerVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CandyCaneTigerVariant.class), map -> map.put(CandyCaneTigerVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_tiger.png")));

    public CandyCaneTigerRenderer(EntityRendererProvider.Context context) {
        super(context, new CandyCaneTigerModel());
    }

    public ResourceLocation getTextureLocation(CandyCaneTigerEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(CandyCaneTigerEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

