/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.herb;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneZebraModel;
import net.xstarlotte.snsnf.entity.client.variant.CandyCaneZebraVariant;
import net.xstarlotte.snsnf.entity.custom.herb.CandyCaneZebraEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CandyCaneZebraRenderer
extends GeoEntityRenderer<CandyCaneZebraEntity> {
    private static final Map<CandyCaneZebraVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CandyCaneZebraVariant.class), map -> {
        map.put(CandyCaneZebraVariant.ONE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_zebra.png"));
        map.put(CandyCaneZebraVariant.TWO, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_zebra_2.png"));
    });

    public CandyCaneZebraRenderer(EntityRendererProvider.Context context) {
        super(context, new CandyCaneZebraModel());
    }

    public ResourceLocation getTextureLocation(CandyCaneZebraEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(CandyCaneZebraEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

