/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.GummyBearModel;
import net.xstarlotte.snsnf.entity.client.variant.GummyBearVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.GummyBearEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class GummyBearRenderer
extends GeoEntityRenderer<GummyBearEntity> {
    private static final Map<GummyBearVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(GummyBearVariant.class), map -> {
        map.put(GummyBearVariant.APPLE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/apple_gummy_bear.png"));
        map.put(GummyBearVariant.BLACKBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/blackberry_gummy_bear.png"));
        map.put(GummyBearVariant.BLUEBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/blueberry_gummy_bear.png"));
        map.put(GummyBearVariant.CHERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/cherry_gummy_bear.png"));
        map.put(GummyBearVariant.COLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/cola_gummy_bear.png"));
        map.put(GummyBearVariant.LEMON, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/lemon_gummy_bear.png"));
        map.put(GummyBearVariant.LIME, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/lime_gummy_bear.png"));
        map.put(GummyBearVariant.MANGO, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/mango_gummy_bear.png"));
        map.put(GummyBearVariant.ORANGE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/orange_gummy_bear.png"));
        map.put(GummyBearVariant.PEACH, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/peach_gummy_bear.png"));
        map.put(GummyBearVariant.PINEAPPLE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/pineapple_gummy_bear.png"));
        map.put(GummyBearVariant.RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/raspberry_gummy_bear.png"));
        map.put(GummyBearVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/strawberry_gummy_bear.png"));
    });

    public GummyBearRenderer(EntityRendererProvider.Context context) {
        super(context, new GummyBearModel());
    }

    public ResourceLocation getTextureLocation(GummyBearEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(GummyBearEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.3f, 0.3f, 0.3f);
        } else {
            poseStack.scale(0.6f, 0.6f, 0.6f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

