/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.LaceSnakeModel;
import net.xstarlotte.snsnf.entity.client.variant.LaceSnakeVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.LaceSnakeEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class LaceSnakeRenderer
extends GeoEntityRenderer<LaceSnakeEntity> {
    private static final Map<LaceSnakeVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(LaceSnakeVariant.class), map -> {
        map.put(LaceSnakeVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/strawberry_lace_snake.png"));
        map.put(LaceSnakeVariant.COLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/cola_lace_snake.png"));
    });

    public LaceSnakeRenderer(EntityRendererProvider.Context context) {
        super(context, new LaceSnakeModel());
    }

    public ResourceLocation getTextureLocation(LaceSnakeEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(LaceSnakeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

