/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.MarshmallowSheepModel;
import net.xstarlotte.snsnf.entity.client.variant.MarshmallowSheepVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.MarshmallowSheepEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MarshmallowSheepRenderer
extends GeoEntityRenderer<MarshmallowSheepEntity> {
    private static final Map<MarshmallowSheepVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(MarshmallowSheepVariant.class), map -> {
        map.put(MarshmallowSheepVariant.VANILLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/vanilla_marshmallow_sheep.png"));
        map.put(MarshmallowSheepVariant.BLACKBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/blackberry_marshmallow_sheep.png"));
        map.put(MarshmallowSheepVariant.BLUEBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/blueberry_marshmallow_sheep.png"));
        map.put(MarshmallowSheepVariant.RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/raspberry_marshmallow_sheep.png"));
        map.put(MarshmallowSheepVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/strawberry_marshmallow_sheep.png"));
        map.put(MarshmallowSheepVariant.CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/chocolate_marshmallow_sheep.png"));
        map.put(MarshmallowSheepVariant.MINT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/mint_marshmallow_sheep.png"));
    });

    public MarshmallowSheepRenderer(EntityRendererProvider.Context context) {
        super(context, new MarshmallowSheepModel());
    }

    public ResourceLocation getTextureLocation(MarshmallowSheepEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(MarshmallowSheepEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

